/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent.capability;

import com.atlassian.bamboo.core.BambooEntityObject;
import com.atlassian.bamboo.utils.BambooInterners;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementSet;
import com.atlassian.bamboo.v2.build.requirement.ImmutableRequirement;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.hibernate.annotations.GenericGenerator;
import org.jetbrains.annotations.NotNull;

@Entity
@Table(name="REQUIREMENT")
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
public class RequirementImpl
extends BambooEntityObject
implements Requirement {
    private static final Logger log = Logger.getLogger(RequirementImpl.class);
    private String key;
    private String matchValue;
    private boolean regexMatch;
    private Boolean readonly = false;
    private RequirementSet requirementSet;
    private String pluginModuleKey;
    private long ownerId = -1L;

    public RequirementImpl() {
    }

    public RequirementImpl(String key, boolean regexMatch, String match) {
        this(key, regexMatch, match, false);
    }

    public RequirementImpl(String key, boolean regexMatch, String match, boolean readonly) {
        this.setKey(key);
        this.setRegexMatch(regexMatch);
        this.setMatchValue(match);
        this.setReadonly(readonly);
    }

    public RequirementImpl(@NotNull Requirement requirement) {
        this.setKey(requirement.getKey());
        this.setRegexMatch(requirement.isRegexMatch());
        this.setMatchValue(requirement.getMatchValue());
        this.setReadonly(requirement.isReadonly());
        this.setOwnerId(requirement.getOwnerId());
        this.setPluginModuleKey(requirement.getPluginModuleKey());
    }

    public boolean isSystemRequirement() {
        return this.key != null && this.key.startsWith("system");
    }

    @NotNull
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = BambooInterners.intern((String)key);
    }

    public String getMatchValue() {
        return this.matchValue;
    }

    public void setMatchValue(String matchValue) {
        this.matchValue = BambooInterners.intern((String)matchValue);
    }

    public boolean isRegexMatch() {
        return this.regexMatch;
    }

    public void setRegexMatch(Boolean regexMatch) {
        this.regexMatch = regexMatch;
    }

    public Boolean isReadonly() {
        return this.readonly != null && this.readonly != false;
    }

    public void setReadonly(Boolean readonly) {
        this.readonly = readonly != null && readonly != false;
    }

    public RequirementSet getRequirementSet() {
        return this.requirementSet;
    }

    public void setRequirementSet(RequirementSet requirementSet) {
        this.requirementSet = requirementSet;
    }

    public String getMatchType() {
        if (this.isRegexMatch()) {
            if (".*".equals(this.getMatchValue())) {
                return "exist";
            }
            return "match";
        }
        return "equal";
    }

    @NotNull
    public ImmutableRequirement.MatchType getTypeOfMatch() {
        if (this.isRegexMatch()) {
            if (".*".equals(this.getMatchValue())) {
                return ImmutableRequirement.MatchType.EXISTS;
            }
            return ImmutableRequirement.MatchType.MATCHES;
        }
        return ImmutableRequirement.MatchType.EQUALS;
    }

    public String getPluginModuleKey() {
        return this.pluginModuleKey;
    }

    public void setPluginModuleKey(String pluginModuleKey) {
        this.pluginModuleKey = BambooInterners.moduleKey((String)pluginModuleKey);
    }

    public long getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(long uniqueIdentifier) {
        this.ownerId = uniqueIdentifier;
    }

    public boolean belongsToPlugin() {
        return StringUtils.isNotEmpty((CharSequence)this.pluginModuleKey) && this.ownerId > -1L;
    }

    public String toString() {
        return this.key + (this.regexMatch ? " LIKE " : " = ") + this.matchValue;
    }

    public int hashCode() {
        return new HashCodeBuilder(7, 11).append((Object)this.getKey()).append((Object)this.getMatchValue()).append(this.isRegexMatch()).append((Object)this.isReadonly()).append((Object)this.getPluginModuleKey()).append(this.getOwnerId()).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof RequirementImpl)) {
            return false;
        }
        RequirementImpl rhs = (RequirementImpl)((Object)o);
        return new EqualsBuilder().append((Object)this.getKey(), (Object)rhs.getKey()).append((Object)this.getMatchValue(), (Object)rhs.getMatchValue()).append(this.isRegexMatch(), rhs.isRegexMatch()).append((Object)this.isReadonly(), (Object)rhs.isReadonly()).append((Object)this.getPluginModuleKey(), (Object)rhs.getPluginModuleKey()).append(this.getOwnerId(), rhs.getOwnerId()).isEquals();
    }

    public int compareTo(Object obj) {
        RequirementImpl o = (RequirementImpl)((Object)obj);
        return new CompareToBuilder().append((Object)this.getKey(), (Object)o.getKey()).append((Object)this.getMatchValue(), (Object)o.getMatchValue()).append(this.isRegexMatch(), o.isRegexMatch()).append((Object)this.isReadonly(), (Object)o.isReadonly()).append((Object)this.getPluginModuleKey(), (Object)o.getPluginModuleKey()).append(this.getOwnerId(), o.getOwnerId()).toComparison();
    }
}

