/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent.capability;

import com.atlassian.bamboo.utils.BambooPredicates;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.atlassian.bamboo.v2.build.requirement.ImmutableRequirement;
import com.google.common.base.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RequirementPredicates {
    public static Predicate<Requirement> getKeyEqualPredicate(@Nullable String key) {
        return new KeyEqualPredicate(key);
    }

    public static Predicate<Requirement> getKeyAndOwnerIdEqualPredicate(@Nullable String key, long ownerId) {
        return new KeyAndOwnerIdEqualPredicate(key, ownerId);
    }

    @Deprecated
    public static Predicate<Requirement> getIdEqualPredicate(long id) {
        return arg_0 -> BambooPredicates.hasBambooObjectEqualId(id).apply(arg_0);
    }

    public static Predicate<Requirement> getPluginRequirementsPredicate(@NotNull String pluginModuleKey, long ownerId) {
        return new IsPluginRequirement(pluginModuleKey, ownerId);
    }

    public static Predicate<Requirement> requirementKeyStartsWith(@NotNull String prefix) {
        return new KeyStartsWithPredicate(prefix);
    }

    @Deprecated
    public static Predicate<Requirement> requirementIsReadOnly() {
        return ImmutableRequirement::isReadonly;
    }

    @Deprecated
    public static Predicate<Requirement> requirementBelongsToAPlugin() {
        return Requirement::belongsToPlugin;
    }

    private static final class KeyStartsWithPredicate
    implements Predicate<Requirement> {
        private final String prefix;

        private KeyStartsWithPredicate(String prefix) {
            this.prefix = prefix;
        }

        public boolean apply(Requirement requirement) {
            return requirement.getKey().startsWith(this.prefix);
        }
    }

    private static class IsPluginRequirement
    implements Predicate<Requirement> {
        private String pluginModuleKey;
        private long ownerId;

        private IsPluginRequirement(String pluginModuleKey, long ownerId) {
            this.pluginModuleKey = pluginModuleKey;
            this.ownerId = ownerId;
        }

        public boolean apply(Requirement requirement) {
            return this.pluginModuleKey.equals(requirement.getPluginModuleKey()) && this.ownerId == requirement.getOwnerId();
        }
    }

    private static class KeyAndOwnerIdEqualPredicate
    implements Predicate<Requirement> {
        private String key;
        private long ownerId;

        private KeyAndOwnerIdEqualPredicate(String key, long ownerId) {
            this.key = key;
            this.ownerId = ownerId;
        }

        public boolean apply(Requirement input) {
            return input != null && input.getKey().equals(this.key) && input.getOwnerId() == this.ownerId;
        }
    }

    private static class KeyEqualPredicate
    implements Predicate<Requirement> {
        private String key;

        private KeyEqualPredicate(String key) {
            this.key = key;
        }

        public boolean apply(Requirement input) {
            return input != null && input.getKey().equals(this.key);
        }
    }
}

