/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent.capability;

import com.atlassian.bamboo.core.BambooEntityObject;
import com.atlassian.bamboo.utils.BambooPredicates;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementImpl;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementPredicates;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementSet;
import com.atlassian.bamboo.v2.build.requirement.ImmutableRequirement;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hibernate.annotations.GenericGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Entity
@Table(name="REQUIREMENT_SET")
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
public class RequirementSetImpl
extends BambooEntityObject
implements RequirementSet {
    private Set<Requirement> requirements;

    public RequirementSetImpl() {
    }

    public RequirementSetImpl(@NotNull RequirementSet other) {
        for (Requirement otherRequirement : other.getRequirements()) {
            this.addRequirement(new RequirementImpl(otherRequirement));
        }
    }

    public Requirement getRequirement(@NotNull String key, long ownerId) {
        return this.findRequirement(RequirementPredicates.getKeyAndOwnerIdEqualPredicate(key, ownerId));
    }

    public Requirement getRequirement(long id) {
        return this.findRequirement((Predicate<Requirement>)((Predicate)arg_0 -> BambooPredicates.hasBambooObjectEqualId(id).apply(arg_0)));
    }

    @NotNull
    public Set<Requirement> getRequirements() {
        if (this.requirements == null) {
            this.requirements = new HashSet<Requirement>();
        }
        return this.requirements;
    }

    public Set<Requirement> getRequirementsForPlugin(@NotNull String pluginModuleKey, long ownerId) {
        Set requirements = Sets.filter(this.getRequirements(), RequirementPredicates.getPluginRequirementsPredicate(pluginModuleKey, ownerId));
        return ImmutableSet.copyOf((Collection)requirements);
    }

    public void addRequirement(@NotNull Requirement requirement) {
        requirement.setRequirementSet((RequirementSet)this);
        this.getRequirements().add(requirement);
    }

    public void addAllRequirements(Iterable<Requirement> requirements) {
        for (Requirement requirement : requirements) {
            this.addRequirement(requirement);
        }
    }

    public boolean removeRequirement(@NotNull ImmutableRequirement requirement) {
        Requirement local;
        if (this.requirements != null && (local = this.getRequirement(requirement.getId())) != null) {
            local.setRequirementSet(null);
            return this.requirements.remove(local);
        }
        return false;
    }

    public int removeRequirements(@NotNull Predicate<Requirement> requirementPredicate) {
        if (this.requirements == null || this.requirements.isEmpty()) {
            return 0;
        }
        return this.removeRequirements(Sets.newHashSet((Iterable)Sets.filter(this.requirements, requirementPredicate)));
    }

    public int removeRequirements(@NotNull Iterable<Requirement> requirementIterable) {
        int count = 0;
        for (Requirement requirement : requirementIterable) {
            if (!this.removeRequirement((ImmutableRequirement)requirement)) continue;
            ++count;
        }
        return count;
    }

    @NotNull
    public Set<Requirement> getSystemRequirements(String type) {
        String systemPrefix = "system." + type;
        HashSet<Requirement> systemRequirements = new HashSet<Requirement>();
        for (Requirement requirement : this.getRequirements()) {
            if (!requirement.getKey().startsWith(systemPrefix)) continue;
            systemRequirements.add(requirement);
        }
        return systemRequirements;
    }

    @Nullable
    private Requirement findRequirement(Predicate<Requirement> predicate) {
        if (this.requirements == null) {
            return null;
        }
        for (Requirement requirement : this.requirements) {
            if (!predicate.apply((Object)requirement)) continue;
            return requirement;
        }
        return null;
    }

    public void setRequirements(Set<Requirement> requirements) {
        this.requirements = requirements;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append(this.requirements).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RequirementSetImpl)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RequirementSetImpl that = (RequirementSetImpl)((Object)o);
        return !(this.requirements != null ? !this.requirements.equals(that.requirements) : that.requirements != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.requirements != null ? this.requirements.hashCode() : 0);
        return result;
    }
}

