/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent.messages;

import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JmsSelectorUtils {
    private static final Logger log = Logger.getLogger(JmsSelectorUtils.class);
    public static final String JMS_PROPERTY_ALLOWABLE_AGENTS = "allowableAgents";

    private JmsSelectorUtils() {
    }

    public static String getAgentsMessageProperty(Collection<BuildAgent> executableAgents) {
        StringBuilder allowedAgentsBuffer = new StringBuilder();
        for (BuildAgent buildAgent : executableAgents) {
            if (allowedAgentsBuffer.length() != 0) {
                allowedAgentsBuffer.append(",");
            }
            allowedAgentsBuffer.append("[");
            allowedAgentsBuffer.append(buildAgent.getDefinition().getId());
            allowedAgentsBuffer.append("]");
        }
        return allowedAgentsBuffer.toString();
    }

    public static String getAgentsMessageProperty(Long buildAgentId) {
        return "[" + buildAgentId + "]";
    }

    public static String getAgentSelector(long id) {
        return JmsSelectorUtils.getAgentSelector(id, null);
    }

    public static String getAgentSelector(long id, @Nullable String fingerprint) {
        String agentIdentifier = "[" + id + "]";
        StringBuilder allowableSelector = new StringBuilder("allowableAgents LIKE '%" + agentIdentifier + "%'");
        if (fingerprint != null) {
            allowableSelector.append(" AND ").append("fingerprint").append(" = '").append(fingerprint).append("'");
        }
        log.debug((Object)("AgentSelector: " + allowableSelector));
        return allowableSelector.toString();
    }

    public static String getFingerprintSelector(@NotNull String fingerprint) {
        return "fingerprint = '" + fingerprint + "'";
    }
}

