/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.dependencies;

import com.atlassian.bamboo.build.PlanDependencyManager;
import com.atlassian.bamboo.configuration.ConfigurationException;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.cache.ImmutablePlanCacheService;
import com.atlassian.bamboo.v2.build.dependencies.DependencyTreeBuilder;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.codehaus.plexus.util.dag.CycleDetectedException;
import org.codehaus.plexus.util.dag.DAG;
import org.codehaus.plexus.util.dag.TopologicalSorter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependencyTreeBuilderImpl
implements DependencyTreeBuilder {
    private final ImmutablePlanCacheService immutablePlanCacheService;
    private final PlanDependencyManager planDependencyManager;

    public DependencyTreeBuilderImpl(ImmutablePlanCacheService immutablePlanCacheService, PlanDependencyManager planDependencyManager) {
        this.immutablePlanCacheService = immutablePlanCacheService;
        this.planDependencyManager = planDependencyManager;
    }

    public List<ImmutablePlan> getDirectParents(@NotNull ImmutablePlan plan) throws ConfigurationException {
        DAG dag = DependencyTreeBuilderImpl.buildDag(this.collectParents(plan, new LinkedHashSet<ImmutablePlan>()));
        return this.getBuildsFromLabels(plan.getPlanKey().getKey(), TopologicalSorter.sort((DAG)dag));
    }

    @VisibleForTesting
    DAG getDirectDependencyGraph(ImmutablePlan plan) throws ConfigurationException {
        LinkedList<Dependency> planPairs = new LinkedList<Dependency>();
        planPairs.addAll(this.collectParents(plan, new LinkedHashSet<ImmutablePlan>()));
        planPairs.addAll(this.collectChildren(plan, new LinkedHashSet<ImmutablePlan>()));
        return DependencyTreeBuilderImpl.buildDag(planPairs);
    }

    private static DAG buildDag(Iterable<Dependency> planPairs) throws ConfigurationException {
        DAG dag = new DAG();
        for (Dependency planDep : planPairs) {
            try {
                ImmutablePlan parent = planDep.parent;
                ImmutablePlan child = planDep.child;
                if (parent == null || child == null) continue;
                dag.addEdge(parent.getKey(), child.getKey());
            }
            catch (CycleDetectedException e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)e);
            }
        }
        return dag;
    }

    private Collection<Dependency> collectParents(@Nullable ImmutablePlan build, Set<ImmutablePlan> knownBuilds) {
        ArrayList<Dependency> pairs = new ArrayList<Dependency>();
        if (build == null || !knownBuilds.add(build)) {
            return pairs;
        }
        Set parentPlans = this.planDependencyManager.getEffectiveParentPlans(build);
        for (ImmutablePlan parentPlanDep : parentPlans) {
            pairs.add(new Dependency(parentPlanDep, build));
            pairs.addAll(this.collectParents(parentPlanDep, knownBuilds));
        }
        return pairs;
    }

    private Collection<Dependency> collectChildren(@Nullable ImmutablePlan build, Set<ImmutablePlan> knownBuilds) {
        ArrayList<Dependency> pairs = new ArrayList<Dependency>();
        if (build == null || !knownBuilds.add(build)) {
            return pairs;
        }
        Set childPlans = this.planDependencyManager.getEffectiveChildPlans(build);
        for (ImmutablePlan childPlanDep : childPlans) {
            pairs.add(new Dependency(build, childPlanDep));
            pairs.addAll(this.collectChildren(childPlanDep, knownBuilds));
        }
        return pairs;
    }

    private List<ImmutablePlan> getBuildsFromLabels(String startingBuildKey, Collection<String> labels) {
        labels.remove(startingBuildKey);
        LinkedList<ImmutablePlan> builds = new LinkedList<ImmutablePlan>();
        for (String label : labels) {
            ImmutableChain build = this.immutablePlanCacheService.getImmutablePlanByKey(PlanKeys.getPlanKey((String)label));
            if (build == null) continue;
            builds.add((ImmutablePlan)build);
        }
        Collections.reverse(builds);
        return builds;
    }

    private static class Dependency {
        ImmutablePlan child;
        ImmutablePlan parent;

        Dependency(ImmutablePlan parent, ImmutablePlan child) {
            this.parent = parent;
            this.child = child;
        }
    }
}

