/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.events;

import com.atlassian.bamboo.agent.elastic.server.ElasticAccountBean;
import com.atlassian.bamboo.agent.elastic.server.ElasticConfiguration;
import com.atlassian.bamboo.agent.elastic.server.ElasticInstanceManager;
import com.atlassian.bamboo.agent.elastic.server.RemoteElasticInstance;
import com.atlassian.bamboo.buildqueue.ElasticAgentDefinition;
import com.atlassian.bamboo.buildqueue.PipelineDefinition;
import com.atlassian.bamboo.v2.build.events.AgentOfflineEvent;
import com.atlassian.event.api.EventListener;
import org.apache.log4j.Logger;

public class AgentOfflineEventListener {
    private static final Logger log = Logger.getLogger(AgentOfflineEventListener.class);
    private final ElasticAccountBean elasticAccountBean;
    private final ElasticInstanceManager elasticInstanceManager;

    public AgentOfflineEventListener(ElasticAccountBean elasticAccountBean, ElasticInstanceManager elasticInstanceManager) {
        this.elasticAccountBean = elasticAccountBean;
        this.elasticInstanceManager = elasticInstanceManager;
    }

    @EventListener
    public void handleEvent(AgentOfflineEvent event) {
        PipelineDefinition pipelineDefinition;
        ElasticConfiguration elasticConfiguration = this.elasticAccountBean.getElasticConfig();
        if (elasticConfiguration != null && elasticConfiguration.isEnabled() && elasticConfiguration.isAutoShutdownEnabled() && (pipelineDefinition = event.getBuildAgent().getDefinition()) instanceof ElasticAgentDefinition) {
            ElasticAgentDefinition elasticAgentDefinition = (ElasticAgentDefinition)pipelineDefinition;
            String elasticInstanceId = elasticAgentDefinition.getElasticInstanceId();
            RemoteElasticInstance remoteElasticInstance = this.elasticInstanceManager.getElasticRemoteAgentByInstanceId(elasticInstanceId);
            if (remoteElasticInstance != null && remoteElasticInstance.isShutdownable() && !remoteElasticInstance.isBeingTerminated()) {
                remoteElasticInstance.triggerDelayedTermination((long)elasticConfiguration.getAutoShutdownDelay());
            } else {
                log.error((Object)("Elastic instance " + elasticInstanceId + " does not exist or has already been shut down"));
            }
        }
    }
}

