/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.events;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.Buildable;
import com.atlassian.bamboo.build.CustomBuildCompleteAction;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.container.PersisterFactory;
import com.atlassian.bamboo.event.BuildCompletedEvent;
import com.atlassian.bamboo.logger.ErrorUpdateHandler;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableBuildable;
import com.atlassian.bamboo.plugin.descriptor.CustomBuildCompleteActionModuleDescriptor;
import com.atlassian.bamboo.results.BuildResults;
import com.atlassian.bamboo.variable.CustomVariableContextRunner;
import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.PluginAccessor;
import io.atlassian.fugue.Suppliers;
import java.util.List;
import java.util.function.Supplier;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BuildCompletedEventListener {
    private static final Logger log = Logger.getLogger(BuildCompletedEventListener.class);
    private final CustomVariableContextRunner customVariableContextRunner;
    private final ErrorUpdateHandler errorUpdateHandler;
    private final CachedPlanManager cachedPlanManager;
    private final PlanManager planManager;
    private final PluginAccessor pluginAccessor;

    public BuildCompletedEventListener(CustomVariableContextRunner customVariableContextRunner, ErrorUpdateHandler errorUpdateHandler, CachedPlanManager cachedPlanManager, PlanManager planManager, PluginAccessor pluginAccessor) {
        this.customVariableContextRunner = customVariableContextRunner;
        this.errorUpdateHandler = errorUpdateHandler;
        this.cachedPlanManager = cachedPlanManager;
        this.pluginAccessor = pluginAccessor;
        this.planManager = planManager;
    }

    @EventListener
    public void handleEvent(BuildCompletedEvent event) {
        PlanKey planKey = event.getPlanKey();
        int buildNumber = event.getBuildNumber();
        ImmutableBuildable buildable = (ImmutableBuildable)this.cachedPlanManager.getPlanByKeyIfOfType(planKey, ImmutableBuildable.class);
        if (buildable != null) {
            BuildResults buildResults = PersisterFactory.getInstance().getBuildResults((Key)planKey, buildNumber);
            log.info((Object)("Running build post actions '" + buildable.getKey() + "'"));
            this.performCustomBuildCompleteAction(buildable, buildResults);
        }
    }

    private void performCustomBuildCompleteAction(@NotNull ImmutableBuildable buildable, BuildResults buildResults) {
        List moduleDescriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(CustomBuildCompleteActionModuleDescriptor.class);
        boolean buildSuccessful = buildResults.getBuildState() == BuildState.SUCCESS;
        Supplier buildableSupplier = Suppliers.memoize(() -> (Buildable)this.planManager.getPlanByKeyIfOfType(buildable.getPlanKey(), Buildable.class));
        moduleDescriptors.stream().filter(moduleDescriptor -> !moduleDescriptor.skipIfFailed() || buildSuccessful).forEach(arg_0 -> this.lambda$performCustomBuildCompleteAction$2(buildable, (Supplier)buildableSupplier, buildResults, arg_0));
    }

    private void performCustomBuildCompleteAction(CustomBuildCompleteActionModuleDescriptor moduleDescriptor, @NotNull ImmutableBuildable buildable, @NotNull Supplier<Buildable> mutableBuildableSupplier, BuildResults buildResults) {
        PlanKey planKey = buildable.getPlanKey();
        CustomBuildCompleteAction buildProcessor = (CustomBuildCompleteAction)moduleDescriptor.getModule();
        if (buildProcessor != null) {
            log.debug((Object)String.format("Running CustomBuildCompleteActionModuleDescriptor '%s'", moduleDescriptor.getName()));
            try {
                this.customVariableContextRunner.execute((PlanIdentifier)buildable, () -> {
                    try {
                        buildProcessor.run(buildable, buildResults);
                    }
                    catch (IncompatibleClassChangeError e) {
                        Buildable mutableBuildable = (Buildable)mutableBuildableSupplier.get();
                        if (mutableBuildable != null) {
                            buildProcessor.run((Buildable)mutableBuildableSupplier.get(), buildResults);
                        }
                        log.info((Object)("Build post process aborted. Plan " + planKey + " has been deleted."));
                    }
                });
            }
            catch (Exception e) {
                this.errorUpdateHandler.recordError((ResultKey)PlanKeys.getPlanResultKey((String)buildResults.getBuildResultsKey()), moduleDescriptor.getName() + " custom build complete action failed to run", (Throwable)e);
            }
        }
    }

    private /* synthetic */ void lambda$performCustomBuildCompleteAction$2(ImmutableBuildable buildable, Supplier buildableSupplier, BuildResults buildResults, CustomBuildCompleteActionModuleDescriptor moduleDescriptor) {
        this.performCustomBuildCompleteAction(moduleDescriptor, buildable, buildableSupplier, buildResults);
    }
}

