/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.events;

import com.atlassian.aws.AWSException;
import com.atlassian.bamboo.agent.elastic.server.ElasticFunctionalityFacade;
import com.atlassian.bamboo.buildqueue.ElasticAgentDefinition;
import com.atlassian.bamboo.buildqueue.PipelineDefinition;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.v2.build.events.AgentOfflineEvent;
import com.atlassian.event.api.EventListener;
import org.apache.log4j.Logger;

public class ElasticInstanceShutDownOnAgentOfflineListener {
    private static final Logger log = Logger.getLogger(ElasticInstanceShutDownOnAgentOfflineListener.class);
    private final ElasticFunctionalityFacade elasticFunctionalityFacade;

    public ElasticInstanceShutDownOnAgentOfflineListener(ElasticFunctionalityFacade elasticFunctionalityFacade) {
        this.elasticFunctionalityFacade = elasticFunctionalityFacade;
    }

    @EventListener
    public void handleEvent(AgentOfflineEvent event) {
        BuildAgent buildAgent = event.getBuildAgent();
        PipelineDefinition pipelineDefinition = buildAgent.getDefinition();
        if (pipelineDefinition instanceof ElasticAgentDefinition && buildAgent.isRequestedToBeStopped()) {
            ElasticAgentDefinition elasticAgentDefinition = (ElasticAgentDefinition)pipelineDefinition;
            String elasticInstanceId = elasticAgentDefinition.getElasticInstanceId();
            try {
                this.elasticFunctionalityFacade.shutdownInstance(elasticInstanceId);
            }
            catch (AWSException e) {
                log.error((Object)("Unable to shutdown instance " + elasticInstanceId), (Throwable)e);
            }
        }
    }
}

