/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.events;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.CustomPostBuildCompletedAction;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.logger.ErrorUpdateHandler;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plugin.descriptor.CustomPostBuildCompletedActionModuleDescriptor;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.v2.build.events.PostBuildCompletedEvent;
import com.atlassian.bamboo.variable.CustomVariableContextRunner;
import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.PluginAccessor;
import java.util.List;
import org.apache.log4j.Logger;

public class PostBuildCompletedEventListener {
    private static final Logger log = Logger.getLogger(PostBuildCompletedEventListener.class);
    private CachedPlanManager cachedPlanManager;
    private CustomVariableContextRunner customVariableContextRunner;
    private ErrorUpdateHandler errorUpdateHandler;
    private PluginAccessor pluginAccessor;

    public PostBuildCompletedEventListener(CachedPlanManager cachedPlanManager, CustomVariableContextRunner customVariableContextRunner, ErrorUpdateHandler errorUpdateHandler, PluginAccessor pluginAccessor) {
        this.customVariableContextRunner = customVariableContextRunner;
        this.errorUpdateHandler = errorUpdateHandler;
        this.cachedPlanManager = cachedPlanManager;
        this.pluginAccessor = pluginAccessor;
    }

    @EventListener
    public void handleEvent(PostBuildCompletedEvent event) {
        log.debug((Object)("Running build post actions '" + event.getContext().getPlanName() + "'"));
        this.performAction(event.getContext());
    }

    private void performAction(final BuildContext buildContext) {
        final List moduleDescriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(CustomPostBuildCompletedActionModuleDescriptor.class);
        if (moduleDescriptors.isEmpty()) {
            return;
        }
        final boolean buildSuccessful = buildContext.getBuildResult().getBuildState() == BuildState.SUCCESS;
        this.customVariableContextRunner.execute((CommonContext)buildContext, new Runnable(){

            @Override
            public void run() {
                moduleDescriptors.stream().filter(moduleDescriptor -> !moduleDescriptor.skipIfFailed() || buildSuccessful).forEach(moduleDescriptor -> PostBuildCompletedEventListener.this.performAction(moduleDescriptor, buildContext));
            }
        });
    }

    private void performAction(CustomPostBuildCompletedActionModuleDescriptor moduleDescriptor, BuildContext buildContext) {
        CustomPostBuildCompletedAction processor = (CustomPostBuildCompletedAction)moduleDescriptor.getModule();
        if (processor == null) {
            return;
        }
        log.debug((Object)String.format("Running CustomPostBuildCompletedAction '%s'", moduleDescriptor.getName()));
        try {
            PlanKey planKey = buildContext.getPlanResultKey().getPlanKey();
            if (this.cachedPlanManager.getPlanByKey(planKey) != null) {
                processor.init(buildContext);
                processor.call();
            } else {
                log.info((Object)("Build post process aborted. Build " + planKey + " has been deleted."));
            }
        }
        catch (Exception e) {
            this.errorUpdateHandler.recordError((ResultKey)buildContext.getPlanResultKey(), moduleDescriptor.getName() + " custom build post complete action failed to run", (Throwable)e);
        }
    }
}

