/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.queue;

import com.atlassian.bamboo.persister.xstream.CustomizableXStreamFactory;
import com.atlassian.bamboo.persister.xstream.XStreamFactory;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.queue.MessageConverterProxy;
import com.atlassian.bamboo.v2.build.queue.SelfSerialisingMessage;
import com.thoughtworks.xstream.XStream;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.jms.support.converter.MessageConversionException;
import org.springframework.jms.support.converter.MessageConverter;

public class BambooMessageConverter
implements MessageConverter {
    private static final Logger log = Logger.getLogger(BambooMessageConverter.class);
    private final XStream xStream;
    private static final String CUSTOM_SERIALISER = "CUSTOM_SERIALISER";
    private final MessageConverterProxy logMessageBatchConverter;

    @Deprecated
    public BambooMessageConverter() {
        this(new CustomizableXStreamFactory());
    }

    public BambooMessageConverter(@NotNull XStreamFactory xStreamFactory) {
        this.xStream = this.createXStream(xStreamFactory);
        this.logMessageBatchConverter = new MessageConverterProxy("com.atlassian.bamboo.v2.build.agent.LogMessageBatchConverter");
    }

    private XStream createXStream(XStreamFactory xStreamFactory) {
        if (log.isTraceEnabled()) {
            return xStreamFactory.createXStream();
        }
        return xStreamFactory.createCompactXStream();
    }

    public Message toMessage(@NotNull Object object, @NotNull Session session) throws JMSException, MessageConversionException {
        SelfSerialisingMessage selfSerialisingObject = (SelfSerialisingMessage)Narrow.downTo((Object)object, SelfSerialisingMessage.class);
        if (selfSerialisingObject != null) {
            Message message = this.logMessageBatchConverter.toMessage(object, session);
            this.setDeserialiserId(message, selfSerialisingObject.getDeserialiserId());
            return message;
        }
        String xmlString = this.xStream.toXML(object);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending XML of class " + object.getClass() + "  message of size: " + xmlString.length() + " chars"));
            if (log.isTraceEnabled()) {
                log.trace((Object)("Sending xml:\n" + xmlString));
            }
        }
        return session.createTextMessage(xmlString);
    }

    public Object fromMessage(Message message) throws JMSException, MessageConversionException {
        if (this.getDeserialiserId(message) != null) {
            return this.logMessageBatchConverter.fromMessage(message);
        }
        long start = System.currentTimeMillis();
        TextMessage xml = (TextMessage)message;
        String xmlString = xml.getText();
        Object result = this.xStream.fromXML(xmlString);
        if (log.isDebugEnabled()) {
            long timeTaken;
            log.debug((Object)("Received XML of class " + result.getClass() + "  message of size: " + xmlString.length() + " chars"));
            if (log.isTraceEnabled()) {
                log.trace((Object)("Received xml:\n" + xmlString));
            }
            if (result.getClass().getCanonicalName().contains("BatchRemoteBamboo") && (timeTaken = System.currentTimeMillis() - start) > 100L) {
                log.info((Object)("fromMessage took: " + timeTaken + "ms"));
            }
        }
        return result;
    }

    private Object getDeserialiserId(Message message) throws JMSException {
        return message.getObjectProperty(CUSTOM_SERIALISER);
    }

    private void setDeserialiserId(Message message, int serialiserId) throws JMSException {
        message.setIntProperty(CUSTOM_SERIALISER, serialiserId);
    }
}

