/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.queue;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.build.BuildExecutionManager;
import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.buildqueue.manager.CustomPreBuildQueuedAction;
import com.atlassian.bamboo.concurrent.CoalescingBlockedCallsReference;
import com.atlassian.bamboo.execution.ExecutionPhaseService;
import com.atlassian.bamboo.fileserver.SystemDirectory;
import com.atlassian.bamboo.logger.ErrorUpdateHandler;
import com.atlassian.bamboo.persister.xstream.XStreamFactory;
import com.atlassian.bamboo.plan.ExecutableAgentsHelper;
import com.atlassian.bamboo.util.BambooDebugUtils;
import com.atlassian.bamboo.util.BambooObjectUtils;
import com.atlassian.bamboo.util.BambooSpringUtils;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.BambooLogUtils;
import com.atlassian.bamboo.utils.concurrent.BambooLocks;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.v2.build.agent.LocalResultProcessor;
import com.atlassian.bamboo.v2.build.events.BuildQueuedEvent;
import com.atlassian.bamboo.v2.build.events.ExecutableQueueUpdate;
import com.atlassian.bamboo.v2.build.queue.BuildPreQueuedActionFailureException;
import com.atlassian.bamboo.v2.build.queue.BuildQueueManager;
import com.atlassian.bamboo.v2.build.queue.BuildQueuePosition;
import com.atlassian.bamboo.v2.build.queue.ExecutableOrderProvider;
import com.atlassian.bamboo.v2.build.queue.ExecutorCalculator;
import com.atlassian.bamboo.v2.build.queue.QueueManagerUtils;
import com.atlassian.bamboo.v2.build.queue.QueueOfExecutables;
import com.atlassian.bamboo.v2.build.queue.order.FifoExecutableOrderProvider;
import com.atlassian.bamboo.v2.build.queue.queues.CommonContextPersister;
import com.atlassian.bamboo.v2.build.queue.queues.OffloadingQueueOfExecutables;
import com.atlassian.bamboo.v2.build.queue.queues.XStreamQueuePersisterImpl;
import com.atlassian.bamboo.variable.CustomVariableContextRunner;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.File;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.transaction.support.TransactionTemplate;

public class BuildQueueManagerImpl
implements BuildQueueManager {
    private static final Logger log = Logger.getLogger(BuildQueueManagerImpl.class);
    private static final String QUEUE_STATE_DIRECTORY = "queue";
    private final ExecutableOrderProvider orderProvider;
    private final AgentManager agentManager;
    private final BuildExecutionManager buildExecutionManager;
    private final EventPublisher eventPublisher;
    @Lazy
    @Inject
    private AutowireCapableBeanFactory beanFactory;
    private final PluginAccessor pluginAccessor;
    private final ErrorUpdateHandler errorUpdateHandler;
    private final ExecutableAgentsHelper executableAgentsHelper;
    private final CustomVariableContextRunner customVariableContextRunner;
    private final ExecutionPhaseService executionPhaseService;
    private QueueOfExecutables queueOfExecutables;
    private final ReentrantLock orderAndContentSyncLock = new ReentrantLock();
    private final LocalResultProcessor resultProcessor;
    private final CoalescingBlockedCallsReference<Void> recalculateAllExecutors;
    private final TransactionTemplate readOnlyTransactionTemplate;
    private final long maximumLockTimeMs;
    private final CommonContextPersister persister;
    private final LoadingCache<ResultKey, BambooLocks.CloseableLock> enqueueLocks = BambooLocks.closeableLockFactory();

    @Inject
    public BuildQueueManagerImpl(@NotNull AgentManager agentManager, @NotNull EventPublisher eventPublisher, @NotNull BuildExecutionManager buildExecutionManager, @NotNull PluginAccessor pluginAccessor, @NotNull ErrorUpdateHandler errorUpdateHandler, @NotNull ExecutableAgentsHelper executableAgentsHelper, @NotNull CustomVariableContextRunner customVariableContextRunner, @NotNull ExecutionPhaseService executionPhaseService, @NotNull XStreamFactory xStreamFactory, @NotNull TransactionTemplate transactionTemplate, @NotNull LocalResultProcessor resultProcessor) {
        this.agentManager = agentManager;
        this.eventPublisher = eventPublisher;
        this.buildExecutionManager = buildExecutionManager;
        this.pluginAccessor = pluginAccessor;
        this.errorUpdateHandler = errorUpdateHandler;
        this.executionPhaseService = executionPhaseService;
        this.executableAgentsHelper = executableAgentsHelper;
        this.customVariableContextRunner = customVariableContextRunner;
        this.resultProcessor = resultProcessor;
        File queueStateDirectory = new File(SystemDirectory.getServerStateDirectory(), QUEUE_STATE_DIRECTORY);
        this.persister = new XStreamQueuePersisterImpl(xStreamFactory.createCompactXStream(), queueStateDirectory);
        this.orderProvider = new FifoExecutableOrderProvider();
        this.readOnlyTransactionTemplate = BambooSpringUtils.readOnly(transactionTemplate);
        this.maximumLockTimeMs = TimeUnit.SECONDS.toMillis(30L);
        this.recalculateAllExecutors = CoalescingBlockedCallsReference.make(new Runnable(){
            private final AtomicInteger recalculationCounter = new AtomicInteger();

            @Override
            public void run() {
                BuildQueueManagerImpl.this.readOnlyTransactionTemplate.execute(tx -> {
                    int recalculationNumber = this.recalculationCounter.getAndIncrement();
                    log.info((Object)("Recalculation #" + recalculationNumber + " started"));
                    Stopwatch stopWatch = Stopwatch.createStarted();
                    BuildQueueManagerImpl.this.queueOfExecutables.recalculateExecutors();
                    log.info((Object)("Recalculation #" + recalculationNumber + " took " + stopWatch));
                    return null;
                });
            }
        });
    }

    @PostConstruct
    private void postConstruct() {
        ExecutorCalculator executorCalculator = BambooSpringUtils.autowireComponent(this.beanFactory, new ExecutorCalculator());
        this.queueOfExecutables = new OffloadingQueueOfExecutables(executorCalculator, this.persister);
    }

    public void addToQueue(@NotNull CommonContext context) {
        this.withEnqueueLock(context.getResultKey(), () -> this.doAddToQueue(context));
    }

    private void withEnqueueLock(ResultKey resultKey, Runnable runnable) {
        BambooLocks.CloseableLock enqueueLock = (BambooLocks.CloseableLock)this.enqueueLocks.getUnchecked((Object)resultKey);
        try (BambooLocks.AutoCloseableLock ignored = enqueueLock.lock();){
            runnable.run();
        }
    }

    private void doAddToQueue(@NotNull CommonContext context) {
        log.info((Object)("Attempting to queue " + context.getDisplayName() + "."));
        if (this.queueOfExecutables.get(context.getResultKey()) != null) {
            throw new IllegalStateException("Context " + context.getDisplayName() + " is already queued");
        }
        BuildContext buildContext = (BuildContext)Narrow.downTo((Object)context, BuildContext.class);
        if (buildContext != null) {
            try {
                this.fireCustomPreBuildQueuedActions(buildContext);
            }
            catch (BuildPreQueuedActionFailureException exception) {
                this.errorUpdateHandler.recordError(buildContext.getResultKey(), "Build was not queued due to error", (Throwable)exception);
                this.terminateBuild((CommonContext)buildContext);
                return;
            }
        }
        this.executionPhaseService.queued(context);
        boolean success = (Boolean)this.readOnlyTransactionTemplate.execute(tx -> {
            this.orderAndContentSyncLock.lock();
            try {
                boolean isEnqueued = this.queueOfExecutables.enqueue(context, null);
                if (!isEnqueued) {
                    Boolean bl = false;
                    return bl;
                }
                this.orderProvider.onEnqueue(Collections.singletonList(context));
            }
            catch (RuntimeException e) {
                log.error((Object)"", (Throwable)e);
                throw e;
            }
            finally {
                this.orderAndContentSyncLock.unlock();
            }
            return true;
        });
        if (!success) {
            log.error((Object)("Unable to queue " + context.getDisplayName()));
            return;
        }
        if (buildContext != null) {
            this.eventPublisher.publish((Object)new BuildQueuedEvent(this, buildContext));
        }
        ExecutableQueueUpdate event = new ExecutableQueueUpdate("addToQueue");
        this.eventPublisher.publish((Object)event);
        log.info((Object)("Sent " + event));
    }

    public void removeBuildFromQueue(@NotNull ResultKey resultKey) {
        CommonContext context;
        log.info((Object)("Attempting to remove from queue: " + resultKey));
        this.orderAndContentSyncLock.lock();
        try {
            context = this.queueOfExecutables.remove(resultKey);
            if (context != null) {
                this.orderProvider.onDequeue(context);
            }
        }
        finally {
            this.orderAndContentSyncLock.unlock();
        }
        if (context != null) {
            this.resultProcessor.processResult(context);
        } else {
            this.resultProcessor.terminateResult(resultKey);
        }
    }

    public boolean reorderInQueue(ResultKey resultKey, int index) {
        return this.orderProvider.reorder(resultKey, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public BuildQueuePosition getQueuePosition(@NotNull ResultKey resultKey) {
        this.orderAndContentSyncLock.lock();
        try {
            int position = Iterables.indexOf((Iterable)this.orderProvider.getOrderedExecutables(), QueueManagerUtils.hasResultKeyEqualTo((ResultKey)resultKey)::test);
            BuildQueuePosition buildQueuePosition = new BuildQueuePosition(this.queueOfExecutables.size(), position);
            return buildQueuePosition;
        }
        finally {
            this.orderAndContentSyncLock.unlock();
        }
    }

    public void invalidateExecutors(@NotNull String reason) {
        try {
            log.info((Object)("Recalculating all executors : " + reason));
            this.recalculateAllExecutors.get();
        }
        catch (Exception e) {
            throw BambooObjectUtils.asRuntimeException((Throwable)e);
        }
        this.eventPublisher.publish((Object)new ExecutableQueueUpdate("invalidate executors: " + reason));
    }

    public void invalidateExecutors(@NotNull Key key) {
        log.info((Object)("Recalculating executors for " + key));
        this.readOnlyTransactionTemplate.execute(tx -> {
            this.queueOfExecutables.recalculateExecutors(Collections.singleton(key));
            return null;
        });
        this.eventPublisher.publish((Object)new ExecutableQueueUpdate("invalidate executors: " + key));
    }

    public void invalidateExecutables(@NotNull BuildAgent buildAgent) {
        log.info((Object)("Recalculating executables for agent [" + buildAgent.getName() + ']'));
        this.readOnlyTransactionTemplate.execute(tx -> {
            this.queueOfExecutables.recalculateExecutables(buildAgent);
            return null;
        });
        ExecutableQueueUpdate event = new ExecutableQueueUpdate("invalidate executables: " + buildAgent.getName());
        event.setAffectedAgentIds(Collections.singleton(buildAgent.getId()));
        this.eventPublisher.publish((Object)event);
    }

    @NotNull
    public Iterable<BuildQueueManager.QueuedResultKey> getQueuedExecutables() {
        return this.orderProvider.getOrderedExecutables();
    }

    @Nullable
    public Collection<ElasticImageConfiguration> getImagesForQueuedExecutable(@NotNull ResultKey resultKey) {
        return this.queueOfExecutables.getImagesForExecutable(resultKey);
    }

    @Nullable
    public Set<Long> getExecutorsForQueuedExecutable(@NotNull ResultKey resultKey) {
        return this.queueOfExecutables.getExecutorsForExecutable(resultKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public BuildQueueManager.QueueItemView<CommonContext> peekContext(@NotNull ResultKey resultKey) {
        ReentrantLock reentrantLock = this.orderAndContentSyncLock;
        synchronized (reentrantLock) {
            BuildQueueManager.QueuedResultKey queuedResultKey = this.orderProvider.getOrderedExecutables().stream().filter(QueueManagerUtils.hasResultKeyEqualTo((ResultKey)resultKey)).findFirst().orElse(null);
            if (queuedResultKey == null) {
                return null;
            }
            CommonContext commonContext = this.queueOfExecutables.get(resultKey);
            if (commonContext == null) {
                return null;
            }
            return new BuildQueueManager.QueueItemView(queuedResultKey, (Object)commonContext);
        }
    }

    private void fireCustomPreBuildQueuedActions(BuildContext buildContext) throws BuildPreQueuedActionFailureException {
        List modules = this.pluginAccessor.getEnabledModulesByClass(CustomPreBuildQueuedAction.class);
        if (modules.isEmpty()) {
            return;
        }
        try {
            this.customVariableContextRunner.execute((CommonContext)buildContext, () -> {
                for (CustomPreBuildQueuedAction preBuildQueuedAction : modules) {
                    log.debug((Object)("Running pre-build queued event handler " + preBuildQueuedAction));
                    preBuildQueuedAction.init(buildContext);
                    preBuildQueuedAction.call();
                }
                return null;
            });
        }
        catch (Exception e) {
            throw new BuildPreQueuedActionFailureException(e);
        }
    }

    public void restoreState(Set<ResultKey> resultsToRestore) {
        this.persister.loadAndRemoveAll().filter(c -> resultsToRestore.contains(c.getContext().getResultKey())).forEach(contextWithMetadata -> this.readOnlyTransactionTemplate.execute(tx -> {
            CommonContext context = contextWithMetadata.getContext();
            ResultKey resultKey = context.getResultKey();
            this.withEnqueueLock(resultKey, () -> {
                if (this.queueOfExecutables.get(resultKey) != null) {
                    log.info((Object)("Not restoring " + context.getDisplayName() + ", it's already queued"));
                    return;
                }
                this.orderAndContentSyncLock.lock();
                try {
                    if (!this.queueOfExecutables.enqueue(context, contextWithMetadata.getRequirements())) {
                        return;
                    }
                    this.orderProvider.onEnqueue(Collections.singletonList(context));
                }
                catch (RuntimeException e) {
                    log.error((Object)("Error when restoring state of " + context.getDisplayName()), (Throwable)e);
                }
                finally {
                    this.orderAndContentSyncLock.unlock();
                }
            });
            return null;
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CommonContext takeBuildContext(long agentId) throws InterruptedException {
        Stopwatch stopWatch = Stopwatch.createStarted();
        BuildAgent agent = this.agentManager.getAgent(agentId);
        Preconditions.checkState((agent != null ? 1 : 0) != 0, (String)"Unable to find agent with id %s", (Object[])new Object[]{agentId});
        log.debug((Object)("takeBuildContext invoked by agent " + agent));
        CommonContext commonContext = null;
        try {
            CommonContext commonContext2 = commonContext = this.doTakeBuildContext(agent);
            return commonContext2;
        }
        finally {
            if (commonContext == null) {
                BambooLogUtils.logOperationTime((Logger)log, (Stopwatch)stopWatch, (Duration)Duration.ofMillis(5L), (Duration)Duration.ofMillis(100L), (Duration)Duration.ofMillis(1000L), (String)"takeBuildContext");
            } else {
                BambooLogUtils.logOperationTime((Logger)log, (Stopwatch)stopWatch, (Duration)Duration.ofMillis(50L), (Duration)Duration.ofMillis(200L), (Duration)Duration.ofMillis(1000L), (String)"takeBuildContext");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private CommonContext doTakeBuildContext(BuildAgent agent) throws InterruptedException {
        ResultKey executableForAgent;
        long agentId = agent.getId();
        ImmutableList executableData = this.queueOfExecutables.executablesForAgent(agentId);
        if (executableData.isEmpty()) {
            log.debug((Object)("No executables for agent " + agent));
            return null;
        }
        if (!this.executableAgentsHelper.isAgentEligibleForReceivingJobs(agentId)) {
            log.debug((Object)String.format("The agent %d doesn't seem to be considered active by the Bamboo server. Refusing to send any build to it", agentId));
            return null;
        }
        while ((executableForAgent = this.orderProvider.findExecutableForAgent(agentId, (Collection)executableData)) != null) {
            if (this.orderAndContentSyncLock.tryLock(this.maximumLockTimeMs, TimeUnit.MILLISECONDS)) {
                try {
                    CommonContext commonContext = this.queueOfExecutables.inflight(executableForAgent);
                    if (commonContext != null) {
                        this.orderProvider.onDequeue(commonContext);
                        log.info((Object)("Sending " + commonContext.getResultKey() + " to agent " + agent));
                        CommonContext commonContext2 = commonContext;
                        return commonContext2;
                    }
                    log.debug((Object)(agent + ": some agent stole our first executable: " + executableData + ", trying again"));
                    continue;
                }
                finally {
                    this.orderAndContentSyncLock.unlock();
                    continue;
                }
            }
            String message = "Couldn't get lock on queue for " + this.maximumLockTimeMs + "ms";
            Logger emergencyLog = BambooDebugUtils.emergencyLog();
            log.warn((Object)message);
            emergencyLog.warn((Object)message);
            emergencyLog.warn((Object)BambooDebugUtils.getAllStackTraces());
            return null;
        }
        log.debug((Object)(agent + ": some agents stole all our executables: " + executableData));
        return null;
    }

    private void terminateBuild(@Nullable CommonContext context) {
        BuildContext buildContext = (BuildContext)Narrow.downTo((Object)context, BuildContext.class);
        if (buildContext != null) {
            buildContext.getBuildResult().setLifeCycleState(LifeCycleState.NOT_BUILT);
            this.buildExecutionManager.finishBuild(buildContext.getPlanResultKey(), true);
        }
    }
}

