/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.queue;

import com.atlassian.bamboo.event.AgentConfigurationUpdatedEvent;
import com.atlassian.bamboo.event.AllAgentsUpdatedEvent;
import com.atlassian.bamboo.event.agent.AgentAssignmentsUpdatedEvent;
import com.atlassian.bamboo.event.elastic.ElasticImageConfigurationChangedEvent;
import com.atlassian.bamboo.v2.build.queue.BuildQueueManager;
import com.atlassian.event.api.EventListener;
import javax.inject.Inject;
import org.apache.log4j.Logger;

public class BuildQueueUpdateListener {
    private static final Logger log = Logger.getLogger(BuildQueueUpdateListener.class);
    @Inject
    private BuildQueueManager buildQueueManager;

    @EventListener
    public void onAgentConfigurationUpdatedEvent(AgentConfigurationUpdatedEvent event) {
        log.debug((Object)("Agent [" + event.getBuildAgent().getName() + "] configuration updated: " + event.getBuildAgent().getAgentStatus()));
        this.buildQueueManager.invalidateExecutables(event.getBuildAgent());
    }

    @EventListener
    public void onElasticImageConfigurationUpdatedEvent(ElasticImageConfigurationChangedEvent event) {
        this.buildQueueManager.invalidateExecutors(event.toString());
    }

    @EventListener
    public void onAgentAssignmentsUpdatedEvent(AgentAssignmentsUpdatedEvent event) {
        this.buildQueueManager.invalidateExecutors(event.toString());
    }

    @EventListener
    public void onAllAgentsUpdatedEvent(AllAgentsUpdatedEvent event) {
        this.buildQueueManager.invalidateExecutors(event.toString());
    }
}

