/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.queue;

import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.build.BuildExecutionManager;
import com.atlassian.bamboo.buildqueue.manager.AgentAssignmentServiceHelper;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentService;
import com.atlassian.bamboo.deployments.execution.DeploymentContext;
import com.atlassian.bamboo.plan.ExecutableAgentsHelper;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableBuildable;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementSet;
import com.atlassian.bamboo.v2.build.queue.queues.CommonContextMap;
import com.atlassian.bamboo.v2.build.requirement.ImmutableRequirementSet;
import java.util.Collection;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutorCalculator {
    private static final Logger log = Logger.getLogger(ExecutorCalculator.class);
    @Inject
    private CachedPlanManager cachedPlanManager;
    @Inject
    private EnvironmentService environmentService;
    @Inject
    private ExecutableAgentsHelper executableAgentsHelper;
    @Inject
    private BuildExecutionManager buildExecutionManager;

    @NotNull
    public Collection<BuildAgent> calculateExecutors(@NotNull CommonContextMap.ContextWithMetadata contextWithMetadata) {
        CommonContext context = contextWithMetadata.getContext();
        ExecutableAgentsHelper.ExecutorQuery executorQuery = this.createExecutorQuery(contextWithMetadata);
        Collection<BuildAgent> executableAgents = this.executableAgentsHelper.getExecutableAgents(executorQuery);
        if (executableAgents.isEmpty()) {
            log.debug((Object)("No agent found capable of building " + context.getDisplayName() + '.'));
        } else if (log.isTraceEnabled()) {
            for (BuildAgent executableAgent : executableAgents) {
                log.trace((Object)String.format("Found agent %d:%s for build %s", executableAgent.getId(), executableAgent.getName(), context.getDisplayName()));
            }
        }
        this.updateCurrentlyBuilding(context, executableAgents, this.getExecutableImages(contextWithMetadata));
        return executableAgents;
    }

    @Nullable
    public RequirementSet getRequirementSet(CommonContext context) {
        BuildContext buildContext = (BuildContext)Narrow.downTo((Object)context, BuildContext.class);
        if (buildContext != null) {
            PlanKey planKey = buildContext.getPlanResultKey().getPlanKey();
            ImmutableBuildable build = (ImmutableBuildable)this.cachedPlanManager.getPlanByKey(planKey, ImmutableBuildable.class);
            if (build == null) {
                log.info((Object)("Plan with key [" + planKey + "] was not found during executor calculation."));
                return null;
            }
            return build.getEffectiveRequirementSet();
        }
        DeploymentContext deploymentContext = (DeploymentContext)Narrow.to((Object)context, DeploymentContext.class);
        if (deploymentContext == null) {
            log.error((Object)("Context of type " + context.getClass() + " is unknown."));
            return null;
        }
        long environmentId = deploymentContext.getEnvironmentId();
        RequirementSet requirements = this.environmentService.getEnvironmentRequirementSet(environmentId);
        if (requirements == null) {
            log.info((Object)("Environment with id " + environmentId + " was not found during executor calculation."));
            return null;
        }
        return requirements;
    }

    public boolean canExecute(@NotNull BuildAgent agent, @NotNull CommonContextMap.ContextWithMetadata contextWithMetadata) {
        CommonContext context = contextWithMetadata.getContext();
        return this.executableAgentsHelper.canExecute(agent, context, (ImmutableRequirementSet)contextWithMetadata.getRequirements());
    }

    public Collection<ElasticImageConfiguration> getExecutableImages(CommonContextMap.ContextWithMetadata contextWithMetadata) {
        ExecutableAgentsHelper.ExecutorQuery executorQuery = this.createExecutorQuery(contextWithMetadata);
        return this.executableAgentsHelper.getExecutableImages(executorQuery);
    }

    private void updateCurrentlyBuilding(CommonContext context, Collection<BuildAgent> executableAgents, Collection<ElasticImageConfiguration> executableImages) {
        BuildContext buildContext = (BuildContext)Narrow.downTo((Object)context, BuildContext.class);
        if (buildContext == null) {
            return;
        }
        if (log.isTraceEnabled()) {
            for (ElasticImageConfiguration executableImage : executableImages) {
                log.trace((Object)String.format("Found elastic image configurations %s for build %s", executableImage.getAmiId(), context.getDisplayName()));
            }
        }
        this.buildExecutionManager.setCurrentlyBuilding(buildContext, executableAgents, executableImages);
    }

    private ExecutableAgentsHelper.ExecutorQuery createExecutorQuery(CommonContextMap.ContextWithMetadata contextWithMetaData) {
        CommonContext context = contextWithMetaData.getContext();
        return ExecutableAgentsHelper.ExecutorQuery.newQuery(contextWithMetaData.getRequirements(), AgentAssignmentServiceHelper.asExecutable((CommonContext)context)).withContext(context);
    }
}

