/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.queue;

import com.atlassian.bamboo.event.AllAgentsUpdatedEvent;
import com.atlassian.bamboo.plugin.descriptor.BuildAgentRequirementFilterDescriptor;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginModuleDisabledEvent;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;

public class PluginInstalledListener {
    private static final Logger log = Logger.getLogger(PluginInstalledListener.class);
    private final EventPublisher eventPublisher;
    private final PluginEventManager pluginEventManager;

    public PluginInstalledListener(EventPublisher eventPublisher, PluginEventManager pluginEventManager) {
        this.eventPublisher = eventPublisher;
        this.pluginEventManager = pluginEventManager;
    }

    @PluginEventListener
    public void onEnableEvent(PluginModuleEnabledEvent event) {
        if (event.getModule() instanceof BuildAgentRequirementFilterDescriptor) {
            log.debug((Object)"Installing BuildAgentRequirementFilter module, recheck queue");
            this.eventPublisher.publish((Object)new AllAgentsUpdatedEvent(this));
        }
    }

    @PluginEventListener
    public void onDisableEvent(PluginModuleDisabledEvent event) {
        if (event.getModule() instanceof BuildAgentRequirementFilterDescriptor) {
            log.debug((Object)"Uninstalling BuildAgentRequirementFilter module, recheck queue");
            this.eventPublisher.publish((Object)new AllAgentsUpdatedEvent(this));
        }
    }

    @PostConstruct
    public void attachListener() {
        this.pluginEventManager.register((Object)this);
    }
}

