/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.queue;

import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.v2.build.queue.BuildQueueManager;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public class QueueManagerView<S extends CommonContext, V> {
    private final BuildQueueManager buildQueueManager;
    private final Function<BuildQueueManager.QueueItemView<S>, BuildQueueManager.QueueItemView<V>> viewMapper;
    private final Class<S> contextClass;

    public static <V> QueueManagerView<BuildContext, V> newBuildView(BuildQueueManager buildQueueManager, Function<BuildQueueManager.QueueItemView<BuildContext>, BuildQueueManager.QueueItemView<V>> viewMapper) {
        return new QueueManagerView<BuildContext, V>(buildQueueManager, viewMapper, BuildContext.class);
    }

    public static <V> QueueManagerView<CommonContext, V> newView(BuildQueueManager buildQueueManager, Function<BuildQueueManager.QueueItemView<CommonContext>, BuildQueueManager.QueueItemView<V>> context2QueueItem) {
        return new QueueManagerView<CommonContext, V>(buildQueueManager, context2QueueItem, CommonContext.class);
    }

    private QueueManagerView(BuildQueueManager buildQueueManager, Function<BuildQueueManager.QueueItemView<S>, BuildQueueManager.QueueItemView<V>> viewMappper, Class<S> contextClass) {
        this.buildQueueManager = buildQueueManager;
        this.viewMapper = viewMappper;
        this.contextClass = contextClass;
    }

    public Iterable<BuildQueueManager.QueueItemView<V>> getQueueView(Iterable<BuildQueueManager.QueueItemView<V>> previouslyQueuedExecutables) {
        Iterable currentlyQueuedExecutables = this.buildQueueManager.getQueuedExecutables();
        ImmutableMap previousQueueIndexedByResultKey = Maps.uniqueIndex(previouslyQueuedExecutables, BuildQueueManager.QueueItemView::getQueuedResultKey);
        ArrayList<BuildQueueManager.QueueItemView<V>> currentQueue = new ArrayList<BuildQueueManager.QueueItemView<V>>();
        for (BuildQueueManager.QueuedResultKey currentQueuedExecutable : currentlyQueuedExecutables) {
            BuildQueueManager.QueueItemView cachedItem = (BuildQueueManager.QueueItemView)previousQueueIndexedByResultKey.get((Object)currentQueuedExecutable);
            if (cachedItem != null) {
                currentQueue.add(cachedItem);
                continue;
            }
            BuildQueueManager.QueueItemView fullQueueItem = this.buildQueueManager.peekContext(currentQueuedExecutable.getResultKey());
            if (!QueueManagerView.isViewOfClass((BuildQueueManager.QueueItemView<CommonContext>)fullQueueItem, this.contextClass)) continue;
            BuildQueueManager.QueueItemView buildQueueItem = (BuildQueueManager.QueueItemView)this.viewMapper.apply((Object)fullQueueItem);
            currentQueue.add(buildQueueItem);
        }
        return currentQueue;
    }

    private static <S> boolean isViewOfClass(@Nullable BuildQueueManager.QueueItemView<CommonContext> fullQueueItem, Class<S> clazz) {
        if (fullQueueItem == null) {
            return false;
        }
        CommonContext view = (CommonContext)fullQueueItem.getView();
        return clazz.isInstance(view);
    }
}

