/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.queue.order;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.v2.build.queue.BuildQueueManager;
import com.atlassian.bamboo.v2.build.queue.ExecutableOrderProvider;
import com.atlassian.bamboo.v2.build.queue.QueueManagerUtils;
import com.atlassian.bamboo.v2.build.queue.QueueOfExecutables;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FifoExecutableOrderProvider
implements ExecutableOrderProvider {
    private static final Logger log = Logger.getLogger(FifoExecutableOrderProvider.class);
    private final List<BuildQueueManager.QueuedResultKey> buildQueue = new CopyOnWriteArrayList<BuildQueueManager.QueuedResultKey>();

    public void onEnqueue(@NotNull Iterable<CommonContext> contexts) {
        for (CommonContext context : contexts) {
            this.buildQueue.add(QueueManagerUtils.asQueued((ResultKey)context.getResultKey()));
        }
    }

    public void onDequeue(@NotNull CommonContext context) {
        this.removeFromBuildQueue(context.getResultKey());
    }

    @Nullable
    public ResultKey findExecutableForAgent(long agentId, @NotNull Collection<QueueOfExecutables.ExecutableData> executableData) {
        HashSet<ResultKey> possibleResultKeys = new HashSet<ResultKey>();
        for (QueueOfExecutables.ExecutableData possibleResultKey : executableData) {
            possibleResultKeys.add(possibleResultKey.getResultKey());
        }
        Predicate isOneOfPossibleResultKeys = queuedResultKey -> possibleResultKeys.contains(queuedResultKey.getResultKey());
        BuildQueueManager.QueuedResultKey queuedResultKey2 = (BuildQueueManager.QueuedResultKey)Iterables.find(this.buildQueue, (Predicate)isOneOfPossibleResultKeys, null);
        if (queuedResultKey2 == null) {
            return null;
        }
        return queuedResultKey2.getResultKey();
    }

    @NotNull
    public Collection<BuildQueueManager.QueuedResultKey> getOrderedExecutables() {
        return this.buildQueue;
    }

    public boolean reorder(ResultKey resultKey, int index) {
        BuildQueueManager.QueuedResultKey queuedResultKey = this.removeFromBuildQueue(resultKey);
        if (queuedResultKey == null) {
            return false;
        }
        try {
            this.buildQueue.add(index, queuedResultKey);
        }
        catch (IndexOutOfBoundsException e) {
            this.buildQueue.add(queuedResultKey);
        }
        return true;
    }

    @Nullable
    private BuildQueueManager.QueuedResultKey removeFromBuildQueue(ResultKey resultKey) {
        BuildQueueManager.QueuedResultKey queuedResultKey = this.buildQueue.stream().filter(QueueManagerUtils.hasResultKeyEqualTo((ResultKey)resultKey)).findFirst().orElse(null);
        if (queuedResultKey == null) {
            return null;
        }
        if (!this.buildQueue.remove(queuedResultKey)) {
            return null;
        }
        return queuedResultKey;
    }
}

