/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.queue.queues;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.utils.BambooLogUtils;
import com.atlassian.bamboo.utils.scopedcaches.ThreadScopedCaches;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.v2.build.agent.capability.MinimalRequirementSet;
import com.atlassian.bamboo.v2.build.queue.ExecutorCalculator;
import com.atlassian.bamboo.v2.build.queue.QueueOfExecutables;
import com.atlassian.bamboo.v2.build.queue.queues.CommonContextMap;
import com.atlassian.bamboo.v2.build.queue.queues.InternalHashMultimap;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractQueueOfExecutables
implements QueueOfExecutables {
    private static final Logger log = Logger.getLogger(AbstractQueueOfExecutables.class);
    private final Object contextsAndExecutorsSyncLock = new Object();
    private final Object executorsReindexLock = new Object();
    private final CommonContextMap contextsByResultKey;
    private final ExecutorCalculator executorCalculator;
    private final ExecutorsAndExecutables executorsAndExecutables = new ExecutorsAndExecutables();

    protected AbstractQueueOfExecutables(ExecutorCalculator executorCalculator, CommonContextMap map) {
        this.executorCalculator = executorCalculator;
        this.contextsByResultKey = map;
    }

    @Nullable
    public CommonContext inflight(@NotNull ResultKey resultKey) {
        return this.remove(resultKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CommonContext remove(@NotNull ResultKey resultKey) {
        Object object = this.contextsAndExecutorsSyncLock;
        synchronized (object) {
            CommonContextMap.ContextWithMetadata context = this.contextsByResultKey.get(resultKey);
            this.contextsByResultKey.remove(resultKey);
            if (context == null) {
                return null;
            }
            this.deindexExecutorsFor(resultKey);
            return context.getContext();
        }
    }

    public boolean enqueue(@NotNull CommonContext context, @Nullable MinimalRequirementSet requirements) {
        if (requirements == null && (requirements = this.executorCalculator.getRequirementSet(context)) == null) {
            return false;
        }
        CommonContextMap.ContextWithMetadata contextWithMetadata = new CommonContextMap.ContextWithMetadata(context, requirements);
        ThreadScopedCaches.inCachingScope(() -> {
            Object object = this.contextsAndExecutorsSyncLock;
            synchronized (object) {
                this.contextsByResultKey.put(context.getResultKey(), contextWithMetadata);
                this.indexExecutorsFor(contextWithMetadata);
            }
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ImmutableList<QueueOfExecutables.ExecutableData> executablesForAgent(long agentId) {
        Collection<ResultKey> executablesForThisAgent;
        ImmutableList.Builder builder = ImmutableList.builder();
        Iterator<ResultKey> iterator = this.executorsReindexLock;
        synchronized (iterator) {
            executablesForThisAgent = this.executorsAndExecutables.get(agentId);
        }
        for (ResultKey resultKey : executablesForThisAgent) {
            builder.add((Object)new QueueOfExecutables.ExecutableData(resultKey));
        }
        return builder.build();
    }

    public void recalculateExecutables(BuildAgent agent) {
        ThreadScopedCaches.inCachingScope(() -> {
            Object object = this.contextsAndExecutorsSyncLock;
            synchronized (object) {
                log.trace((Object)("recalculate executables for " + agent));
                this.executorsAndExecutables.removeAgent(agent);
                Set<ResultKey> results = this.contextsByResultKey.keySet();
                for (ResultKey result : results) {
                    CommonContextMap.ContextWithMetadata contextWithMetadata = this.contextsByResultKey.get(result);
                    if (contextWithMetadata == null || !this.executorCalculator.canExecute(agent, contextWithMetadata)) continue;
                    this.updateAgentData(contextWithMetadata.getContext(), Collections.singleton(agent));
                }
            }
        });
    }

    public void recalculateExecutors() {
        ThreadScopedCaches.inCachingScope(() -> {
            for (ResultKey resultKey : this.contextsByResultKey.keySet()) {
                this.recalculateExecutors(resultKey);
            }
        });
    }

    public int size() {
        return this.contextsByResultKey.size();
    }

    @Nullable
    public Collection<ElasticImageConfiguration> getImagesForExecutable(@NotNull ResultKey resultKey) {
        return this.executorsAndExecutables.getImagesForExecutable(resultKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Set<Long> getExecutorsForExecutable(@NotNull ResultKey resultKey) {
        Set<Long> executorsForExecutable = this.executorsAndExecutables.getExecutorsForExecutable(resultKey);
        if (executorsForExecutable != null) {
            return executorsForExecutable;
        }
        Object object = this.contextsAndExecutorsSyncLock;
        synchronized (object) {
            return this.contextsByResultKey.keySet().contains(resultKey) ? Collections.emptySet() : null;
        }
    }

    public void recalculateExecutors(@NotNull Set<Key> keys) {
        ThreadScopedCaches.inCachingScope(() -> {
            for (ResultKey resultKey : this.contextsByResultKey.keySet()) {
                if (!keys.contains(resultKey.getEntityKey())) continue;
                this.recalculateExecutors(resultKey);
            }
        });
    }

    @Nullable
    public CommonContext get(@NotNull ResultKey resultKey) {
        CommonContextMap.ContextWithMetadata contextAndRequirements = this.contextsByResultKey.get(resultKey);
        if (contextAndRequirements == null) {
            return null;
        }
        return contextAndRequirements.getContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recalculateExecutors(ResultKey resultKey) {
        Object object = this.contextsAndExecutorsSyncLock;
        synchronized (object) {
            CommonContextMap.ContextWithMetadata context = this.contextsByResultKey.get(resultKey);
            Object object2 = this.executorsReindexLock;
            synchronized (object2) {
                this.deindexExecutorsFor(resultKey);
                if (context == null) {
                    return;
                }
                this.indexExecutorsFor(context);
            }
        }
    }

    private void deindexExecutorsFor(@NotNull ResultKey resultKey) {
        this.executorsAndExecutables.removeAll(resultKey);
    }

    private void indexExecutorsFor(@NotNull CommonContextMap.ContextWithMetadata contextWithMetadata) {
        CommonContext context = contextWithMetadata.getContext();
        this.updateAgentData(context, this.calculateAgents(contextWithMetadata));
        this.executorsAndExecutables.put(context.getResultKey(), this.executorCalculator.getExecutableImages(contextWithMetadata));
    }

    private void updateAgentData(@NotNull CommonContext context, @NotNull Iterable<BuildAgent> agents) {
        for (BuildAgent agent : agents) {
            this.executorsAndExecutables.put(agent.getId(), context.getResultKey());
        }
    }

    @NotNull
    private Collection<BuildAgent> calculateAgents(@NotNull CommonContextMap.ContextWithMetadata contextWithMetadata) {
        return this.executorCalculator.calculateExecutors(contextWithMetadata);
    }

    private static class ExecutorsAndExecutables {
        private final InternalHashMultimap<Long, ResultKey> executablesForExecutor = InternalHashMultimap.create();
        private final InternalHashMultimap<ResultKey, Long> executorsForExecutable = InternalHashMultimap.create();
        private final Map<ResultKey, Collection<ElasticImageConfiguration>> imagesForExecutable = new HashMap<ResultKey, Collection<ElasticImageConfiguration>>();

        private ExecutorsAndExecutables() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<ResultKey> get(long agentId) {
            InternalHashMultimap<Long, ResultKey> internalHashMultimap = this.executablesForExecutor;
            synchronized (internalHashMultimap) {
                Set<ResultKey> elements = this.executablesForExecutor.get(agentId);
                return elements != null ? new ArrayList<ResultKey>(elements) : Collections.emptyList();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(long executorId, ResultKey resultKey) {
            InternalHashMultimap<Long, ResultKey> internalHashMultimap = this.executablesForExecutor;
            synchronized (internalHashMultimap) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)(executorId + " is available for " + resultKey));
                }
                this.executablesForExecutor.put(executorId, resultKey);
                this.executorsForExecutable.put(resultKey, executorId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeAgent(BuildAgent buildAgent) {
            InternalHashMultimap<Long, ResultKey> internalHashMultimap = this.executablesForExecutor;
            synchronized (internalHashMultimap) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("agent '" + buildAgent + "' is removed for all"));
                }
                this.executablesForExecutor.remove(buildAgent.getId());
                this.executorsForExecutable.removeAllValues(buildAgent.getId());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeAll(ResultKey resultKey) {
            InternalHashMultimap<Long, ResultKey> internalHashMultimap = this.executablesForExecutor;
            synchronized (internalHashMultimap) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("result '" + resultKey + "' is removed for all"));
                }
                Stopwatch stopwatch = Stopwatch.createStarted();
                this.executablesForExecutor.removeAllValues(resultKey);
                this.executorsForExecutable.remove(resultKey);
                this.imagesForExecutable.remove(resultKey);
                BambooLogUtils.logOperationTime((Logger)log, (Stopwatch)stopwatch, (int)1, (int)2, (int)3, (String)"removeall");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(ResultKey resultKey, Collection<ElasticImageConfiguration> executableImages) {
            InternalHashMultimap<Long, ResultKey> internalHashMultimap = this.executablesForExecutor;
            synchronized (internalHashMultimap) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)(resultKey + " is available for images " + executableImages));
                }
                this.imagesForExecutable.put(resultKey, executableImages);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public Collection<ElasticImageConfiguration> getImagesForExecutable(@NotNull ResultKey resultKey) {
            InternalHashMultimap<Long, ResultKey> internalHashMultimap = this.executablesForExecutor;
            synchronized (internalHashMultimap) {
                Collection<ElasticImageConfiguration> elasticImageConfigurations = this.imagesForExecutable.get(resultKey);
                if (elasticImageConfigurations == null) {
                    return null;
                }
                return new ArrayList<ElasticImageConfiguration>(elasticImageConfigurations);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public Set<Long> getExecutorsForExecutable(@NotNull ResultKey resultKey) {
            InternalHashMultimap<Long, ResultKey> internalHashMultimap = this.executablesForExecutor;
            synchronized (internalHashMultimap) {
                Set<Long> executors = this.executorsForExecutable.get(resultKey);
                if (executors == null) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("no executors found for " + resultKey));
                    }
                    return null;
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)("executors found for " + resultKey + " agents: " + executors));
                }
                return new HashSet<Long>(executors);
            }
        }
    }
}

