/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.queue.queues;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.utils.concurrent.BambooLocks;
import com.atlassian.bamboo.v2.build.queue.queues.CommonContextMap;
import com.atlassian.bamboo.v2.build.queue.queues.CommonContextPersister;
import com.google.common.cache.LoadingCache;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonContextMaps {
    private static final Logger log = Logger.getLogger(CommonContextMaps.class);
    private static final LoadingCache<Object, ReentrantLock> locks = BambooLocks.weakReentrantLockFactory();

    private CommonContextMaps() {
    }

    public static CommonContextMap wrap(Map<ResultKey, CommonContextMap.ContextWithMetadata> delegate) {
        return new ForwardingCommonContextMap(delegate);
    }

    public static CommonContextMap offloadingMap(CommonContextPersister commonContextPersister, Map<ResultKey, SoftReference<CommonContextMap.ContextWithMetadata>> delegate) {
        return new ForwardingOffloadingCommonContextMap(commonContextPersister, delegate);
    }

    private static class ForwardingOffloadingCommonContextMap
    extends AbstractForwardingCommonContextMap {
        private final CommonContextPersister commonContextPersister;
        private final Map<ResultKey, SoftReference<CommonContextMap.ContextWithMetadata>> delegate;

        public ForwardingOffloadingCommonContextMap(CommonContextPersister commonContextPersister, Map<ResultKey, SoftReference<CommonContextMap.ContextWithMetadata>> delegate) {
            super(delegate);
            this.commonContextPersister = commonContextPersister;
            this.delegate = delegate;
        }

        @Override
        @Nullable
        public CommonContextMap.ContextWithMetadata get(ResultKey resultKey) {
            SoftReference<CommonContextMap.ContextWithMetadata> contextSoftReference = this.delegate.get(resultKey);
            if (contextSoftReference == null) {
                return null;
            }
            CommonContextMap.ContextWithMetadata commonContext = contextSoftReference.get();
            if (commonContext != null) {
                return commonContext;
            }
            return this.load(resultKey);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private CommonContextMap.ContextWithMetadata load(ResultKey resultKey) {
            ReentrantLock lock = (ReentrantLock)locks.getUnchecked((Object)resultKey);
            lock.lock();
            try {
                SoftReference<CommonContextMap.ContextWithMetadata> commonContextSoftReference = this.delegate.get(resultKey);
                if (commonContextSoftReference == null) {
                    CommonContextMap.ContextWithMetadata contextWithMetadata = null;
                    return contextWithMetadata;
                }
                CommonContextMap.ContextWithMetadata commonContext = commonContextSoftReference.get();
                if (commonContext != null) {
                    CommonContextMap.ContextWithMetadata contextWithMetadata = commonContext;
                    return contextWithMetadata;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Loading common context for " + resultKey), new Throwable());
                } else {
                    log.info((Object)("Loading common context for " + resultKey));
                }
                CommonContextMap.ContextWithMetadata loaded = this.commonContextPersister.load(resultKey);
                this.delegate.put(resultKey, new SoftReference<CommonContextMap.ContextWithMetadata>(loaded));
                CommonContextMap.ContextWithMetadata contextWithMetadata = loaded;
                return contextWithMetadata;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public void put(ResultKey resultKey, CommonContextMap.ContextWithMetadata context) {
            boolean wasAdded;
            this.commonContextPersister.save(context);
            boolean bl = wasAdded = this.delegate.putIfAbsent(resultKey, new SoftReference<CommonContextMap.ContextWithMetadata>(context)) == null;
            if (!wasAdded) {
                throw new IllegalStateException("Attempt to double-queue " + context.getContext().getDisplayName());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(ResultKey resultKey) {
            ReentrantLock lock = (ReentrantLock)locks.getUnchecked((Object)resultKey);
            lock.lock();
            try {
                this.commonContextPersister.remove(resultKey);
                boolean bl = super.remove(resultKey);
                return bl;
            }
            finally {
                lock.unlock();
            }
        }
    }

    private static class ForwardingCommonContextMap
    extends AbstractForwardingCommonContextMap {
        private final Map<ResultKey, CommonContextMap.ContextWithMetadata> delegate;

        public ForwardingCommonContextMap(Map<ResultKey, CommonContextMap.ContextWithMetadata> delegate) {
            super(delegate);
            this.delegate = delegate;
        }

        @Override
        public CommonContextMap.ContextWithMetadata get(ResultKey resultKey) {
            return this.delegate.get(resultKey);
        }

        @Override
        public void put(ResultKey resultKey, CommonContextMap.ContextWithMetadata contextWithMetadata) {
            boolean wasAdded;
            boolean bl = wasAdded = this.delegate.put(resultKey, contextWithMetadata) == null;
            if (!wasAdded) {
                throw new IllegalStateException("Attempt to double-queue " + contextWithMetadata.getContext().getDisplayName());
            }
        }
    }

    private static abstract class AbstractForwardingCommonContextMap
    implements CommonContextMap {
        private final Map<ResultKey, ? extends Object> delegate;

        public AbstractForwardingCommonContextMap(Map<ResultKey, ? extends Object> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean remove(ResultKey resultKey) {
            return this.delegate.remove(resultKey) != null;
        }

        @Override
        @NotNull
        public Set<ResultKey> keySet() {
            return this.delegate.keySet();
        }

        @Override
        public int size() {
            return this.delegate.size();
        }
    }
}

