/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.queue.queues;

import com.atlassian.bamboo.util.BambooMaps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

class InternalHashMultimap<K, V> {
    private final Map<K, Set<V>> map = new HashMap<K, Set<V>>();
    private int removeAllValuesCallCounter = 0;

    InternalHashMultimap() {
    }

    @Nullable
    public Set<V> get(K key) {
        return this.map.get(key);
    }

    public void put(K key, V value) {
        this.map.computeIfAbsent(key, k -> new HashSet()).add(value);
    }

    public void removeAllValues(V value) {
        for (Set<V> vs : this.map.values()) {
            vs.remove(value);
        }
        if (++this.removeAllValuesCallCounter % 1000 == 0) {
            BambooMaps.prune(this.map, entry -> ((Set)entry.getValue()).isEmpty());
        }
    }

    public void remove(K key) {
        this.map.remove(key);
    }

    public static <K, V> InternalHashMultimap<K, V> create() {
        return new InternalHashMultimap<K, V>();
    }
}

