/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.queue.queues;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.util.BambooFileUtils;
import com.atlassian.bamboo.util.BambooObjectUtils;
import com.atlassian.bamboo.v2.build.queue.queues.CommonContextMap;
import com.atlassian.bamboo.v2.build.queue.queues.CommonContextPersister;
import com.google.common.io.Closeables;
import com.thoughtworks.xstream.XStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@NotThreadSafe
public class XStreamQueuePersisterImpl
implements CommonContextPersister {
    private static final Logger log = Logger.getLogger(XStreamQueuePersisterImpl.class);
    private static final Charset COMMON_CONTEXT_CHARSET = StandardCharsets.UTF_8;
    private final XStream xStream;
    private final File serverStateDirectory;

    public XStreamQueuePersisterImpl(XStream xStream, File serverStateDirectory) {
        this.xStream = xStream;
        this.serverStateDirectory = serverStateDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(@NotNull CommonContextMap.ContextWithMetadata context) {
        File file = this.newCommonContextFile(context.getContext().getResultKey());
        try {
            BufferedWriter out = new BufferedWriter((Writer)new FileWriterWithEncoding(file, COMMON_CONTEXT_CHARSET));
            try {
                this.xStream.toXML((Object)context, (Writer)out);
            }
            finally {
                Closeables.close((Closeable)out, (boolean)true);
            }
        }
        catch (FileNotFoundException e) {
            throw BambooObjectUtils.asRuntimeException((Throwable)e);
        }
        catch (IOException e) {
            throw BambooObjectUtils.asRuntimeException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CommonContextMap.ContextWithMetadata load(@NotNull ResultKey resultKey) {
        CommonContextMap.ContextWithMetadata contextWithMetadata;
        log.info((Object)("Loading offloaded context for: " + resultKey));
        File file = this.newCommonContextFile(resultKey);
        InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(file), COMMON_CONTEXT_CHARSET);
        try {
            contextWithMetadata = (CommonContextMap.ContextWithMetadata)this.xStream.fromXML((Reader)in);
        }
        catch (Throwable throwable) {
            try {
                Closeables.closeQuietly((Reader)in);
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw BambooObjectUtils.asRuntimeException((Throwable)e);
            }
        }
        Closeables.closeQuietly((Reader)in);
        return contextWithMetadata;
    }

    @Override
    @NotNull
    public Stream<CommonContextMap.ContextWithMetadata> loadAndRemoveAll() {
        if (!this.serverStateDirectory.isDirectory()) {
            return Stream.empty();
        }
        return Arrays.stream(this.serverStateDirectory.listFiles()).map(file -> {
            try {
                InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream((File)file), COMMON_CONTEXT_CHARSET);
                try {
                    CommonContextMap.ContextWithMetadata contextWithMetadata = (CommonContextMap.ContextWithMetadata)this.xStream.fromXML((Reader)in);
                    return contextWithMetadata;
                }
                catch (Exception e) {
                    log.warn((Object)("Exception while restoring server state from " + file.getName()), (Throwable)e);
                    return null;
                }
                finally {
                    Closeables.closeQuietly((Reader)in);
                    BambooFileUtils.deleteQuietly(file);
                }
            }
            catch (FileNotFoundException e2) {
                log.warn((Object)"Exception while restoring server state", (Throwable)e2);
            }
            return null;
        }).filter(Objects::nonNull);
    }

    @Override
    public void remove(ResultKey resultKey) {
        File contextFile = this.newCommonContextFile(resultKey);
        boolean deleted = contextFile.delete();
        if (!deleted && contextFile.exists()) {
            log.info((Object)("Can't remove context file: " + contextFile.getAbsolutePath()));
        }
    }

    private File newCommonContextFile(ResultKey resultKey) {
        BambooFileUtils.createDirectoryIfNotExists(this.serverStateDirectory);
        return new File(this.serverStateDirectory, resultKey.toString());
    }
}

