/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.requirement;

import com.atlassian.bamboo.v2.build.agent.capability.CapabilityType;
import com.atlassian.bamboo.v2.build.requirement.ImmutableRequirement;
import com.atlassian.bamboo.v2.build.requirement.RequirementDetails;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RequirementDetailsImpl
implements RequirementDetails {
    private static final Logger log = Logger.getLogger(RequirementDetailsImpl.class);
    private final ImmutableRequirement immutableRequirement;
    private final String requirementLabel;
    private final String ownerName;
    private final Integer matchingAgents;
    private final Integer matchingImages;

    public RequirementDetailsImpl(@NotNull ImmutableRequirement immutableRequirement, @NotNull CapabilityType capabilityType, @Nullable String ownerName, Integer matchingAgents, Integer matchingImages) {
        this.immutableRequirement = immutableRequirement;
        this.requirementLabel = capabilityType.getLabel(immutableRequirement.getKey());
        this.ownerName = ownerName;
        this.matchingAgents = matchingAgents;
        this.matchingImages = matchingImages;
    }

    public long getId() {
        return this.immutableRequirement.getId();
    }

    @NotNull
    public String getKey() {
        return this.immutableRequirement.getKey();
    }

    @NotNull
    public String getRequirementLabel() {
        return this.requirementLabel;
    }

    @Nullable
    public String getMatchValue() {
        return this.immutableRequirement.getMatchValue();
    }

    @NotNull
    public ImmutableRequirement.MatchType getTypeOfMatch() {
        return this.immutableRequirement.getTypeOfMatch();
    }

    public Boolean isReadonly() {
        return this.immutableRequirement.isReadonly();
    }

    public long getOwnerId() {
        return this.immutableRequirement.getOwnerId();
    }

    @Nullable
    public String getPluginModuleKey() {
        return this.immutableRequirement.getPluginModuleKey();
    }

    @Nullable
    public String getOwnerName() {
        return this.ownerName;
    }

    public Integer getMatchingAgents() {
        return this.matchingAgents;
    }

    public Integer getMatchingImages() {
        return this.matchingImages;
    }

    public boolean isRegexMatch() {
        return this.immutableRequirement.isRegexMatch();
    }
}

