/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.requirement;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.agent.elastic.server.ElasticFunctionalityFacade;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.buildqueue.manager.AgentAssignmentServiceHelper;
import com.atlassian.bamboo.buildqueue.manager.ExecutableAgentsMatrix;
import com.atlassian.bamboo.event.BuildRequirementUpdatedEvent;
import com.atlassian.bamboo.exception.NotFoundException;
import com.atlassian.bamboo.exception.WebValidationException;
import com.atlassian.bamboo.persister.AuditLogEntityType;
import com.atlassian.bamboo.persister.AuditLogService;
import com.atlassian.bamboo.plan.ExecutableAgentsHelper;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableBuildable;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskManager;
import com.atlassian.bamboo.task.TaskModuleDescriptor;
import com.atlassian.bamboo.utils.BambooFieldValidate;
import com.atlassian.bamboo.utils.BambooValidationUtils;
import com.atlassian.bamboo.utils.RequirementUtils;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityHelper;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityType;
import com.atlassian.bamboo.v2.build.agent.capability.MinimalRequirementSet;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementImpl;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementSet;
import com.atlassian.bamboo.v2.build.requirement.ImmutableRequirement;
import com.atlassian.bamboo.v2.build.requirement.RequirementDetails;
import com.atlassian.bamboo.v2.build.requirement.RequirementDetailsImpl;
import com.atlassian.bamboo.v2.build.requirement.RequirementService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.struts.TextProvider;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.acls.Permission;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RequirementServiceImpl
implements RequirementService {
    private static final Logger log = Logger.getLogger(RequirementServiceImpl.class);
    private final CachedPlanManager cachedPlanManager;
    private final TextProvider textProvider;
    private final PlanManager planManager;
    private final AuditLogService auditLogService;
    private final EventPublisher eventPublisher;
    private final BambooPermissionManager bambooPermissionManager;
    private final CapabilityHelper capabilityHelper;
    private final TaskManager taskManager;
    private final ElasticFunctionalityFacade elasticFunctionalityFacade;
    private final ExecutableAgentsHelper executableAgentsHelper;
    private static final Comparator<RequirementDetails> REQUIREMENT_DETAILS_COMPARATOR = (req1, req2) -> new CompareToBuilder().append((Object)req1.isReadonly(), (Object)req2.isReadonly()).append((Object)req1.getRequirementLabel(), (Object)req2.getRequirementLabel(), String.CASE_INSENSITIVE_ORDER).append((Object)req1.getMatchValue(), (Object)req2.getMatchValue(), String.CASE_INSENSITIVE_ORDER).append((Object)req1.getOwnerName(), (Object)req2.getOwnerName(), String.CASE_INSENSITIVE_ORDER).toComparison();

    public RequirementServiceImpl(CachedPlanManager cachedPlanManager, TextProvider textProvider, PlanManager planManager, AuditLogService auditLogService, EventPublisher eventPublisher, BambooPermissionManager bambooPermissionManager, CapabilityHelper capabilityHelper, TaskManager taskManager, ElasticFunctionalityFacade elasticFunctionalityFacade, ExecutableAgentsHelper executableAgentsHelper) {
        this.cachedPlanManager = cachedPlanManager;
        this.textProvider = textProvider;
        this.planManager = planManager;
        this.auditLogService = auditLogService;
        this.eventPublisher = eventPublisher;
        this.bambooPermissionManager = bambooPermissionManager;
        this.capabilityHelper = capabilityHelper;
        this.taskManager = taskManager;
        this.elasticFunctionalityFacade = elasticFunctionalityFacade;
        this.executableAgentsHelper = executableAgentsHelper;
    }

    @NotNull
    public List<? extends ImmutableRequirement> getRequirementsForJob(@NotNull PlanKey jobKey) throws WebValidationException {
        ImmutableJob job = this.getAndValidateJob(jobKey);
        RequirementSet requirementSet = job.getEffectiveRequirementSet();
        Map<Long, String> taskDescriptions = this.getTaskNames(job);
        ExecutableAgentsMatrix agentsMatrix = this.getExecutableAgentsMatrix((MinimalRequirementSet)requirementSet, job);
        List requirementDetailsList = requirementSet.getRequirements().stream().map(requirement -> this.getRequirementDetails((ImmutableRequirement)requirement, agentsMatrix, taskDescriptions)).collect(Collectors.toList());
        return Ordering.from(REQUIREMENT_DETAILS_COMPARATOR).sortedCopy(requirementDetailsList);
    }

    @NotNull
    public ExecutableAgentsMatrix getExecutableAgentMatrixForJob(@NotNull PlanKey jobKey) throws WebValidationException {
        ImmutableJob job = this.getAndValidateJob(jobKey);
        RequirementSet requirementSet = job.getEffectiveRequirementSet();
        return this.getExecutableAgentsMatrix((MinimalRequirementSet)requirementSet, job);
    }

    @NotNull
    public ImmutableRequirement getRequirementForJob(@NotNull PlanKey jobKey, long requirementId) {
        RequirementSet set;
        ImmutableJob job = this.getAndValidateJob(jobKey);
        RequirementDetails requirement = this.getRequirementDetails(job, (set = job.getEffectiveRequirementSet()).getRequirement(requirementId));
        if (requirement == null) {
            throw new NotFoundException(this.textProvider.getText("requirement.error.requirementnotfound"));
        }
        return requirement;
    }

    @NotNull
    public ErrorCollection validateRequirementForAdd(@NotNull PlanKey jobKey, @Nullable String key, @Nullable ImmutableRequirement.MatchType matchType, @Nullable String matchValue) {
        ImmutableJob job = this.getAndValidateJob(jobKey);
        if (job.hasMaster()) {
            return new SimpleErrorCollection(this.textProvider.getText("requirement.add.error.branch"));
        }
        ErrorCollection errorCollection = this.validateFields(key, matchType, matchValue);
        RequirementSet requirementSet = job.getRequirementSet();
        String trimmedKey = StringUtils.trim((String)key);
        if (requirementSet.getRequirements().stream().anyMatch(item -> item.getKey().equals(trimmedKey))) {
            errorCollection.addError("key", this.textProvider.getText("requirement.error.existingKey"));
        }
        return errorCollection;
    }

    @NotNull
    public ImmutableRequirement addRequirement(@NotNull PlanKey jobKey, @NotNull String key, @NotNull ImmutableRequirement.MatchType matchType, @Nullable String matchValue) throws WebValidationException {
        BambooValidationUtils.checkErrors(this.validateRequirementForAdd(jobKey, key, matchType, matchValue));
        Job job = (Job)this.planManager.getPlanByKeyIfOfType(jobKey, Job.class);
        BambooValidationUtils.validate(job != null, () -> this.textProvider.getText("requirement.error.nojob", Collections.singletonList(jobKey)));
        RequirementSet requirementSet = job.getRequirementSet();
        RequirementImpl requirement = new RequirementImpl();
        this.setValues(requirement, key, matchType, matchValue);
        requirementSet.addRequirement((Requirement)requirement);
        this.planManager.savePlan((Plan)job);
        this.auditLogService.log(this.textProvider.getText("requirement.add.auditentry"), null, requirement.toString(), (Key)job.getPlanKey(), AuditLogEntityType.PLAN, null);
        this.eventPublisher.publish((Object)new BuildRequirementUpdatedEvent((Object)this, job.getPlanKey()));
        return this.getRequirementDetails((ImmutableJob)job, requirement);
    }

    @NotNull
    public ErrorCollection validateRequirementForUpdate(@NotNull PlanKey jobKey, long requirementId, @Nullable String key, @Nullable ImmutableRequirement.MatchType matchType, @Nullable String matchValue) {
        ImmutableJob job = this.getAndValidateJob(jobKey);
        if (job.hasMaster()) {
            return new SimpleErrorCollection(this.textProvider.getText("requirement.update.error.branch"));
        }
        ImmutableRequirement requirement = this.getRequirementForJob(jobKey, requirementId);
        if (requirement.isReadonly().booleanValue()) {
            return new SimpleErrorCollection(this.textProvider.getText("requirement.error.readonly"));
        }
        RequirementSet requirementSet = job.getRequirementSet();
        String trimmedKey = StringUtils.trim((String)key);
        if (requirementSet.getRequirements().stream().filter(item -> item.getKey().equals(trimmedKey)).filter(item -> item.getId() != requirementId).count() > 0L) {
            SimpleErrorCollection errorCollection = new SimpleErrorCollection();
            errorCollection.addError("key", this.textProvider.getText("requirement.error.existingKey"));
            return errorCollection;
        }
        return this.validateFields(key, matchType, matchValue);
    }

    @NotNull
    public ImmutableRequirement updateRequirement(@NotNull PlanKey jobKey, long requirementId, @NotNull String key, @NotNull ImmutableRequirement.MatchType matchType, @Nullable String matchValue) throws WebValidationException {
        BambooValidationUtils.checkErrors(this.validateRequirementForUpdate(jobKey, requirementId, key, matchType, matchValue));
        Job job = (Job)this.planManager.getPlanByKeyIfOfType(jobKey, Job.class);
        BambooValidationUtils.validate(job != null, () -> this.textProvider.getText("requirement.error.nojob", (List)Lists.newArrayList((Object[])new PlanKey[]{jobKey})));
        RequirementSet requirementSet = job.getRequirementSet();
        RequirementImpl requirement = (RequirementImpl)requirementSet.getRequirement(requirementId);
        BambooValidationUtils.validate(requirement != null, () -> this.textProvider.getText("requirement.update.error.requirementnotfound"));
        this.setValues(requirement, key, matchType, matchValue);
        this.planManager.savePlan((Plan)job);
        this.auditLogService.log(this.textProvider.getText("requirement.update.auditentry"), null, requirement.toString(), (Key)job.getPlanKey(), AuditLogEntityType.PLAN, null);
        this.eventPublisher.publish((Object)new BuildRequirementUpdatedEvent((Object)this, job.getPlanKey()));
        return this.getRequirementDetails((ImmutableJob)job, requirement);
    }

    public void removeRequirement(@NotNull PlanKey jobKey, long requirementId) throws WebValidationException {
        Job job = (Job)this.planManager.getPlanByKeyIfOfType(jobKey, Job.class);
        BambooValidationUtils.validate(job != null, () -> this.textProvider.getText("requirement.error.nojob", (List)Lists.newArrayList((Object[])new PlanKey[]{jobKey})));
        BambooValidationUtils.validate(this.bambooPermissionManager.hasPermission((Permission)BambooPermission.WRITE, (Object)job.getParent(), null), () -> this.textProvider.getText("requirement.remove.error.permission"));
        BambooValidationUtils.validate(!job.hasMaster(), () -> this.textProvider.getText("requirement.remove.error.branch"));
        RequirementSet requirementSet = job.getRequirementSet();
        Requirement requirement = requirementSet.getRequirement(requirementId);
        BambooValidationUtils.validate(requirement != null, () -> this.textProvider.getText("requirement.error.requirementnotfound"));
        BambooValidationUtils.validate(requirement.isReadonly() == false, () -> this.textProvider.getText("requirement.error.readonly"));
        requirementSet.removeRequirement((ImmutableRequirement)requirement);
        this.planManager.savePlan((Plan)job);
        this.auditLogService.log(this.textProvider.getText("requirement.remove.auditentry"), requirement.toString(), null, (Key)job.getPlanKey(), AuditLogEntityType.PLAN, null);
        this.eventPublisher.publish((Object)new BuildRequirementUpdatedEvent((Object)this, job.getPlanKey()));
    }

    private ImmutableJob getAndValidateJob(PlanKey jobKey) {
        ImmutableJob job = (ImmutableJob)this.cachedPlanManager.getPlanByKeyIfOfType(jobKey, ImmutableJob.class);
        if (job == null) {
            throw new NotFoundException(this.textProvider.getText("requirement.error.nojob", Collections.singletonList(jobKey.getKey())));
        }
        if (!this.bambooPermissionManager.hasPermission((Permission)BambooPermission.WRITE, (Object)job, null)) {
            throw new AccessDeniedException(this.textProvider.getText("requirement.error.permission"));
        }
        return job;
    }

    private ErrorCollection validateFields(@Nullable String key, @Nullable ImmutableRequirement.MatchType matchType, @Nullable String matchValue) {
        key = StringUtils.trim((String)key);
        matchValue = StringUtils.trim((String)matchValue);
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (StringUtils.isBlank((CharSequence)key)) {
            errorCollection.addError("key", this.textProvider.getText("requirement.error.emptyKey"));
        } else {
            errorCollection.addErrorCollection(BambooFieldValidate.checkFieldXssSafety((com.opensymphony.xwork2.TextProvider)this.textProvider, "key", key));
        }
        if (matchType == null) {
            errorCollection.addError("matchType", this.textProvider.getText("requirement.error.matchTypeInvalid", (List)Lists.newArrayList((Object[])new String[]{ImmutableRequirement.MatchType.EXISTS.name(), ImmutableRequirement.MatchType.MATCHES.name(), ImmutableRequirement.MatchType.EQUALS.name()})));
        }
        if (ImmutableRequirement.MatchType.EXISTS != matchType) {
            if (StringUtils.isBlank((CharSequence)matchValue)) {
                errorCollection.addError("matchValue", this.textProvider.getText("requirement.error.valueMissing"));
            } else if (ImmutableRequirement.MatchType.MATCHES == matchType) {
                try {
                    Pattern.compile(matchValue);
                }
                catch (PatternSyntaxException e) {
                    errorCollection.addError("matchValue", this.textProvider.getText("requirement.error.invalidRegex"));
                }
            }
        }
        return errorCollection;
    }

    private void setValues(@NotNull RequirementImpl requirement, @NotNull String key, @NotNull ImmutableRequirement.MatchType matchType, @Nullable String matchValue) {
        key = StringUtils.trim((String)key);
        matchValue = StringUtils.trim((String)matchValue);
        boolean regexMatch = false;
        switch (matchType) {
            case EXISTS: {
                regexMatch = true;
                matchValue = ".*";
                break;
            }
            case EQUALS: {
                regexMatch = false;
                break;
            }
            case MATCHES: {
                regexMatch = true;
            }
        }
        requirement.setKey(key);
        requirement.setMatchValue(matchValue);
        requirement.setRegexMatch(regexMatch);
    }

    private Map<Long, String> getTaskNames(ImmutableJob job) {
        HashMap<Long, String> taskDescriptions = new HashMap<Long, String>();
        taskDescriptions.put(-1L, "");
        for (TaskDefinition task : job.getBuildDefinition().getTaskDefinitions()) {
            String description = this.getTaskName(task);
            taskDescriptions.put(task.getId(), description);
        }
        return taskDescriptions;
    }

    private String getTaskName(TaskDefinition taskDefinition) {
        String taskName = "";
        if (StringUtils.isBlank((CharSequence)taskDefinition.getUserDescription())) {
            TaskModuleDescriptor taskDescriptor = this.taskManager.getTaskDescriptor(taskDefinition.getPluginKey());
            if (taskDescriptor != null) {
                taskName = taskDescriptor.getName();
            }
        } else {
            taskName = taskDefinition.getUserDescription();
        }
        return taskName;
    }

    private ExecutableAgentsMatrix getExecutableAgentsMatrix(MinimalRequirementSet requirementSet, ImmutableJob job) {
        ExecutableAgentsHelper.ExecutorQuery executorQuery = ExecutableAgentsHelper.ExecutorQuery.newQuery(requirementSet, AgentAssignmentServiceHelper.asExecutable((ImmutableBuildable)job)).withDisabledIncluded().withOfflineIncluded();
        return this.executableAgentsHelper.getExecutableAgentsMatrix(executorQuery);
    }

    private RequirementDetails getRequirementDetails(@NotNull ImmutableJob job, @Nullable Requirement requirement) {
        if (requirement == null) {
            return null;
        }
        HashMap<Long, String> taskDescriptions = new HashMap();
        if (requirement.getOwnerId() > 0L) {
            taskDescriptions = this.getTaskNames(job);
        }
        return this.getRequirementDetails((ImmutableRequirement)requirement, this.getExecutableAgentsMatrix(new RequirementUtils.MinimalRequirementSetImpl(new ImmutableRequirement[]{requirement}), job), taskDescriptions);
    }

    private RequirementDetails getRequirementDetails(@Nullable ImmutableRequirement requirement, @NotNull ExecutableAgentsMatrix executableAgentsMatrix, @NotNull Map<Long, String> taskDescriptions) {
        Collection imagesFromMatrix;
        if (requirement == null) {
            return null;
        }
        CapabilityType type = this.capabilityHelper.getCapabilityTypeFromKey(requirement.getKey());
        String taskName = taskDescriptions.get(requirement.getOwnerId());
        Integer supportedAgents = 0;
        Collection buildAgents = executableAgentsMatrix.getBuildAgents(requirement.getKey());
        if (buildAgents != null) {
            supportedAgents = buildAgents.size();
        }
        Integer supportedImages = 0;
        if (this.isElasticBambooEnabled() && (imagesFromMatrix = executableAgentsMatrix.getImageFromMatrix(requirement.getKey())) != null) {
            supportedImages = imagesFromMatrix.size();
        }
        return new RequirementDetailsImpl(requirement, type, taskName, supportedAgents, supportedImages);
    }

    private boolean isElasticBambooEnabled() {
        return this.elasticFunctionalityFacade.isElasticSupportEnabled();
    }
}

