/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.task;

import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskState;
import com.atlassian.bamboo.v2.build.CurrentResult;
import com.google.common.collect.Iterables;
import java.util.List;
import org.apache.log4j.Logger;

public class BuildStateHelper {
    private static final Logger log = Logger.getLogger(BuildStateHelper.class);

    public static void calculateBuildAndLifeCycleState(CurrentResult buildResult, List<TaskResult> taskResults) {
        TaskResult taskResult = BuildStateHelper.findRelevantTaskResult(taskResults);
        if (taskResult == null) {
            buildResult.setBuildState(BuildState.FAILED);
        } else if (taskResult.getTaskState() == TaskState.ERROR) {
            buildResult.setBuildState(BuildState.FAILED);
        } else if (taskResult.getTaskState() == TaskState.SUCCESS) {
            buildResult.setBuildState(BuildState.SUCCESS);
        } else if (taskResult.getTaskState() == TaskState.FAILED) {
            buildResult.setBuildState(BuildState.FAILED);
        }
    }

    private static TaskResult findRelevantTaskResult(List<TaskResult> taskResults) {
        TaskResult taskResult2 = null;
        for (TaskResult taskResult2 : taskResults) {
            if (taskResult2.getTaskState() != TaskState.SUCCESS) break;
        }
        if (taskResult2 == null && !taskResults.isEmpty()) {
            taskResult2 = (TaskResult)Iterables.getLast(taskResults);
        }
        return taskResult2;
    }
}

