/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.task;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.build.fileserver.BuildDirectoryManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.RepositoryDefinitionException;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.repository.perforce.PerforceRepository;
import com.atlassian.bamboo.serialization.xstream.StrippingConverter;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskRootDirectorySelector;
import com.atlassian.bamboo.task.repository.RepositoryTaskHelper;
import com.atlassian.bamboo.util.BambooFileUtils;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.v2.build.task.CheckoutDirectoriesData;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.vcs.runtime.FixedDirectoryWorkingCopyManager;
import com.atlassian.bamboo.vcs.runtime.VcsWorkingCopyManager;
import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

class CheckoutDirectoriesSnapshotHelper {
    private static final Logger log = Logger.getLogger(CheckoutDirectoriesSnapshotHelper.class);
    public static final String CFG_CHECKOUT_DIR_PREFIX = "checkoutDir_";
    private static final long INVALID_ID = 0L;
    private CheckoutDirectoriesData previousSnapshot = null;
    private final Map<String, Long> newCheckoutDirectories = new HashMap<String, Long>();
    private final Set<String> perforceUnmanagedWorspaces = new HashSet<String>();
    private final File workingDirectory;
    private final XStream xStream;
    private final CommonContext commonContext;
    private final BuildContext buildContext;

    public CheckoutDirectoriesSnapshotHelper(@NotNull BuildDirectoryManager buildDirectoryManager, @NotNull VcsRepositoryManager vcsRepositoryManager, @NotNull BuildLogger buildLogger, @NotNull CommonContext commonContext) throws RepositoryException, RepositoryDefinitionException {
        this.commonContext = commonContext;
        this.buildContext = (BuildContext)Narrow.to((Object)commonContext, BuildContext.class);
        this.xStream = this.createXStream();
        Iterable<TaskDefinition> checkoutTasks = BambooPluginUtils.filterEnabledTasks(commonContext.getRuntimeTaskDefinitions(), "com.atlassian.bamboo.plugins.vcs:task.vcs.checkout");
        Key entityKey = commonContext.getResultKey().getEntityKey();
        PlanKey planKey = null;
        if (this.buildContext != null) {
            planKey = this.buildContext.getPlanResultKey().getPlanKey();
        }
        File defaultWorkingDirectory = buildDirectoryManager.getBuildWorkingDirectory(entityKey);
        long repositoryIdDefiningWorkingDir = -1L;
        if (this.buildContext != null) {
            repositoryIdDefiningWorkingDir = this.buildContext.getBuildDefinition().getRepositoryIdDefiningWorkingDir();
        }
        if (repositoryIdDefiningWorkingDir == -1L || repositoryIdDefiningWorkingDir == 0L) {
            this.workingDirectory = defaultWorkingDirectory;
        } else {
            PlanRepositoryDefinition repositoryDefiningWorkingDir = (PlanRepositoryDefinition)commonContext.getVcsRepositoryMap().get(repositoryIdDefiningWorkingDir);
            VcsWorkingCopyManager workingCopyManager = vcsRepositoryManager.getVcsRepositoryModuleDescriptor((repositoryDefiningWorkingDir = (PlanRepositoryDefinition)Preconditions.checkNotNull((Object)repositoryDefiningWorkingDir, (Object)("Repository " + repositoryIdDefiningWorkingDir + " not found in build"))).getPluginKey()).getWorkingCopyManager();
            if (workingCopyManager instanceof FixedDirectoryWorkingCopyManager) {
                this.workingDirectory = ((FixedDirectoryWorkingCopyManager)workingCopyManager).getWorkingCopyPath(commonContext, (VcsRepositoryData)repositoryDefiningWorkingDir);
            } else {
                log.warn((Object)"Fixed working directory source defined, but corresponding repository does not provide it");
                this.workingDirectory = defaultWorkingDirectory;
            }
        }
        for (TaskDefinition taskDefinition : checkoutTasks) {
            File taskWorkingDirectory;
            TaskRootDirectorySelector taskRootDirectorySelector = taskDefinition.getRootDirectorySelector();
            if (taskRootDirectorySelector.equals((Object)TaskRootDirectorySelector.INHERITED)) {
                taskWorkingDirectory = this.workingDirectory;
            } else if (taskRootDirectorySelector.equals((Object)TaskRootDirectorySelector.DEFAULT)) {
                taskWorkingDirectory = defaultWorkingDirectory;
            } else {
                PlanRepositoryDefinition repositoryDefiningWorkingDir = (PlanRepositoryDefinition)commonContext.getVcsRepositoryMap().get(taskRootDirectorySelector.getRepositoryDefiningWorkingDirectory());
                VcsWorkingCopyManager workingCopyManager = vcsRepositoryManager.getVcsRepositoryModuleDescriptor(repositoryDefiningWorkingDir.getPluginKey()).getWorkingCopyManager();
                if (workingCopyManager instanceof FixedDirectoryWorkingCopyManager) {
                    taskWorkingDirectory = ((FixedDirectoryWorkingCopyManager)workingCopyManager).getWorkingCopyPath(commonContext, (VcsRepositoryData)repositoryDefiningWorkingDir);
                } else {
                    log.warn((Object)"Fixed working directory source defined, but corresponding repository does not provide it");
                    taskWorkingDirectory = defaultWorkingDirectory;
                }
            }
            List sortedKeys = taskDefinition.getConfiguration().keySet().stream().filter(arg_0 -> RepositoryTaskHelper.isRepositorySelector.apply(arg_0)).sorted((Comparator<String>)RepositoryTaskHelper.orderingOfRepositorySelectors).collect(Collectors.toList());
            for (String key : sortedKeys) {
                String indexString = key.substring(RepositoryTaskHelper.CFG_SELECTED_REPOSITORY_ID_PREFIX.length());
                String checkoutDirectory = (String)taskDefinition.getConfiguration().get(CFG_CHECKOUT_DIR_PREFIX + indexString);
                PlanRepositoryDefinition repositoryDefinition = RepositoryTaskHelper.getPlanRepositoryByIdSelector(commonContext, taskDefinition, key);
                VcsRepositoryModuleDescriptor moduleDescriptor = vcsRepositoryManager.getVcsRepositoryModuleDescriptor(repositoryDefinition.getPluginKey());
                if (moduleDescriptor == null) {
                    throw new RepositoryException("Plugin " + repositoryDefinition.getPluginKey() + " not available", repositoryDefinition.getId());
                }
                VcsWorkingCopyManager workingCopyManager = moduleDescriptor.getWorkingCopyManager();
                if (workingCopyManager instanceof FixedDirectoryWorkingCopyManager) {
                    Repository repository;
                    if (repositoryDefinition.isLegacyRepository() && (repository = repositoryDefinition.asLegacyData().getRepository()) instanceof PerforceRepository && !((PerforceRepository)repository).isManageWorkspace()) {
                        this.perforceUnmanagedWorspaces.add(repository.getSourceCodeDirectory(planKey).getAbsolutePath());
                    }
                    this.newCheckoutDirectories.put(((FixedDirectoryWorkingCopyManager)workingCopyManager).getWorkingCopyPath(commonContext, (VcsRepositoryData)repositoryDefinition).getAbsolutePath(), repositoryDefinition.getId());
                    continue;
                }
                this.newCheckoutDirectories.put(new File(taskWorkingDirectory, checkoutDirectory).getAbsolutePath(), repositoryDefinition.getId());
            }
        }
        log.info((Object)buildLogger.addBuildLogEntry("Build working directory is " + this.workingDirectory.getAbsolutePath()));
    }

    public List<String> getDirectoriesToCleanUp() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.previousSnapshot != null) {
            result.addAll(this.previousSnapshot.getCheckoutDirectories().keySet());
            result.removeAll(this.perforceUnmanagedWorspaces);
            if (this.previousSnapshot.getPlanId() == 0L || this.previousSnapshot.getPlanId() == this.commonContext.getEntityId()) {
                for (Map.Entry<String, Long> checkoutDir : this.newCheckoutDirectories.entrySet()) {
                    Long oldRepositoryId = this.previousSnapshot.getCheckoutDirectories().get(checkoutDir.getKey());
                    if (!checkoutDir.getValue().equals(oldRepositoryId)) continue;
                    result.remove(checkoutDir.getKey());
                }
            }
        }
        return result;
    }

    public void readSnapshotFromFile(File snapshotFile) {
        this.previousSnapshot = null;
        if (snapshotFile.exists()) {
            try {
                try {
                    this.previousSnapshot = (CheckoutDirectoriesData)this.xStream.fromXML(snapshotFile);
                }
                catch (ClassCastException e) {
                    Map oldFormatConfiguration = (Map)this.xStream.fromXML(snapshotFile);
                    this.previousSnapshot = new CheckoutDirectoriesData(0L, oldFormatConfiguration);
                    BambooFileUtils.deleteQuietly(snapshotFile);
                }
            }
            catch (Exception e) {
                this.previousSnapshot = null;
                log.warn((Object)"Exception when reading repository data ", (Throwable)e);
                log.info((Object)("Removing corrupted repository data file: " + snapshotFile.getAbsolutePath()));
                BambooFileUtils.deleteQuietly(snapshotFile);
            }
        }
    }

    public void writeSnapshotToFile(File snapshotFile) {
        try {
            CheckoutDirectoriesData newSnapshot = new CheckoutDirectoriesData(this.commonContext.getEntityId(), this.newCheckoutDirectories);
            try (FileOutputStream os = new FileOutputStream(snapshotFile);){
                this.xStream.toXML((Object)newSnapshot, (OutputStream)os);
            }
        }
        catch (IOException e) {
            log.warn((Object)"Exception when writing repository data ", (Throwable)e);
        }
    }

    private XStream createXStream() {
        XStream xStream = new XStream();
        xStream.alias("data", CheckoutDirectoriesData.class);
        xStream.registerConverter((Converter)new StrippingConverter());
        return xStream;
    }

    XStream getXStream() {
        return this.xStream;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }
}

