/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.task;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.fileserver.BuildDirectoryManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.execution.ExecutionPhaseService;
import com.atlassian.bamboo.repository.RepositoryDefinitionException;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.setup.HomeDirectoryLayout;
import com.atlassian.bamboo.util.BambooFileUtils;
import com.atlassian.bamboo.util.BambooObjectUtils;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.v2.build.agent.BuildPhase;
import com.atlassian.bamboo.v2.build.agent.InterruptibleBuildPhase;
import com.atlassian.bamboo.v2.build.agent.capability.ReadOnlyCapabilitySet;
import com.atlassian.bamboo.v2.build.task.CheckoutDirectoriesSnapshotHelper;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Internal
public class InitializeBuild
implements BuildPhase,
InterruptibleBuildPhase {
    private static final Logger log = Logger.getLogger(InitializeBuild.class);
    private static final String TMP_DIRECTORY = "tmp.directory";
    private static final String GIT_CACHE_DIRECTORY = "git.cache.directory";
    private static final String HG_CACHE_DIRECTORY = "hg.cache.directory";
    private static final String GIT_CACHE_DIRECTORY_NAME = "_git-repositories-cache";
    private static final String HG_CACHE_DIRECTORY_NAME = "_hg-repositories-cache";
    private BuildDirectoryManager buildDirectoryManager;
    private BuildLoggerManager buildLoggerManager;
    private ExecutionPhaseService executionPhaseService;
    private VcsRepositoryManager vcsRepositoryManager;
    private HomeDirectoryLayout homeDirectoryLayout;

    @NotNull
    public CommonContext call(@NotNull CommonContext commonContext, @NotNull ReadOnlyCapabilitySet capabilitySet) throws RepositoryException, RepositoryDefinitionException {
        try {
            return this.doCall(commonContext);
        }
        catch (RepositoryException | RuntimeException e) {
            this.failBuild(commonContext, (Exception)e);
            throw e;
        }
    }

    private void failBuild(CommonContext commonContext, Exception e) {
        commonContext.getCurrentResult().setBuildState(BuildState.FAILED);
        commonContext.getCurrentResult().addBuildErrors(Arrays.asList("The build has failed to check out the source code: " + e.getMessage()));
        this.executionPhaseService.executionFinished(commonContext);
    }

    private CommonContext doCall(CommonContext commonContext) throws RepositoryException, RepositoryDefinitionException {
        commonContext.getCurrentResult().setStarted(true);
        commonContext.getCurrentResult().setLifeCycleState(LifeCycleState.IN_PROGRESS);
        this.executionPhaseService.vcsSyncStarted(commonContext);
        File workingDirectory = this.prepareWorkingDirectory(commonContext);
        Map customBuildData = commonContext.getCurrentResult().getCustomBuildData();
        customBuildData.put("working.directory", workingDirectory.getAbsolutePath());
        customBuildData.put("build.working.directory", workingDirectory.getAbsolutePath());
        customBuildData.put(TMP_DIRECTORY, this.homeDirectoryLayout.getTempDirectory().getAbsolutePath());
        customBuildData.put(GIT_CACHE_DIRECTORY, new File(this.buildDirectoryManager.getBaseBuildWorkingDirectory(), GIT_CACHE_DIRECTORY_NAME).getAbsolutePath());
        customBuildData.put(HG_CACHE_DIRECTORY, new File(this.buildDirectoryManager.getBaseBuildWorkingDirectory(), HG_CACHE_DIRECTORY_NAME).getAbsolutePath());
        return commonContext;
    }

    private File prepareWorkingDirectory(CommonContext commonContext) throws RepositoryException, RepositoryDefinitionException {
        File agentWorkingDir = this.buildDirectoryManager.getWorkingDirectoryOfCurrentAgent();
        Preconditions.checkState((agentWorkingDir != null ? 1 : 0) != 0, (Object)"FATAL: No agent working dir defined");
        BuildLogger buildLogger = this.buildLoggerManager.getLogger(commonContext.getResultKey());
        CheckoutDirectoriesSnapshotHelper repositoryDataSnapshot = new CheckoutDirectoriesSnapshotHelper(this.buildDirectoryManager, this.vcsRepositoryManager, buildLogger, commonContext);
        File snapshotDir = new File(agentWorkingDir, "repositoryData");
        snapshotDir.mkdirs();
        File snapshotFile = new File(snapshotDir, commonContext.getEntityKey() + ".xml");
        repositoryDataSnapshot.readSnapshotFromFile(snapshotFile);
        this.cleanDirectories(commonContext, repositoryDataSnapshot.getDirectoriesToCleanUp(), buildLogger, this.buildDirectoryManager.getBuildWorkingDirectory(commonContext.getEntityKey()));
        repositoryDataSnapshot.writeSnapshotToFile(snapshotFile);
        File workingDirectory = repositoryDataSnapshot.getWorkingDirectory();
        try {
            FileUtils.forceMkdir((File)workingDirectory);
        }
        catch (IOException e) {
            throw BambooObjectUtils.asRuntimeException((Throwable)e);
        }
        return workingDirectory;
    }

    private void cleanDirectories(CommonContext commonContext, Iterable<String> directoriesToCleanup, BuildLogger buildLogger, File defaultWorkingDirectory) {
        for (String dir : directoriesToCleanup) {
            File dirToCleanup = new File(dir);
            if (!dirToCleanup.exists() || !dirToCleanup.getAbsolutePath().startsWith(defaultWorkingDirectory.getAbsolutePath())) continue;
            log.info((Object)buildLogger.addBuildLogEntry("Cleaning directory " + dirToCleanup.getAbsolutePath()));
            if (BambooFileUtils.isDirectoryImportant(dirToCleanup)) {
                String errorMessage = "A clean build cannot be forced for " + commonContext.getDisplayName() + ", as the plan's source directory " + dirToCleanup.getAbsolutePath() + " is reserved by the system. Please amend your build configuration.";
                log.warn((Object)buildLogger.addErrorLogEntry(errorMessage));
                commonContext.getCurrentResult().setBuildState(BuildState.FAILED);
                continue;
            }
            try {
                BambooFileUtils.cleanDirectory(dirToCleanup);
            }
            catch (IOException e) {
                String errorMessage = "Unable to clean source directory '" + dirToCleanup.getAbsolutePath() + "' " + e.getMessage();
                log.warn((Object)buildLogger.addErrorLogEntry(errorMessage), (Throwable)e);
                commonContext.getCurrentResult().setBuildState(BuildState.FAILED);
            }
        }
    }

    public void setBuildDirectoryManager(BuildDirectoryManager buildDirectoryManager) {
        this.buildDirectoryManager = buildDirectoryManager;
    }

    public void setBuildLoggerManager(BuildLoggerManager buildLoggerManager) {
        this.buildLoggerManager = buildLoggerManager;
    }

    public void setExecutionPhaseService(ExecutionPhaseService executionPhaseService) {
        this.executionPhaseService = executionPhaseService;
    }

    public void setVcsRepositoryManager(VcsRepositoryManager vcsRepositoryManager) {
        this.vcsRepositoryManager = vcsRepositoryManager;
    }

    public void setHomeDirectoryLayout(HomeDirectoryLayout homeDirectoryLayout) {
        this.homeDirectoryLayout = homeDirectoryLayout;
    }
}

