/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.timing;

import com.atlassian.bamboo.deployments.execution.events.DeploymentTimingPoint;
import com.atlassian.bamboo.deployments.execution.events.OutOfBandDeploymentTimingPoints;
import com.atlassian.bamboo.v2.build.timing.OutOfBandBuildTimingPoints;
import com.atlassian.bamboo.v2.build.timing.OutOfBandTimingPointWrapper;
import com.atlassian.bamboo.v2.build.timing.OutOfBandTimingPoints;
import com.atlassian.bamboo.v2.build.timing.TimingPoint;
import com.atlassian.bamboo.v2.build.timing.TimingPointService;
import com.atlassian.event.api.EventPublisher;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class TimingPointServiceImpl
implements TimingPointService {
    private static final Logger log = Logger.getLogger(TimingPointServiceImpl.class);
    private final EventPublisher eventPublisher;

    public TimingPointServiceImpl(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void publish(@NotNull TimingPoint timingPoint) {
        boolean isOutOfBand = true;
        this.publish(timingPoint, true);
        this.publish(timingPoint, false);
    }

    public void publish(TimingPoint timingPoint, boolean isOutOfBand) {
        TimingPoint timingPointToPublish;
        TimingPoint timingPoint2 = timingPointToPublish = isOutOfBand ? this.getOobTimingPointFor(timingPoint) : timingPoint;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Publishing timing point " + timingPointToPublish));
        }
        this.eventPublisher.publish((Object)timingPointToPublish);
    }

    private TimingPoint getOobTimingPointFor(TimingPoint timingPoint) {
        Class oobTimingPointClass;
        Class clazz = oobTimingPointClass = timingPoint instanceof DeploymentTimingPoint ? OutOfBandDeploymentTimingPoints.getOobClassForTimingPoint((TimingPoint)timingPoint) : OutOfBandBuildTimingPoints.getOobClassForTimingPoint((TimingPoint)timingPoint);
        if (oobTimingPointClass == null) {
            return new OutOfBandTimingPointWrapper(timingPoint);
        }
        return OutOfBandTimingPoints.oobTimingPointFor((Logger)log, (Class)oobTimingPointClass, (TimingPoint)timingPoint);
    }
}

