/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.trigger;

import com.atlassian.bamboo.author.Author;
import com.atlassian.bamboo.author.AuthorContext;
import com.atlassian.bamboo.collections.message.FinalHashSet;
import com.atlassian.bamboo.commit.AuthorContextImpl;
import com.atlassian.bamboo.commit.Commit;
import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.commit.CommitManager;
import com.atlassian.bamboo.commit.CommitPredicates;
import com.atlassian.bamboo.index.buildresult.BuildResultsSummaryDocument;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.bamboo.util.HtmlUtils;
import com.atlassian.bamboo.v2.build.CurrentlyBuilding;
import com.atlassian.bamboo.v2.build.trigger.DefaultTriggerReasonRenderer;
import com.atlassian.bamboo.v2.build.trigger.TriggerReason;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.user.User;
import com.google.common.collect.Iterables;
import io.atlassian.util.concurrent.LazyReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class CodeChangedTriggerReasonRenderer
extends DefaultTriggerReasonRenderer {
    private static final Logger log = Logger.getLogger(CodeChangedTriggerReasonRenderer.class);
    private static final int MAX_POPUP_LINE_COUNT = 15;
    private String changesListSummary;
    private FinalHashSet<AuthorWrapper> uniqueAuthors;
    private transient CommitManager commitManager;

    @Override
    public void init(ModuleDescriptor<TriggerReason> moduleDescriptor, TriggerReason triggerReason, ResultsSummary buildResultsSummary) {
        Object commitsForResult;
        super.init(moduleDescriptor, triggerReason, buildResultsSummary);
        if (buildResultsSummary instanceof BuildResultsSummaryDocument) {
            commitsForResult = buildResultsSummary.getCommits();
            this.uniqueAuthors = buildResultsSummary.getUniqueAuthors().stream().map(AuthorWrapper::new).collect(Collectors.toCollection(FinalHashSet::new));
        } else {
            commitsForResult = this.commitManager.getCommitsForResult(buildResultsSummary);
            this.uniqueAuthors = this.getUniqueAuthors((Iterable<Commit>)commitsForResult).stream().map(AuthorWrapper::new).collect(Collectors.toCollection(FinalHashSet::new));
        }
        this.setSourceChangeList((Collection<? extends CommitContext>)commitsForResult);
    }

    @Override
    public void init(ModuleDescriptor<TriggerReason> moduleDescriptor, TriggerReason triggerReason, CurrentlyBuilding currentlyBuilding) {
        super.init(moduleDescriptor, triggerReason, currentlyBuilding);
        List commits = currentlyBuilding.getBuildChanges().getChanges();
        this.setSourceChangeList(commits);
        this.initiateAuthorsFromCommits(commits);
    }

    @Override
    @NotNull
    protected Map<String, Object> getContextParams() {
        Map<String, Object> contextParams = super.getContextParams();
        if (this.changesListSummary != null) {
            contextParams.put("changesListSummary", this.changesListSummary);
        }
        if (this.uniqueAuthors != null) {
            LinkedHashMap authorsByFullName = new LinkedHashMap();
            this.uniqueAuthors.forEach(a -> authorsByFullName.putIfAbsent(a.getFullName(), a));
            contextParams.put("uniqueAuthors", authorsByFullName.values());
        }
        return contextParams;
    }

    private Set<Author> getUniqueAuthors(Iterable<Commit> commits) {
        return BambooIterables.stream(commits).filter(CommitPredicates::isCommitRelevantToBranch).map(Commit::getAuthor).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private void setSourceChangeList(Collection<? extends CommitContext> commitList) {
        if (CollectionUtils.isEmpty(commitList)) {
            return;
        }
        StringBuilder changeListPopup = new StringBuilder();
        int changeListPopupLineCount = 0;
        Iterator iterator = Iterables.filter(commitList, CommitPredicates::isCommitRelevantToBranch).iterator();
        while (iterator.hasNext()) {
            CommitContext commit = (CommitContext)iterator.next();
            AuthorWrapper author = new AuthorWrapper(commit.getAuthorContext());
            String authorName = author.getFullName();
            changeListPopupLineCount = this.addPopupLine(changeListPopup, changeListPopupLineCount, "<strong>Who:</strong> ", HtmlUtils.getAsPreformattedText((Object)authorName));
            changeListPopupLineCount = this.addPopupLine(changeListPopup, changeListPopupLineCount, "<strong>Why:</strong> ", HtmlUtils.getAsPreformattedText((Object)commit.getComment()));
            if (!iterator.hasNext()) continue;
            this.addLineToPopup(changeListPopup, "<hr>", changeListPopupLineCount++);
        }
        this.changesListSummary = changeListPopup.toString();
        this.changesListSummary = StringUtils.replace((String)this.changesListSummary, (String)"'", (String)"\"");
        this.changesListSummary = StringUtils.replace((String)this.changesListSummary, (String)"\r\n", (String)"");
        this.changesListSummary = StringUtils.replace((String)this.changesListSummary, (String)"\n", (String)"");
    }

    private int addPopupLine(StringBuilder changeListPopup, int changeListPopupLineCount, String lineHeading, String lineInfo) {
        String line = lineHeading;
        if (lineInfo != null) {
            line = line + lineInfo;
        }
        this.addLineToPopup(changeListPopup, line, changeListPopupLineCount++);
        return changeListPopupLineCount;
    }

    private void addLineToPopup(StringBuilder changeListPopup, String line, int changeListPopupLineCount) {
        if (changeListPopupLineCount < 15) {
            changeListPopup.append(line).append("<br>");
        } else if (changeListPopupLineCount == 15) {
            changeListPopup.append("... ");
        }
    }

    private void initiateAuthorsFromCommits(List<CommitContext> commits) {
        this.uniqueAuthors = new FinalHashSet();
        if (commits != null) {
            commits.stream().filter(CommitPredicates::isCommitRelevantToBranch).map(CommitContext::getAuthorContext).filter(Objects::nonNull).map(AuthorWrapper::new).forEach(arg_0 -> this.uniqueAuthors.add(arg_0));
        }
    }

    public void setCommitManager(CommitManager commitManager) {
        this.commitManager = commitManager;
    }

    public static class AuthorWrapper
    extends AuthorContextImpl {
        final String knownName;
        private transient LazyReference<String> fullNameRef = new FullNameLazyReference();

        public AuthorWrapper(AuthorContext author) {
            super(author);
            this.knownName = author instanceof Author ? ((Author)author).getFullName() : null;
        }

        @NotNull
        public String getFullName() {
            return (String)this.fullNameRef.get();
        }

        private class FullNameLazyReference
        extends LazyReference<String> {
            private FullNameLazyReference() {
            }

            @NotNull
            protected String create() throws Exception {
                User user;
                if (AuthorWrapper.this.knownName != null) {
                    return AuthorWrapper.this.knownName;
                }
                if (AuthorWrapper.this.getLinkedUserName() != null && (user = ((BambooUserManager)ComponentAccessor.BAMBOO_USER_MANAGER.get()).getUser(AuthorWrapper.this.getLinkedUserName())) != null) {
                    return (String)StringUtils.defaultIfEmpty((CharSequence)user.getFullName(), (CharSequence)user.getName());
                }
                return StringUtils.defaultString((String)AuthorWrapper.this.getName());
            }
        }
    }
}

