/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.trigger;

import com.atlassian.bamboo.build.BuildDetectionAction;
import com.atlassian.bamboo.build.BuildNumberGeneratorService;
import com.atlassian.bamboo.build.context.BuildContextBuilderFactory;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.chains.ChainExecutionManager;
import com.atlassian.bamboo.configuration.ConfigurationException;
import com.atlassian.bamboo.logger.ErrorUpdateHandler;
import com.atlassian.bamboo.plan.PlanExecutionManager;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.cache.ImmutablePlanCacheService;
import com.atlassian.bamboo.plan.trigger.TriggerManager;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.trigger.TriggerDefinition;
import com.atlassian.bamboo.util.AcquisitionPolicy;
import com.atlassian.bamboo.utils.OptionalNarrow;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.v2.build.BuildChanges;
import com.atlassian.bamboo.v2.build.dependencies.DependencyTreeBuilder;
import com.atlassian.bamboo.v2.build.trigger.DependencyBlockingManager;
import com.atlassian.bamboo.v2.build.trigger.DependencyBlockingStrategy;
import com.atlassian.bamboo.v2.trigger.ChangeDetectionManager;
import com.atlassian.bamboo.v2.trigger.ChildDependencyBuildDetectionAction;
import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class DefaultDependencyBlockingManager
implements DependencyBlockingManager {
    private static final Logger log = Logger.getLogger(DefaultDependencyBlockingManager.class);
    private final DependencyTreeBuilder dependencyTreeBuilder;
    private final ImmutablePlanCacheService immutablePlanCacheService;
    private final ChainExecutionManager chainExecutionManager;
    private final ChangeDetectionManager changeDetectionManager;
    private final PlanExecutionManager planExecutionManager;
    private final TriggerManager triggerManager;
    private final ErrorUpdateHandler errorUpdateHandler;
    private final BuildNumberGeneratorService buildNumberGenerator;
    private final BuildContextBuilderFactory buildContextBuilderFactory;

    public DefaultDependencyBlockingManager(DependencyTreeBuilder dependencyTreeBuilder, ImmutablePlanCacheService immutablePlanCacheService, ChangeDetectionManager changeDetectionManager, PlanExecutionManager planExecutionManager, TriggerManager triggerManager, ErrorUpdateHandler errorUpdateHandler, BuildNumberGeneratorService buildNumberGenerator, ChainExecutionManager chainExecutionManager, BuildContextBuilderFactory buildContextBuilderFactory) {
        this.dependencyTreeBuilder = dependencyTreeBuilder;
        this.immutablePlanCacheService = immutablePlanCacheService;
        this.changeDetectionManager = changeDetectionManager;
        this.planExecutionManager = planExecutionManager;
        this.triggerManager = triggerManager;
        this.errorUpdateHandler = errorUpdateHandler;
        this.buildNumberGenerator = buildNumberGenerator;
        this.chainExecutionManager = chainExecutionManager;
        this.buildContextBuilderFactory = buildContextBuilderFactory;
    }

    public boolean isBlockedFromBuilding(PlanKey planKey) {
        return this.isBlockedFromBuilding(planKey, null);
    }

    public boolean isBlockedFromBuilding(PlanKey planKey, @Nullable Set<? extends ImmutablePlan> plansBeingTriggered) {
        log.debug((Object)"Checking if build should be blocked due to dependency configuration.");
        ImmutableChain childChain = this.immutablePlanCacheService.getImmutablePlanByKey(planKey);
        if (childChain == null) {
            return false;
        }
        try {
            BuildLogger buildLogger = childChain.getBuildLogger();
            if (this.isStrategyToBuildParentIfHasChanges((ImmutablePlan)childChain)) {
                List<ImmutableChain> parents = this.dependencyTreeBuilder.getDirectParents((ImmutablePlan)childChain).stream().flatMap(OptionalNarrow.down(ImmutableChain.class)).collect(Collectors.toList());
                List parentPlanKeys = parents.stream().map(PlanIdentifier::getPlanKey).collect(Collectors.toList());
                log.info((Object)("Checking if parents " + parentPlanKeys + " have changes..."));
                Pair<ImmutableChain, BuildChanges> parentWithChanges = this.getFirstParentWithChanges((PlanIdentifier)childChain, parents);
                if (parentWithChanges != null) {
                    this.executeBuild(parentWithChanges, (PlanIdentifier)childChain);
                    log.info((Object)(planKey + " : " + buildLogger.addBuildLogEntry("Triggering for this build was blocked because its parent '" + ((ImmutableChain)parentWithChanges.first).getName() + "' has changes and has been put on the build queue.")));
                    return true;
                }
                ImmutableChain parentInQueue = this.getFirstQueuedOrBuildingParent(parents);
                if (parentInQueue != null) {
                    String message = "Triggering for this build was blocked because its parent '" + parentInQueue.getName() + "' was already in the queue";
                    buildLogger.addBuildLogEntry(message);
                    log.info((Object)(planKey + " : " + message));
                    return true;
                }
                ImmutablePlan aboutToBeTriggered = this.getBlockingPlanBeingTriggered(parents, plansBeingTriggered);
                return this.isTriggeringBlockedBecauseOfParent(planKey, buildLogger, aboutToBeTriggered);
            }
            if (this.isStrategyDontBuildIfParentInQueue((ImmutablePlan)childChain)) {
                List<ImmutableChain> parents = this.dependencyTreeBuilder.getDirectParents((ImmutablePlan)childChain).stream().flatMap(OptionalNarrow.down(ImmutableChain.class)).collect(Collectors.toList());
                ImmutableChain parentInQueueOrBuilding = this.getFirstQueuedOrBuildingParent(parents);
                if (parentInQueueOrBuilding == null) {
                    ImmutablePlan aboutToBeTriggered = this.getBlockingPlanBeingTriggered(parents, plansBeingTriggered);
                    return this.isTriggeringBlockedBecauseOfParent(planKey, buildLogger, aboutToBeTriggered);
                }
                String message = "Triggering for this build was blocked because its parent '" + parentInQueueOrBuilding.getName() + "' was already in the queue";
                buildLogger.addBuildLogEntry(message);
                log.info((Object)(planKey + " : " + message));
                return true;
            }
            return false;
        }
        catch (ConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private boolean isTriggeringBlockedBecauseOfParent(PlanKey planKey, BuildLogger buildLogger, @Nullable ImmutablePlan aboutToBeTriggered) {
        if (aboutToBeTriggered == null) {
            return false;
        }
        String message = "Triggering for this build was blocked because its parent '" + aboutToBeTriggered.getName() + "' is being triggered";
        buildLogger.addBuildLogEntry(message);
        log.info((Object)(planKey + " : " + message));
        return true;
    }

    private boolean buildAlreadyExists(PlanKey planKey) {
        return this.planExecutionManager.numberOfExecutions(planKey) > 0;
    }

    private void executeBuild(Pair<ImmutableChain, BuildChanges> buildChangesPair, PlanIdentifier childBuild) {
        if (this.buildAlreadyExists(((ImmutableChain)buildChangesPair.first).getPlanKey())) {
            log.info((Object)"Not starting new build as plan is being built");
            return;
        }
        ChildDependencyBuildDetectionAction action = new ChildDependencyBuildDetectionAction((ImmutablePlan)buildChangesPair.first, childBuild, this.buildNumberGenerator, this.triggerManager, (BuildChanges)buildChangesPair.second, this.errorUpdateHandler, this.immutablePlanCacheService, this.buildContextBuilderFactory);
        this.planExecutionManager.start((ImmutableChain)buildChangesPair.first, (BuildDetectionAction)action, AcquisitionPolicy.IMMEDIATE);
    }

    @Nullable
    private ImmutableChain getFirstQueuedOrBuildingParent(List<ImmutableChain> parents) {
        for (ImmutableChain plan : parents) {
            PlanKey planKey = plan.getPlanKey();
            if (!this.chainExecutionManager.isActive(planKey)) continue;
            return plan;
        }
        return null;
    }

    @Nullable
    private ImmutablePlan getBlockingPlanBeingTriggered(List<ImmutableChain> parentChains, Set<? extends ImmutablePlan> plansBeingTriggered) {
        if (CollectionUtils.isEmpty(plansBeingTriggered)) {
            return null;
        }
        List keysOfPlansBeingTriggered = plansBeingTriggered.stream().map(PlanIdentifier::getPlanKey).collect(Collectors.toList());
        return parentChains.stream().filter(p -> !p.isSuspendedFromBuilding()).filter(p -> keysOfPlansBeingTriggered.contains(p.getPlanKey())).findFirst().orElse(null);
    }

    @Nullable
    private Pair<ImmutableChain, BuildChanges> getFirstParentWithChanges(PlanIdentifier child, List<ImmutableChain> parentChains) {
        for (ImmutableChain parentChain : Iterables.filter(parentChains, chain -> !chain.isSuspendedFromBuilding())) {
            try {
                HashSet triggeringRepositories = new HashSet();
                for (TriggerDefinition triggerDefinition : parentChain.getTriggerDefinitions()) {
                    triggeringRepositories.addAll(triggerDefinition.getTriggeringRepositories());
                }
                BuildChanges buildChanges = this.changeDetectionManager.collectChangesSinceLastBuildIfTriggered(parentChain, null, triggeringRepositories);
                if (buildChanges.getChanges().isEmpty()) continue;
                return Pair.make((Object)parentChain, (Object)buildChanges);
            }
            catch (RepositoryException e) {
                log.warn((Object)("Failed to detect changes for '" + parentChain.getName() + "' when finding parent changes for '" + child.getName() + "'. Parent will be ignored."), (Throwable)e);
            }
        }
        return null;
    }

    private boolean isStrategyDontBuildIfParentInQueue(ImmutablePlan build) {
        return DependencyBlockingStrategy.DontBuildIfParentInQueue.equals((Object)DependencyBlockingStrategy.getStrategy((ImmutablePlan)build));
    }

    private boolean isStrategyToBuildParentIfHasChanges(ImmutablePlan build) {
        return DependencyBlockingStrategy.BuildParentIfChangesDetected.equals((Object)DependencyBlockingStrategy.getStrategy((ImmutablePlan)build));
    }
}

