/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.trigger;

import com.atlassian.bamboo.core.BambooCustomDataAware;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.v2.build.trigger.AbstractTriggerReason;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScheduledTriggerReason
extends AbstractTriggerReason {
    private static final Logger log = Logger.getLogger(ScheduledTriggerReason.class);
    public static final String KEY = "com.atlassian.bamboo.plugin.system.triggerReason:ScheduledTriggerReason";
    public static final String TRIGGER_SCHEDULED_DATE = "ScheduledTriggerReason.scheduledDate";
    public static final String DATE_FORMAT_STRING = "yyyy-MM-dd HH:mm:ss Z";
    public static final FastDateFormat DATE_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss Z");
    private Date scheduledDate;
    @Nullable
    private PlanResultKey planResultKey;
    @Nullable
    private String userScheduledBy;

    public void init(String key, Map<String, String> fields) {
        this.init(key);
        this.userScheduledBy = fields.get("trigger.created.by.user");
        String dateString = fields.get(TRIGGER_SCHEDULED_DATE);
        if (dateString != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT_STRING);
            try {
                this.scheduledDate = dateFormat.parse(dateString);
            }
            catch (ParseException e) {
                log.warn((Object)("Unable to parse date string " + dateString + ". No scheduledDate will be set for ScheduledTriggerReason"));
            }
        }
    }

    public void init(String key, @NotNull ResultsSummary resultsSummary) {
        this.planResultKey = resultsSummary.getPlanResultKey();
        this.init(key, resultsSummary.getCustomBuildData());
    }

    public void updateCustomData(@NotNull BambooCustomDataAware customDataAware) {
        if (this.scheduledDate != null) {
            customDataAware.updateCustomDataEntry(TRIGGER_SCHEDULED_DATE, DATE_FORMAT.format(this.scheduledDate));
        }
        if (this.userScheduledBy != null) {
            customDataAware.updateCustomDataEntry("trigger.created.by.user", this.userScheduledBy);
        }
    }

    public String getName() {
        return "Scheduled build";
    }

    public String getNameForSentence() {
        if (this.scheduledDate != null) {
            return this.textProvider.getText("build.triggerreason.scheduled.specific", new String[]{DateFormat.getTimeInstance(3).format(this.scheduledDate)});
        }
        return this.textProvider.getText("build.triggerreason.scheduled");
    }

    public Date getScheduledDate() {
        return this.scheduledDate;
    }

    @Nullable
    public PlanResultKey getPlanResultKey() {
        return this.planResultKey;
    }

    @Nullable
    public String getUserScheduledBy() {
        return this.userScheduledBy;
    }
}

