/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.events;

import com.amazonaws.services.ec2.model.GroupIdentifier;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.Tag;
import com.atlassian.aws.AWSAccount;
import com.atlassian.aws.AWSException;
import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.atlassian.bamboo.agent.elastic.ElasticResourceNamingHelper;
import com.atlassian.bamboo.agent.elastic.aws.AwsAccountBean;
import com.atlassian.bamboo.agent.elastic.server.ElasticFunctionalityFacade;
import com.atlassian.bamboo.agent.elastic.server.ElasticInstanceManager;
import com.atlassian.bamboo.buildqueue.ElasticAgentDefinition;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.event.ServerStartedEvent;
import com.atlassian.bamboo.utils.BambooCollections;
import com.atlassian.bamboo.utils.BambooCollectors;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.event.api.EventListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class HandleElasticInstancesFromPreviousSession {
    private static final Logger log = Logger.getLogger(HandleElasticInstancesFromPreviousSession.class);
    @Inject
    private AwsAccountBean awsAccountBean;
    @Inject
    private ElasticInstanceManager elasticInstanceManager;
    @Inject
    private AdministrationConfigurationAccessor administrationConfigurationAccessor;
    @Inject
    private AgentManager agentManager;
    @Inject
    private ElasticFunctionalityFacade elasticFunctionalityFacade;

    @EventListener
    public void onServerStarted(ServerStartedEvent event) {
        boolean isElasticConfigEnabled;
        boolean tunnelNotUsed = !SystemProperty.EC2_HTTP_TUNNEL_ENABLED.getTypedValue() && !SystemProperty.EC2_JMS_TUNNEL_ENABLED.getTypedValue();
        boolean seamlessRestarts = !SystemProperty.BAMBOO_IGNORE_SERVER_STATE_ON_RESTART.getTypedValue();
        boolean restoreInstances = tunnelNotUsed && seamlessRestarts;
        AdministrationConfiguration administrationConfiguration = this.administrationConfigurationAccessor.getAdministrationConfiguration();
        boolean bl = isElasticConfigEnabled = administrationConfiguration.getElasticConfig() != null && administrationConfiguration.getElasticConfig().isEnabled();
        if (!isElasticConfigEnabled) {
            return;
        }
        AWSAccount awsAccount = this.awsAccountBean.getAwsAccount();
        this.terminateAllInstances(awsAccount, restoreInstances);
    }

    private void terminateAllInstances(@NotNull AWSAccount awsAccount, boolean restoreInstances) {
        Collection instances = awsAccount.describeInstances(new String[0]);
        List instanceIds = BambooCollections.map((Collection)instances, Instance::getInstanceId);
        List runningElasticAgentsFromThisServer = this.agentManager.getAllElasticAgentDefinitions((Collection)instanceIds);
        Set<String> restoredInstancesIds = Collections.emptySet();
        if (restoreInstances) {
            restoredInstancesIds = this.reRegisterInstancesStartedByUs(awsAccount, runningElasticAgentsFromThisServer, instances);
        } else {
            this.cleanUpInstancesStartedByUs(awsAccount, runningElasticAgentsFromThisServer);
        }
        if (this.elasticInstanceManager.cancelSpotRequests(awsAccount)) {
            try {
                TimeUnit.SECONDS.sleep(15L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.cleanUpInstancesPotentiallyStartedByUs(awsAccount, awsAccount.describeInstances(new String[0]), restoredInstancesIds);
    }

    private Set<String> reRegisterInstancesStartedByUs(AWSAccount awsAccount, List<ElasticAgentDefinition> runningElasticAgentsFromThisServer, Collection<Instance> instances) {
        HashSet<String> restoredInstancesIds = new HashSet<String>();
        Map activeInstances = (Map)instances.stream().filter(instance -> AwsSupportConstants.InstanceStateName.Running.is(instance.getState())).collect(BambooCollectors.toMap(Instance::getInstanceId));
        for (ElasticAgentDefinition elasticAgentDefinition : runningElasticAgentsFromThisServer) {
            String instanceId = elasticAgentDefinition.getElasticInstanceId();
            if (activeInstances.containsKey(instanceId)) {
                log.info((Object)("Restoring instance started by this server: " + instanceId));
                try {
                    this.elasticFunctionalityFacade.restoreAgent(elasticAgentDefinition, (Instance)activeInstances.get(instanceId), awsAccount);
                    restoredInstancesIds.add(instanceId);
                }
                catch (Exception e) {
                    log.info((Object)("Exception while restoring instance " + instanceId + " Terminating."), (Throwable)e);
                    this.terminateQuietly(awsAccount, instanceId);
                }
                continue;
            }
            log.info((Object)("Stopping instance started by this server: " + instanceId));
            this.terminateQuietly(awsAccount, instanceId);
        }
        return restoredInstancesIds;
    }

    private void cleanUpInstancesStartedByUs(AWSAccount awsAccount, List<ElasticAgentDefinition> runningElasticAgentsFromThisServer) {
        for (ElasticAgentDefinition elasticAgentDefinition : runningElasticAgentsFromThisServer) {
            String instanceId = elasticAgentDefinition.getElasticInstanceId();
            log.info((Object)("Stopping instance started by this server: " + instanceId));
            this.terminateQuietly(awsAccount, instanceId);
        }
    }

    private void cleanUpInstancesPotentiallyStartedByUs(AWSAccount awsAccount, Collection<Instance> instances, Set<String> restoredInstancesIds) {
        String ourInstanceTag = ElasticResourceNamingHelper.getInstanceTag();
        for (Instance instance : instances) {
            if (restoredInstancesIds.contains(instance.getInstanceId())) {
                log.info((Object)("Leaving instance " + instance.getInstanceId() + " as seamless restarts are on and this is one of agents' instances "));
                continue;
            }
            boolean isTaggedByUs = false;
            boolean hasNameTag = false;
            for (Tag tag : instance.getTags()) {
                hasNameTag = "Name".equals(tag.getKey());
                if (!hasNameTag) continue;
                isTaggedByUs = tag.getValue().equals(ourInstanceTag);
                break;
            }
            if (hasNameTag && !isTaggedByUs) {
                log.info((Object)("Leaving instance " + instance.getInstanceId() + " (" + instance.getTags() + ") running: true false"));
                continue;
            }
            for (GroupIdentifier groupIdentifier : instance.getSecurityGroups()) {
                if (!this.isControlTag(groupIdentifier)) continue;
                String instanceId = instance.getInstanceId();
                log.info((Object)("Instance " + instanceId + " (" + instance.getTags() + ") was started in a different Bamboo session, shutting down"));
                this.terminateQuietly(awsAccount, instanceId);
            }
        }
    }

    private void terminateQuietly(AWSAccount awsAccount, String instanceId) {
        try {
            awsAccount.shutdownInstance(instanceId);
        }
        catch (AWSException e) {
            log.warn((Object)"", (Throwable)e);
        }
    }

    private boolean isControlTag(GroupIdentifier groupIdentifier) {
        return groupIdentifier.getGroupName().equals(this.elasticInstanceManager.getBambooControlTag());
    }
}

