/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.trigger;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.BuildDetectionResult;
import com.atlassian.bamboo.build.BuildDetectionResultImpl;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.BuildNumberGeneratorService;
import com.atlassian.bamboo.build.CommandLogEntry;
import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.UnconditionalBuildDetectionAction;
import com.atlassian.bamboo.build.context.BuildContextBuilderFactory;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.logger.ErrorUpdateHandler;
import com.atlassian.bamboo.plan.PlanClassHelper;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.trigger.TriggerManager;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionData;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionDataSet;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionHistoryService;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.utils.BambooPredicates;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.v2.build.BuildChanges;
import com.atlassian.bamboo.v2.build.BuildChangesImpl;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.BuildRepositoryChanges;
import com.atlassian.bamboo.v2.build.CustomBuildDataHelper;
import com.atlassian.bamboo.v2.build.trigger.TriggerReason;
import com.atlassian.bamboo.v2.trigger.ChangeDetectionManager;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutor;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.vcs.runtime.ContextualVcsId;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractDependentDetectionAction
implements UnconditionalBuildDetectionAction {
    private static final Logger log = Logger.getLogger(AbstractDependentDetectionAction.class);
    protected final PlanKey planKey;
    protected final ImmutableChain chain;
    protected final ImmutableChain parentChain;
    protected final BuildContext completedBuildContext;
    protected final BuildLoggerManager buildLoggerManager;
    protected final String completedBuildResultKey;
    protected final ErrorUpdateHandler errorUpdateHandler;
    protected final TriggerManager triggerManager;
    protected final ChangeDetectionManager changeDetectionManager;
    protected final BuildNumberGeneratorService buildNumberGeneratorService;
    protected final PlanVcsRevisionHistoryService planVcsRevisionHistoryService;
    protected final BuildContextBuilderFactory buildContextBuilderFactory;
    protected final CustomVariableContext customVariableContext;
    protected final VcsRepositoryManager vcsRepositoryManager;
    protected BuildChanges buildChanges;
    public static final String PARENT_BUILD_KEY = "dependency.parent";

    public AbstractDependentDetectionAction(ImmutableChain chain, ImmutableChain parentChain, BuildContext completedBuildContext, ErrorUpdateHandler errorUpdateHandler, TriggerManager triggerManager, ChangeDetectionManager changeDetectionManager, BuildNumberGeneratorService buildNumberGeneratorService, BuildLoggerManager buildLoggerManager, PlanVcsRevisionHistoryService planVcsRevisionHistoryService, BuildContextBuilderFactory buildContextBuilderFactory, CustomVariableContext customVariableContext, VcsRepositoryManager vcsRepositoryManager) {
        this.chain = chain;
        this.parentChain = parentChain;
        this.buildNumberGeneratorService = buildNumberGeneratorService;
        this.completedBuildContext = completedBuildContext;
        this.buildLoggerManager = buildLoggerManager;
        this.completedBuildResultKey = completedBuildContext != null ? completedBuildContext.getBuildResultKey() : chain.getKey();
        this.planKey = chain.getPlanKey();
        this.errorUpdateHandler = errorUpdateHandler;
        this.triggerManager = triggerManager;
        this.changeDetectionManager = changeDetectionManager;
        this.planVcsRevisionHistoryService = planVcsRevisionHistoryService;
        this.buildContextBuilderFactory = buildContextBuilderFactory;
        this.customVariableContext = customVariableContext;
        this.vcsRepositoryManager = vcsRepositoryManager;
    }

    @NotNull
    public BuildDetectionResult generateResultWithoutChanges() {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        BuildContext buildContext = this.prepareBuildContext((ErrorCollection)errorCollection);
        if (buildContext != null) {
            PlanResultKey buildResultKey = buildContext.getPlanResultKey();
            BuildLogger parentPlanLogger = this.parentChain.getBuildLogger();
            BuildLogger planLogger = this.chain.getBuildLogger();
            BuildLogger buildLogger = this.buildLoggerManager.getLogger((ResultKey)buildResultKey);
            log.info((Object)parentPlanLogger.addBuildLogEntry("Build " + this.completedBuildResultKey + " triggering dependant build " + buildResultKey));
            log.info((Object)planLogger.addBuildLogEntry("Build triggered by " + this.completedBuildResultKey));
            buildLogger.addBuildLogEntry("Build " + buildResultKey + " triggered by parent build " + this.completedBuildResultKey);
        }
        return new BuildDetectionResultImpl((ErrorCollection)new SimpleErrorCollection(), buildContext);
    }

    @Nullable
    public BuildChanges performDelayedChangeDetection(BuildContext buildContext) throws RepositoryException {
        BuildLogger buildLogger = this.chain.getBuildLogger();
        PlanVcsRevisionDataSet lastVcsRevisionKeys = this.planVcsRevisionHistoryService.getLastVcsRevisionKeys(this.chain.getPlanKey());
        return this.findBuildChanges(buildLogger, lastVcsRevisionKeys);
    }

    @Nullable
    protected BuildContext prepareBuildContext(@NotNull ErrorCollection errorCollection) {
        try {
            BuildDefinition buildDefinition = this.chain.getBuildDefinition();
            TriggerReason triggerReason = null;
            if (PlanClassHelper.isChain((ImmutablePlan)this.parentChain)) {
                triggerReason = this.triggerManager.getTriggerReason("com.atlassian.bamboo.plugin.system.triggerReason:DependencyTriggerReason", (Map)ImmutableMap.of((Object)"DependencyTriggerReason.triggeringBuildResultKey", (Object)this.completedBuildResultKey));
            }
            if (triggerReason == null) {
                throw new IllegalStateException("Could not get trigger reason for parent plan '" + this.parentChain.getKey() + "'");
            }
            BuildContext buildContext = this.buildContextBuilderFactory.createBuilder().plan((ImmutablePlan)this.chain).buildNumber(this.buildNumberGeneratorService.generateBuildNumber((PlanIdentifier)this.chain)).buildDefinition(buildDefinition).triggerReason(triggerReason).build();
            Map customBuildData = this.completedBuildContext != null ? this.completedBuildContext.getBuildResult().getCustomBuildData() : new HashMap();
            this.addDependencyInformation(buildContext.getBuildResult().getCustomBuildData(), customBuildData);
            return buildContext;
        }
        catch (Exception e) {
            String errorMsg = "Build triggered as dependency but could not collect changes from repository.";
            this.errorUpdateHandler.recordError((Key)this.planKey, "Build triggered as dependency but could not collect changes from repository.", (Throwable)e);
            errorCollection.addErrorMessage("Build triggered as dependency but could not collect changes from repository.");
            log.error((Object)"Build triggered as dependency but could not collect changes from repository.", (Throwable)e);
            return null;
        }
    }

    private BuildChanges findBuildChanges(BuildLogger buildLogger, PlanVcsRevisionDataSet lastVcsRevisionKeys) throws RepositoryException {
        BuildChangesImpl buildChanges = new BuildChangesImpl();
        log.info((Object)buildLogger.addBuildLogEntry("Dependent build being triggered by " + this.completedBuildResultKey));
        HashMap<Long, PlanVcsRevisionData> lastRevisionsOfParentBuild = new HashMap<Long, PlanVcsRevisionData>();
        VariableSubstitutor chainVariableSubstitutor = this.customVariableContext.getVariableSubstitutorFactory().newSubstitutorForPlan((ImmutablePlan)this.chain);
        for (PlanRepositoryDefinition repositoryDefinition : PlanHelper.getPlanRepositoryDefinitions((ImmutablePlan)this.chain)) {
            PlanRepositoryDefinition parentRepositoryDefinition = this.getMatchingRepositoryFromPlan((ImmutablePlan)this.parentChain, chainVariableSubstitutor, (VcsRepositoryData)repositoryDefinition);
            PlanVcsRevisionData lastRevisionOfParentBuild = this.getLastRevisionFromParentBuild(parentRepositoryDefinition);
            if (parentRepositoryDefinition == null || lastRevisionOfParentBuild == null) continue;
            lastRevisionsOfParentBuild.put(repositoryDefinition.getId(), lastRevisionOfParentBuild);
        }
        for (PlanRepositoryDefinition repositoryDefinition : PlanHelper.getPlanRepositoryDefinitions((ImmutablePlan)this.chain)) {
            BuildRepositoryChanges repositoryChanges;
            PlanVcsRevisionData lastVcsRevisionData = lastVcsRevisionKeys.get(repositoryDefinition.getId());
            if (lastRevisionsOfParentBuild.containsKey(repositoryDefinition.getId())) {
                PlanVcsRevisionData lastRevisionOfParentBuild = (PlanVcsRevisionData)lastRevisionsOfParentBuild.get(repositoryDefinition.getId());
                log.info((Object)buildLogger.addBuildLogEntry((LogEntry)new CommandLogEntry("Detected that parent plan '" + this.parentChain.getName() + "' using the same source. Updating to " + lastRevisionOfParentBuild.getVcsRevisionKey())));
                repositoryChanges = this.changeDetectionManager.collectChangesBetween(this.chain, repositoryDefinition, lastVcsRevisionData, lastRevisionOfParentBuild);
            } else {
                repositoryChanges = this.changeDetectionManager.collectChangesSinceLastBuild(this.chain, repositoryDefinition, lastVcsRevisionData, null, null);
            }
            buildChanges.addRepositoryChanges(repositoryChanges);
        }
        this.changeDetectionManager.updateIntegrationRepositoryDetails(this.chain, (BuildChanges)buildChanges);
        return buildChanges;
    }

    @Nullable
    private PlanRepositoryDefinition getMatchingRepositoryFromPlan(ImmutablePlan parentPlan, VariableSubstitutor substitutorForCurrentPlan, VcsRepositoryData repositoryToMatch) {
        VcsRepositoryModuleDescriptor vcsRepositoryModuleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(repositoryToMatch.getPluginKey());
        Preconditions.checkState((vcsRepositoryModuleDescriptor != null ? 1 : 0) != 0, (Object)("Unknown or disabled vcs plugin " + repositoryToMatch.getPluginKey()));
        List<PlanRepositoryDefinition> parentPlanRepositoryDefinitions = PlanHelper.getPlanRepositoryDefinitions(parentPlan);
        ContextualVcsId toMatch = (ContextualVcsId)this.customVariableContext.withVariableSubstitutor(substitutorForCurrentPlan, () -> vcsRepositoryModuleDescriptor.getChangeDetector().getVcsIdForExecutor(repositoryToMatch));
        if (toMatch != null) {
            VariableSubstitutor substitutorForParentPlan = this.customVariableContext.getVariableSubstitutorFactory().newSubstitutorForPlan(parentPlan);
            return (PlanRepositoryDefinition)this.customVariableContext.withVariableSubstitutor(substitutorForCurrentPlan, () -> {
                for (PlanRepositoryDefinition repositoryDefinition : parentPlanRepositoryDefinitions) {
                    ContextualVcsId candidate;
                    if (!repositoryDefinition.getPluginKey().equals(repositoryToMatch.getPluginKey()) || !toMatch.equals((Object)(candidate = vcsRepositoryModuleDescriptor.getChangeDetector().getVcsIdForExecutor((VcsRepositoryData)repositoryDefinition)))) continue;
                    return repositoryDefinition;
                }
                return null;
            });
        }
        if (repositoryToMatch.isLegacyRepository()) {
            return (PlanRepositoryDefinition)this.customVariableContext.withVariableSubstitutor(substitutorForCurrentPlan, () -> {
                Repository legacyRepositoryToMatch = repositoryToMatch.asLegacyData().getRepository();
                for (PlanRepositoryDefinition repositoryDefinition : parentPlanRepositoryDefinitions) {
                    if (!repositoryDefinition.getPluginKey().equals(repositoryToMatch.getPluginKey()) || repositoryDefinition.asLegacyData().getRepository().isRepositoryDifferent(legacyRepositoryToMatch)) continue;
                    return repositoryDefinition;
                }
                return null;
            });
        }
        return parentPlanRepositoryDefinitions.stream().filter(r -> BambooPredicates.hasBambooObjectEqualId((BambooIdProvider)repositoryToMatch).apply(r)).findAny().orElse(null);
    }

    @Nullable
    private PlanVcsRevisionData getLastRevisionFromParentBuild(@Nullable PlanRepositoryDefinition parentRepositoryDefinition) {
        if (parentRepositoryDefinition == null) {
            return null;
        }
        return this.completedBuildContext != null ? this.completedBuildContext.getBuildChanges().getVcsRevisionData(parentRepositoryDefinition.getId()) : null;
    }

    protected void addDependencyInformation(Map<String, String> customBuildData, Map<String, String> oldCustomData) {
        Map<String, String> dependencyParents = CustomBuildDataHelper.getSubset(PARENT_BUILD_KEY, oldCustomData);
        customBuildData.putAll(dependencyParents);
        CustomBuildDataHelper.appendListValue(PARENT_BUILD_KEY, this.completedBuildResultKey, customBuildData);
    }
}

