/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.trigger;

import com.atlassian.bamboo.build.BuildDetectionAction;
import com.atlassian.bamboo.plan.NonBlockingPlanExecutionService;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlanCacheService;
import com.atlassian.bamboo.trigger.Triggerable;
import com.atlassian.bamboo.util.CacheAwareness;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.v2.events.ChangeDetectionRequiredEvent;
import com.atlassian.bamboo.v2.trigger.ChangeDetectionListenerAction;
import com.atlassian.event.api.EventListener;
import com.atlassian.spring.container.ContainerManager;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ChangeDetectionListener {
    private static final Logger log = Logger.getLogger(ChangeDetectionListener.class);
    private ImmutablePlanCacheService immutablePlanCacheService;
    private NonBlockingPlanExecutionService nonBlockingPlanExecutionService;

    @EventListener
    public void handleEvent(ChangeDetectionRequiredEvent event) {
        if (SystemProperty.BUILDING_DISABLED.getValue(false)) {
            log.debug((Object)"No change detection occurred since the -Datlassian.bamboo.build.disable=true has been set");
            return;
        }
        PlanKey planKey = event.getPlanKey();
        ImmutableChain chain = this.immutablePlanCacheService.getImmutablePlanByKey(planKey);
        if (chain == null) {
            log.info((Object)String.format("Chain with key %s not found while handling change detection event, Trigger: [id: %d, plugin: %s]", planKey.getKey(), event.getTriggerId(), event.getTrigger().getPluginKey()));
            return;
        }
        BuildDetectionAction detectionListenerAction = this.getChangeDetectionAction(planKey, event.getTriggeringRepositories(), event.getTriggerConditionsConfiguration(), event.isLogIfNoChanges());
        CacheAwareness.withValuesOlderThanTimestampReloaded(() -> this.nonBlockingPlanExecutionService.enqueueTrigger((Triggerable)chain, Long.valueOf(event.getTriggerId()), detectionListenerAction), event.getFireTime(), event.getCachesToIgnore());
    }

    protected BuildDetectionAction getChangeDetectionAction(PlanKey planKey, Set<Long> triggeringRepositories, Map<String, String> triggerConditionsConfiguration) {
        ChangeDetectionListenerAction detectionListenerAction = new ChangeDetectionListenerAction(planKey, triggeringRepositories, triggerConditionsConfiguration);
        ContainerManager.autowireComponent((Object)detectionListenerAction);
        return detectionListenerAction;
    }

    protected BuildDetectionAction getChangeDetectionAction(PlanKey planKey, Set<Long> triggeringRepositories, Map<String, String> triggerConditionsConfiguration, boolean logIfNoChanges) {
        ChangeDetectionListenerAction detectionListenerAction = new ChangeDetectionListenerAction(planKey, triggeringRepositories, triggerConditionsConfiguration, logIfNoChanges);
        ContainerManager.autowireComponent((Object)detectionListenerAction);
        return detectionListenerAction;
    }

    public void setImmutablePlanCacheService(ImmutablePlanCacheService immutablePlanCacheService) {
        this.immutablePlanCacheService = immutablePlanCacheService;
    }

    public void setNonBlockingPlanExecutionService(NonBlockingPlanExecutionService nonBlockingPlanExecutionService) {
        this.nonBlockingPlanExecutionService = nonBlockingPlanExecutionService;
    }
}

