/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.trigger;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.BuildDetectionResult;
import com.atlassian.bamboo.build.BuildDetectionResultImpl;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.BuildNumberGeneratorService;
import com.atlassian.bamboo.build.ConditionalBuildDetectionAction;
import com.atlassian.bamboo.build.context.BuildContextBuilderFactory;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.test.TriggerConditionsAwareBuildDetectionAction;
import com.atlassian.bamboo.event.TrustedKeyVerificationFailedEvent;
import com.atlassian.bamboo.logger.ErrorHandler;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.cache.ImmutablePlanCacheService;
import com.atlassian.bamboo.plan.trigger.TriggerManager;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionData;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionDataSet;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionHistoryService;
import com.atlassian.bamboo.repository.HostKeyVerificationException;
import com.atlassian.bamboo.repository.InvalidRepositoryException;
import com.atlassian.bamboo.repository.RepositoryBranchDeletedException;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.security.TrustedKey;
import com.atlassian.bamboo.utils.BambooPredicates;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.v2.build.BuildChanges;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.trigger.DependencyBlockingManager;
import com.atlassian.bamboo.v2.build.trigger.TriggerReason;
import com.atlassian.bamboo.v2.trigger.ChangeDetectionManager;
import com.atlassian.event.api.EventPublisher;
import com.google.common.collect.Lists;
import com.opensymphony.xwork2.TextProvider;
import io.atlassian.fugue.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jetbrains.annotations.NotNull;

public class ChangeDetectionListenerAction
implements TriggerConditionsAwareBuildDetectionAction,
ConditionalBuildDetectionAction {
    private static final Logger log = Logger.getLogger(ChangeDetectionListenerAction.class);
    private final PlanKey planKey;
    private TriggerManager triggerManager;
    private ErrorHandler errorHandler;
    private ChangeDetectionManager changeDetectionManager;
    private DependencyBlockingManager dependencyBlockingManager;
    private BuildLoggerManager buildLoggerManager;
    private TextProvider textProvider;
    private BuildNumberGeneratorService buildNumberGenerator;
    private PlanVcsRevisionHistoryService planVcsRevisionHistoryService;
    private ImmutablePlanCacheService immutablePlanCacheService;
    private EventPublisher eventPublisher;
    private BuildContextBuilderFactory buildContextBuilderFactory;
    private boolean logIfNoChanges;
    private Set<Long> triggeringRepositories;
    private Map<String, String> triggerConditionsConfiguration;
    private BuildChanges buildChanges;

    public ChangeDetectionListenerAction(@NotNull PlanKey planKey, @NotNull Set<Long> triggeringRepositories, @NotNull Map<String, String> triggerConditionsConfiguration) {
        this.planKey = planKey;
        this.triggeringRepositories = triggeringRepositories;
        this.triggerConditionsConfiguration = triggerConditionsConfiguration;
    }

    public ChangeDetectionListenerAction(PlanKey planKey, @NotNull Set<Long> triggeringRepositories, @NotNull Map<String, String> triggerConditionsConfiguration, boolean logIfNoChanges) {
        this(planKey, triggeringRepositories, triggerConditionsConfiguration);
        this.logIfNoChanges = logIfNoChanges;
    }

    public Pair<Boolean, ErrorCollection> testIfBuildShouldStart() {
        boolean shouldStartBuild;
        SimpleErrorCollection errorCollection;
        block12: {
            errorCollection = new SimpleErrorCollection();
            shouldStartBuild = false;
            ImmutableChain chain = this.immutablePlanCacheService.getImmutablePlanByKey(this.planKey);
            if (chain == null) {
                String message = this.textProvider.getText("change.detection.error.chainNotFound", Collections.singletonList(this.planKey));
                errorCollection.addErrorMessage(message);
                this.errorHandler.recordError((Key)this.planKey, message);
            } else if (!chain.isSuspended() && !chain.isMarkedForDeletion()) {
                try {
                    BuildLogger planLogger = chain.getBuildLogger();
                    this.buildChanges = this.changeDetectionManager.collectChangesSinceLastBuildIfTriggered(chain, null, this.triggeringRepositories);
                    List changes = this.buildChanges.getChanges();
                    if (CollectionUtils.isNotEmpty((Collection)changes)) {
                        String changeFoundMessage = this.textProvider.getText("change.detection.changes", (List)Lists.newArrayList((Object[])new Integer[]{changes.size()}));
                        log.info((Object)(planLogger.addBuildLogEntry(changeFoundMessage) + " for plan " + chain.getPlanKey()));
                        if (this.dependencyBlockingManager.isBlockedFromBuilding(chain.getPlanKey())) {
                            log.info((Object)"Build is blocked from building.");
                        } else {
                            log.debug((Object)"Going ahead with build, no reason to block it...");
                            shouldStartBuild = true;
                        }
                    } else {
                        log.log((Priority)(this.logIfNoChanges ? Level.INFO : Level.DEBUG), (Object)("No changes found for '" + chain.getPlanKey() + "'"));
                        PlanVcsRevisionDataSet lastVcsRevisionKeyMap = this.planVcsRevisionHistoryService.getLastVcsRevisionKeys(chain.getPlanKey());
                        chain.getPlanRepositoryDefinitions().stream().filter(BambooPredicates.isChainTrigger(chain, this.triggeringRepositories)).forEach(repositoryDefinition -> {
                            PlanVcsRevisionData lastVcsRevisionData;
                            PlanVcsRevisionData vcsRevisionData = this.buildChanges.getVcsRevisionData(repositoryDefinition.getId());
                            if (!vcsRevisionData.equals((Object)(lastVcsRevisionData = lastVcsRevisionKeyMap.get(repositoryDefinition.getId())))) {
                                log.debug((Object)("Updating vcsKey for '" + chain.getPlanKey() + "' to '" + vcsRevisionData.getVcsRevisionKey() + "'"));
                                ImmutableChain freshInstanceOfChain = this.immutablePlanCacheService.getImmutablePlanByKey(this.planKey);
                                if (freshInstanceOfChain != null && !freshInstanceOfChain.isMarkedForDeletion() && freshInstanceOfChain.getLastBuildNumber() == chain.getLastBuildNumber()) {
                                    this.planVcsRevisionHistoryService.markChangeDetectionCompleted(freshInstanceOfChain.getPlanKey(), freshInstanceOfChain.getLastBuildNumber(), vcsRevisionData, repositoryDefinition.getId());
                                }
                            }
                        });
                    }
                }
                catch (HostKeyVerificationException e) {
                    this.handleHostKeyVerificationException((ErrorCollection)errorCollection, chain, e);
                }
                catch (RepositoryBranchDeletedException e) {
                    return Pair.pair((Object)false, (Object)((Object)errorCollection));
                }
                catch (RepositoryException e) {
                    if (e.getCause() instanceof HostKeyVerificationException) {
                        this.handleHostKeyVerificationException((ErrorCollection)errorCollection, chain, (HostKeyVerificationException)e.getCause());
                    }
                    if (InvalidRepositoryException.handleInvalidRepositoryIfAppropriate(this.planKey, e, (ErrorCollection)errorCollection, this.eventPublisher, this.errorHandler)) break block12;
                    errorCollection.addErrorMessage("Unable to detect changes.", (Exception)((Object)e));
                    this.errorHandler.recordError((Key)chain.getPlanKey(), "Unable to detect changes", (Throwable)e);
                }
            }
        }
        return Pair.pair((Object)shouldStartBuild, (Object)((Object)errorCollection));
    }

    private void handleHostKeyVerificationException(ErrorCollection errorCollection, ImmutableChain chain, HostKeyVerificationException e) {
        if (!InvalidRepositoryException.handleInvalidRepositoryIfAppropriate(this.planKey, e, errorCollection, this.eventPublisher, this.errorHandler)) {
            errorCollection.addErrorMessage("Unable to detect changes.", (Exception)((Object)e));
            TrustedKey trustedKey = e.getTrustedKey();
            String errorMessage = "Unable to detect changes because host verification failed.";
            if (trustedKey == null) {
                this.errorHandler.recordError((Key)chain.getPlanKey(), "Unable to detect changes because host verification failed.", (Throwable)e);
            } else {
                HashMap<String, String> metadata = new HashMap<String, String>();
                metadata.put("host", trustedKey.getHost());
                metadata.put("key", trustedKey.getKey());
                this.errorHandler.recordError((Key)chain.getPlanKey(), "Unable to detect changes because host verification failed.", (Throwable)e, metadata);
            }
            this.eventPublisher.publish((Object)new TrustedKeyVerificationFailedEvent(this));
        }
    }

    public BuildDetectionResult createBuildContext() {
        BuildContext buildContext = null;
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        ImmutableChain chain = this.immutablePlanCacheService.getImmutablePlanByKey(this.planKey);
        if (chain == null || chain.isMarkedForDeletion()) {
            String message = this.textProvider.getText("change.detection.error.chainNotFound", Collections.singletonList(this.planKey));
            errorCollection.addErrorMessage(message);
            this.errorHandler.recordError((Key)this.planKey, message);
        } else {
            BuildLogger planLogger = chain.getBuildLogger();
            BuildDefinition buildDefinition = chain.getBuildDefinition();
            List changes = this.buildChanges.getChanges();
            String changeFoundMessage = this.textProvider.getText("change.detection.changes", (List)Lists.newArrayList((Object[])new Integer[]{changes.size()}));
            TriggerReason codeChangedReason = this.triggerManager.getTriggerReason("com.atlassian.bamboo.plugin.system.triggerReason:CodeChangedTriggerReason", Collections.emptyMap());
            buildContext = this.buildContextBuilderFactory.createBuilder().plan((ImmutablePlan)chain).triggerReason(codeChangedReason).buildNumber(this.buildNumberGenerator.generateBuildNumber((PlanIdentifier)chain)).buildChanges(this.buildChanges).buildDefinition(buildDefinition).build();
            PlanResultKey planResultKey = buildContext.getPlanResultKey();
            BuildLogger buildLogger = this.buildLoggerManager.getLogger((ResultKey)planResultKey);
            planLogger.addBuildLogEntry("Build " + planResultKey + " triggered by change detection");
            buildLogger.addBuildLogEntry(changeFoundMessage + ", starting build " + planResultKey);
        }
        return new BuildDetectionResultImpl((ErrorCollection)errorCollection, buildContext);
    }

    public Map<String, String> getTriggerConditionsConfiguration() {
        return this.triggerConditionsConfiguration;
    }

    public void setTriggerManager(TriggerManager triggerManager) {
        this.triggerManager = triggerManager;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setChangeDetectionManager(ChangeDetectionManager changeDetectionManager) {
        this.changeDetectionManager = changeDetectionManager;
    }

    public void setDependencyBlockingManager(DependencyBlockingManager dependencyBlockingManager) {
        this.dependencyBlockingManager = dependencyBlockingManager;
    }

    public void setBuildLoggerManager(BuildLoggerManager buildLoggerManager) {
        this.buildLoggerManager = buildLoggerManager;
    }

    public void setTextProvider(TextProvider textProvider) {
        this.textProvider = textProvider;
    }

    public void setBuildNumberGeneratorService(BuildNumberGeneratorService buildNumberGeneratorService) {
        this.buildNumberGenerator = buildNumberGeneratorService;
    }

    public void setPlanVcsRevisionHistoryService(PlanVcsRevisionHistoryService planVcsRevisionHistoryService) {
        this.planVcsRevisionHistoryService = planVcsRevisionHistoryService;
    }

    public void setImmutablePlanCacheService(ImmutablePlanCacheService immutablePlanCacheService) {
        this.immutablePlanCacheService = immutablePlanCacheService;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void setBuildContextBuilderFactory(BuildContextBuilderFactory buildContextBuilderFactory) {
        this.buildContextBuilderFactory = buildContextBuilderFactory;
    }

    public String toString() {
        return "change detection for " + this.planKey + " on repositories " + this.triggeringRepositories;
    }
}

