/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.trigger;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.BuildDetectionResult;
import com.atlassian.bamboo.build.BuildDetectionResultImpl;
import com.atlassian.bamboo.build.BuildNumberGeneratorService;
import com.atlassian.bamboo.build.UnconditionalBuildDetectionAction;
import com.atlassian.bamboo.build.context.BuildContextBuilderFactory;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.logger.ErrorUpdateHandler;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.cache.ImmutablePlanCacheService;
import com.atlassian.bamboo.plan.trigger.TriggerManager;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.v2.build.BuildChanges;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.trigger.TriggerReason;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChildDependencyBuildDetectionAction
implements UnconditionalBuildDetectionAction {
    private static final Logger log = Logger.getLogger(ChildDependencyBuildDetectionAction.class);
    private final ImmutablePlan plan;
    private final PlanIdentifier child;
    private final BuildNumberGeneratorService buildNumberGenerator;
    private final TriggerManager triggerManager;
    private final BuildChanges buildChanges;
    private final transient ErrorUpdateHandler errorUpdateHandler;
    private final BuildContextBuilderFactory buildContextBuilderFactory;

    public ChildDependencyBuildDetectionAction(ImmutablePlan plan, PlanIdentifier child, BuildNumberGeneratorService buildNumberGenerator, TriggerManager triggerManager, BuildChanges buildChanges, ErrorUpdateHandler errorUpdateHandler, ImmutablePlanCacheService immutablePlanCacheService, BuildContextBuilderFactory buildContextBuilderFactory) {
        this.plan = plan;
        this.child = child;
        this.buildNumberGenerator = buildNumberGenerator;
        this.triggerManager = triggerManager;
        this.buildChanges = buildChanges;
        this.errorUpdateHandler = errorUpdateHandler;
        this.buildContextBuilderFactory = buildContextBuilderFactory;
    }

    @NotNull
    public BuildDetectionResult generateResultWithoutChanges() {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        BuildContext buildContext = null;
        try {
            BuildLogger planLogger = this.plan.getBuildLogger();
            BuildDefinition buildDefinition = this.plan.getBuildDefinition();
            TriggerReason triggerReason = this.triggerManager.getTriggerReason("com.atlassian.bamboo.plugin.system.triggerReason:ChildDependencyTriggerReason", (Map)ImmutableMap.of((Object)"ChildDependencyTriggerReason.triggeringBuildResultKey", (Object)this.child.getPlanKey().getKey()));
            buildContext = this.buildContextBuilderFactory.createBuilder().plan(this.plan).buildNumber(this.buildNumberGenerator.generateBuildNumber((PlanIdentifier)this.plan)).triggerReason(triggerReason).buildDefinition(buildDefinition).build();
            log.info((Object)planLogger.addBuildLogEntry("Build triggered by child " + this.child.getPlanKey()));
        }
        catch (Exception e) {
            String message = "Error encountered while triggering build: " + e.getMessage();
            log.error((Object)this.plan.getBuildLogger().addBuildLogEntry(message), (Throwable)e);
            this.errorUpdateHandler.recordError((Key)this.plan.getPlanKey(), message, (Throwable)e);
        }
        return new BuildDetectionResultImpl((ErrorCollection)errorCollection, buildContext);
    }

    @Nullable
    public BuildChanges performDelayedChangeDetection(BuildContext buildContext) throws RepositoryException {
        return this.buildChanges;
    }
}

