/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.trigger;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.BuildDetectionResult;
import com.atlassian.bamboo.build.BuildDetectionResultImpl;
import com.atlassian.bamboo.build.DelayedChangeDetectionAction;
import com.atlassian.bamboo.build.UserInitiatedBuildDetectionAction;
import com.atlassian.bamboo.build.context.BuildContextBuilderFactory;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.logger.ErrorUpdateHandler;
import com.atlassian.bamboo.plan.PlanExecutionConfig;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.StageIdentifier;
import com.atlassian.bamboo.plan.branch.BranchIntegrationService;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.trigger.TriggerManager;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionData;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.resultsummary.variables.ResultsSummaryVariableAccessor;
import com.atlassian.bamboo.resultsummary.vcs.RepositoryChangeset;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.v2.build.BuildChanges;
import com.atlassian.bamboo.v2.build.BuildChangesImpl;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.BuildRepositoryChanges;
import com.atlassian.bamboo.v2.build.BuildRepositoryChangesImpl;
import com.atlassian.bamboo.v2.build.trigger.RerunBuildTriggerReason;
import com.atlassian.bamboo.v2.build.trigger.TriggerReason;
import com.atlassian.bamboo.variable.VariableContext;
import com.atlassian.bamboo.variable.VariableContextImpl;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.bamboo.variable.VariableDefinitionContextImpl;
import com.atlassian.bamboo.variable.VariableType;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.configurator.VcsBranchConfigurator;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.user.User;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ContinuedBuildDetectionAction
implements UserInitiatedBuildDetectionAction,
DelayedChangeDetectionAction {
    private static final Logger log = Logger.getLogger(ContinuedBuildDetectionAction.class);
    private final ImmutableChain chain;
    private final PlanExecutionConfig planExecutionConfig;
    private final User user;
    private TriggerReason triggerReason;
    private final Map<String, String> params;
    private final Map<String, String> variables;
    private final ErrorUpdateHandler errorUpdateHandler;
    private final ResultsSummaryManager resultsSummaryManager;
    private final TriggerManager triggerManager;
    private final BranchIntegrationService branchIntegrationService;
    private final BuildContextBuilderFactory buildContextBuilderFactory;
    private final ResultsSummaryVariableAccessor resultsSummaryVariableAccessor;
    private final VcsRepositoryManager vcsRepositoryManager;
    private BuildChanges buildChanges = new BuildChangesImpl();

    public ContinuedBuildDetectionAction(ImmutableChain chain, @NotNull PlanExecutionConfig planExecutionConfig, User user, TriggerReason triggerReason, Map<String, String> params, Map<String, String> variables, ErrorUpdateHandler errorUpdateHandler, ResultsSummaryManager resultsSummaryManager, TriggerManager triggerManager, BranchIntegrationService branchIntegrationService, BuildContextBuilderFactory buildContextBuilderFactory, ResultsSummaryVariableAccessor resultsSummaryVariableAccessor, VcsRepositoryManager vcsRepositoryManager) {
        this.chain = chain;
        this.planExecutionConfig = planExecutionConfig;
        this.user = user;
        this.triggerReason = triggerReason;
        this.params = params;
        this.variables = variables;
        this.errorUpdateHandler = errorUpdateHandler;
        this.resultsSummaryManager = resultsSummaryManager;
        this.triggerManager = triggerManager;
        this.branchIntegrationService = branchIntegrationService;
        this.buildContextBuilderFactory = buildContextBuilderFactory;
        this.resultsSummaryVariableAccessor = resultsSummaryVariableAccessor;
        this.vcsRepositoryManager = vcsRepositoryManager;
    }

    @NotNull
    public BuildChanges performDelayedChangeDetection(@NotNull BuildContext buildContext) {
        return this.buildChanges;
    }

    @NotNull
    public BuildDetectionResult generateResultWithoutChanges() {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        BuildContext buildContext = null;
        try {
            RerunBuildTriggerReason rerunBuildTriggerReason;
            ChainResultsSummary chainResultsSummary;
            BuildLogger planLogger = this.chain.getBuildLogger();
            BuildDefinition buildDefinition = this.chain.getBuildDefinition();
            PlanResultKey planResultKey = this.planExecutionConfig.getResultToRerun();
            ResultsSummary resultsSummary = this.resultsSummaryManager.getResultsSummary(planResultKey);
            ImmutableMap.Builder customBuildDataBuilder = ImmutableMap.builder();
            HashMap<String, String> customBuildData = new HashMap<String, String>();
            if (resultsSummary != null) {
                for (RepositoryChangeset repositoryChangeset : resultsSummary.getRepositoryChangesets()) {
                    BuildRepositoryChangesImpl buildRepositoryChanges = new BuildRepositoryChangesImpl(repositoryChangeset.getRepositoryData().getId());
                    buildRepositoryChanges.setVcsRevisionKey(repositoryChangeset.getChangesetId());
                    buildRepositoryChanges.setChanges(new LinkedList(repositoryChangeset.getCommits()));
                    this.buildChanges.addRepositoryChanges((BuildRepositoryChanges)buildRepositoryChanges);
                }
                customBuildData.putAll(resultsSummary.getCustomBuildData());
            }
            if ((chainResultsSummary = (ChainResultsSummary)Narrow.downTo((Object)resultsSummary, ChainResultsSummary.class)) != null && chainResultsSummary.getMergeResult() != null) {
                PlanRepositoryDefinition defaultRepositoryDefinition = PlanHelper.getDefaultPlanRepositoryDefinition((ImmutablePlan)this.chain);
                VcsRepositoryModuleDescriptor moduleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(defaultRepositoryDefinition.getPluginKey());
                VcsBranchConfigurator vcsBranchConfigurator = moduleDescriptor.getVcsBranchConfigurator();
                this.buildChanges.setIntegrationBranchRevisionData(new PlanVcsRevisionData(chainResultsSummary.getMergeResult().getIntegrationBranchVcsKey(), null, vcsBranchConfigurator.createVcsBranchFromName(chainResultsSummary.getMergeResult().getBranchName())));
                this.buildChanges.setIntegrationRepositoryId(chainResultsSummary.getMergeResult().getIntegrationRepositoryId());
                BuildRepositoryChangesImpl buildRepositoryChangesImpl = new BuildRepositoryChangesImpl(chainResultsSummary.getMergeResult().getIntegrationRepositoryId());
                buildRepositoryChangesImpl.setVcsRevisionKey(chainResultsSummary.getMergeResult().getIntegrationBranchVcsKey());
                this.buildChanges.addRepositoryChanges((BuildRepositoryChanges)buildRepositoryChangesImpl);
            }
            planLogger.addBuildLogEntry("Build " + planResultKey + " continued by " + this.user);
            if (this.triggerReason == null) {
                StageIdentifier startingStage = this.planExecutionConfig.getStartStage();
                String startingStageName = startingStage != null ? startingStage.getName() : "post chain actions";
                this.triggerReason = this.triggerManager.getTriggerReason("com.atlassian.bamboo.plugin.system.triggerReason:ManualBuildTriggerReason", (Map)ImmutableMap.of((Object)"ManualBuildTriggerReason.userName", (Object)this.user.getName(), (Object)"ManualBuildTriggerReason.stageName", (Object)startingStageName));
            }
            if ((rerunBuildTriggerReason = (RerunBuildTriggerReason)((Object)Narrow.downTo((Object)this.triggerReason, RerunBuildTriggerReason.class))) != null) {
                rerunBuildTriggerReason.setNumberOfRetries(resultsSummary.getRestartCount() + 1);
            }
            Map<String, VariableDefinitionContext> definitions = this.getVariableState(chainResultsSummary);
            for (Map.Entry entry : this.variables.entrySet()) {
                String variableKey = (String)entry.getKey();
                definitions.put(variableKey, new VariableDefinitionContextImpl(variableKey, (String)entry.getValue(), VariableType.MANUAL));
            }
            VariableContextImpl variableContext = new VariableContextImpl(definitions);
            if (this.params != null) {
                customBuildData.putAll(this.params);
            }
            customBuildDataBuilder.putAll(customBuildData);
            buildContext = this.buildContextBuilderFactory.createBuilder().plan((ImmutablePlan)this.chain).buildNumber(planResultKey.getBuildNumber()).triggerReason(this.triggerReason).buildDefinition(buildDefinition).variableContext((VariableContext)variableContext).customBuildData((Map)customBuildDataBuilder.build()).planRepositoryDefinitionMap(this.branchIntegrationService.getPlanRepositoryDefinitionMap((ImmutablePlan)this.chain)).isOnceOff(resultsSummary != null && resultsSummary.isOnceOff()).isCustomBuild(resultsSummary != null && resultsSummary.isCustomBuild()).build();
        }
        catch (Exception e) {
            String message = "Error encountered while triggering manual build: " + e.getMessage();
            errorCollection.addErrorMessage(message);
            log.error((Object)this.chain.getBuildLogger().addBuildLogEntry(message), (Throwable)e);
            this.errorUpdateHandler.recordError((Key)this.chain.getPlanKey(), message, (Throwable)e);
        }
        return new BuildDetectionResultImpl((ErrorCollection)errorCollection, buildContext);
    }

    @NotNull
    private Map<String, VariableDefinitionContext> getVariableState(ChainResultsSummary resultsSummary) {
        if (resultsSummary == null) {
            return new HashMap<String, VariableDefinitionContext>();
        }
        return this.planExecutionConfig.getPlanExecutionType() == PlanExecutionConfig.PlanExecutionType.RERUN ? this.resultsSummaryVariableAccessor.calculateInitialVariablesState(resultsSummary.getPlanResultKey()) : this.resultsSummaryVariableAccessor.calculateCurrentVariablesState(resultsSummary.getPlanResultKey());
    }

    public PlanExecutionConfig getPlanExecutionConfig() {
        return this.planExecutionConfig;
    }
}

