/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.trigger;

import com.atlassian.bamboo.FeatureManager;
import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.CommandLogEntry;
import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.chains.BuildContextFactory;
import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.commit.CommitContextImpl;
import com.atlassian.bamboo.commit.CommitFile;
import com.atlassian.bamboo.commit.CommitPredicates;
import com.atlassian.bamboo.executor.RetryingTaskExecutor;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.branch.BranchCommitInformation;
import com.atlassian.bamboo.plan.branch.BranchCommitInformationImpl;
import com.atlassian.bamboo.plan.branch.BranchCommitInformationManager;
import com.atlassian.bamboo.plan.branch.BranchIntegrationConfiguration;
import com.atlassian.bamboo.plan.branch.BranchIntegrationPoint;
import com.atlassian.bamboo.plan.branch.BranchIntegrationPointImpl;
import com.atlassian.bamboo.plan.branch.BranchIntegrationService;
import com.atlassian.bamboo.plan.branch.ChainBranchManager;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableChainBranch;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionData;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionDataSet;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionHistoryService;
import com.atlassian.bamboo.repository.RepositoryBranchDeletedException;
import com.atlassian.bamboo.repository.RepositoryCachingFacade;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.util.BambooCollectionUtils;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.BambooLogUtils;
import com.atlassian.bamboo.utils.BambooPredicates;
import com.atlassian.bamboo.utils.DurationUtils;
import com.atlassian.bamboo.v2.build.BuildChanges;
import com.atlassian.bamboo.v2.build.BuildChangesImpl;
import com.atlassian.bamboo.v2.build.BuildRepositoryChanges;
import com.atlassian.bamboo.v2.build.BuildRepositoryChangesImpl;
import com.atlassian.bamboo.v2.trigger.ChangeDetectionManager;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutor;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsChangeDetectionOptions;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.vcs.runtime.CommitsIsolatingVcsChangeDetector;
import com.atlassian.bamboo.vcs.runtime.VcsBranchDetector;
import com.atlassian.bamboo.vcs.runtime.VcsChangeDetector;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.opensymphony.xwork2.TextProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultChangeDetectionManager
implements ChangeDetectionManager {
    private static final Logger log = Logger.getLogger(DefaultChangeDetectionManager.class);
    private final BuildContextFactory buildContextFactory;
    private final BuildLoggerManager buildLoggerManager;
    private final TextProvider textProvider;
    private final VariableDefinitionManager variableDefinitionManager;
    private final CustomVariableContext customVariableContext;
    private final PlanVcsRevisionHistoryService planVcsRevisionHistoryService;
    private final BranchCommitInformationManager branchCommitInformationManager;
    private final BranchIntegrationService branchIntegrationService;
    private final ChainBranchManager chainBranchManager;
    private final RepositoryCachingFacade repositoryCachingFacade;
    private final VcsRepositoryManager vcsRepositoryManager;
    private final FeatureManager featureManager;
    private final Map<PlanKey, List<BuildRepositoryChanges>> isolatedCommits = Collections.synchronizedMap(new HashMap());

    public DefaultChangeDetectionManager(BuildContextFactory buildContextFactory, BuildLoggerManager buildLoggerManager, TextProvider textProvider, VariableDefinitionManager variableDefinitionManager, CustomVariableContext customVariableContext, PlanVcsRevisionHistoryService planVcsRevisionHistoryService, BranchCommitInformationManager branchCommitInformationManager, BranchIntegrationService branchIntegrationService, ChainBranchManager chainBranchManager, RepositoryCachingFacade repositoryCachingFacade, VcsRepositoryManager vcsRepositoryManager, FeatureManager featureManager) {
        this.buildContextFactory = buildContextFactory;
        this.buildLoggerManager = buildLoggerManager;
        this.textProvider = textProvider;
        this.variableDefinitionManager = variableDefinitionManager;
        this.customVariableContext = customVariableContext;
        this.planVcsRevisionHistoryService = planVcsRevisionHistoryService;
        this.branchCommitInformationManager = branchCommitInformationManager;
        this.branchIntegrationService = branchIntegrationService;
        this.chainBranchManager = chainBranchManager;
        this.repositoryCachingFacade = repositoryCachingFacade;
        this.vcsRepositoryManager = vcsRepositoryManager;
        this.featureManager = featureManager;
    }

    @NotNull
    public BuildChanges collectChangesSinceLastBuildIfTriggered(@NotNull ImmutableChain chain, @Nullable Map<String, String> customVariableValues, @Nullable Set<Long> triggeringRepositories) throws RepositoryException {
        PlanVcsRevisionDataSet lastVcsRevisionKeyMap = this.planVcsRevisionHistoryService.getLastVcsRevisionKeys(chain.getPlanKey());
        boolean checkAllRepos = false;
        return this.collectChangesSinceRevisions(chain, customVariableValues, lastVcsRevisionKeyMap, false, null, triggeringRepositories, false);
    }

    private BuildChanges collectAllChangesSinceLastBuild(@NotNull ImmutableChain chain, @Nullable Map<String, String> customVariableValues, @Nullable String customRevision, boolean initialBranchBuildLogicEnabled) throws RepositoryException {
        PlanRepositoryDefinition defaultRepositoryDefinition = PlanHelper.getDefaultPlanRepositoryDefinition((ImmutablePlan)chain);
        Predicate<PlanRepositoryDefinition> useRevisionOverride = new Predicate<PlanRepositoryDefinition>(){
            private Pattern repositoryNamePattern = Pattern.compile(".*_default");

            @Override
            public boolean test(@Nullable PlanRepositoryDefinition repositoryDefinition) {
                return repositoryDefinition != null && this.repositoryNamePattern.matcher(repositoryDefinition.getName()).matches();
            }
        };
        PlanVcsRevisionDataSet lastVcsRevisionKeyMap = this.planVcsRevisionHistoryService.getLastVcsRevisionKeys(chain.getPlanKey());
        if (initialBranchBuildLogicEnabled && lastVcsRevisionKeyMap.isEmpty() && customRevision == null && chain instanceof ImmutableChainBranch) {
            BranchIntegrationPoint branchIntegrationPoint = BranchIntegrationPointImpl.changeDetectionIntegrationPointForChain(chain);
            return this.collectInitialStateForBranchBuild(chain, customVariableValues, branchIntegrationPoint, !chain.getBuildDefinition().getBranchIntegrationConfiguration().isEnabled());
        }
        boolean checkAllRepos = true;
        BuildChanges buildChanges = this.collectChangesSinceRevisions(chain, customVariableValues, lastVcsRevisionKeyMap, true, customRevision, null, true);
        if (defaultRepositoryDefinition != null) {
            String revisionOverride;
            String string = revisionOverride = customRevision != null ? customRevision : buildChanges.getVcsRevisionKey(defaultRepositoryDefinition.getId());
            if (revisionOverride != null) {
                chain.getPlanRepositoryDefinitions().stream().filter(useRevisionOverride).forEach(repositoryDefinition -> {
                    log.debug((Object)String.format("Default revision %s was applied to repository %s in chain %s", revisionOverride, repositoryDefinition.getName(), chain.getPlanKey().getKey()));
                    buildChanges.setVcsRevisionKey(repositoryDefinition.getId(), revisionOverride);
                });
            }
        }
        return buildChanges;
    }

    @NotNull
    public BuildChanges collectAllChangesSinceLastBuild(@NotNull ImmutableChain chain, @Nullable Map<String, String> customVariableValues, @Nullable String customRevision) throws RepositoryException {
        return this.collectAllChangesSinceLastBuild(chain, customVariableValues, customRevision, true);
    }

    private BuildChanges collectChangesSinceRevisions(ImmutableChain chain, Map<String, String> customVariableValues, PlanVcsRevisionDataSet lastVcsRevisionKeyMap, boolean checkAllRepos, @Nullable String customRevision, @Nullable Set<Long> triggeringRepositories, boolean suppressQuietPeriod) throws RepositoryException {
        boolean shouldCheckNonTriggeringRepos;
        log.debug((Object)("Collecting changes for " + chain.getKey()));
        Stopwatch stopwatch = Stopwatch.createStarted();
        BranchIntegrationConfiguration integrationConfiguration = chain.getBuildDefinition().getBranchIntegrationConfiguration();
        PlanRepositoryDefinition defaultRepository = PlanHelper.getDefaultPlanRepositoryDefinition((ImmutablePlan)chain);
        List repositoryDefinitions = chain.getPlanRepositoryDefinitions();
        BuildChangesImpl buildChanges = new BuildChangesImpl();
        Iterable triggeringRepositoryDefinitions = repositoryDefinitions.stream().filter(BambooPredicates.isChainTrigger(chain, triggeringRepositories)).collect(Collectors.toList());
        this.collectChangesSinceRevisions(chain, customVariableValues, buildChanges, lastVcsRevisionKeyMap, triggeringRepositoryDefinitions, customRevision, true, suppressQuietPeriod);
        boolean triggeringReposHaveChanges = !buildChanges.getChanges().isEmpty();
        boolean bl = shouldCheckNonTriggeringRepos = triggeringReposHaveChanges || checkAllRepos;
        if (shouldCheckNonTriggeringRepos) {
            Iterable nonTriggeringRepositories = repositoryDefinitions.stream().filter(BambooPredicates.isChainTrigger(chain, triggeringRepositories).negate()).collect(Collectors.toList());
            this.collectChangesSinceRevisions(chain, customVariableValues, buildChanges, lastVcsRevisionKeyMap, nonTriggeringRepositories, customRevision, false, suppressQuietPeriod);
            if (integrationConfiguration.isEnabled()) {
                this.lockInTheIntegrationBranchRevision(chain, buildChanges, lastVcsRevisionKeyMap);
            }
        }
        this.updateLastCommitInformationIfChainBranch(chain, defaultRepository, buildChanges);
        stopwatch.stop();
        BambooLogUtils.logOperationTime((Logger)log, (Stopwatch)stopwatch, (int)10, (int)20, (int)30, (String)String.format("Change detection for plan %s", chain.getPlanKey()));
        return buildChanges;
    }

    private void lockInTheIntegrationBranchRevision(final @NotNull ImmutableChain chain, final @NotNull BuildChanges buildChanges, final @NotNull PlanVcsRevisionDataSet branchLastVcsRevisionKeyMap) {
        Preconditions.checkNotNull((Object)PlanHelper.getDefaultPlanRepositoryDefinition((ImmutablePlan)chain), (Object)"no default repository set up for this branch");
        BranchIntegrationConfiguration integrationConfiguration = chain.getBuildDefinition().getBranchIntegrationConfiguration();
        final VcsRepositoryData integrationRepositoryDefinition = (VcsRepositoryData)Preconditions.checkNotNull((Object)this.branchIntegrationService.getIntegrationRepository((ImmutablePlan)chain), (Object)"no default repository set up for integration branch");
        final VcsRepositoryModuleDescriptor vcsRepositoryModuleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(integrationRepositoryDefinition.getPluginKey());
        if (vcsRepositoryModuleDescriptor == null || !vcsRepositoryModuleDescriptor.supportsMerging()) {
            throw new IllegalStateException("Repository '" + integrationRepositoryDefinition.getName() + "' does not support merging, build will not start. Please check your plan's configuration or turn off merging.");
        }
        this.customVariableContext.withVariableSubstitutor(this.customVariableContext.getVariableSubstitutorFactory().newSubstitutorForPlan((ImmutablePlan)chain), new Runnable(){

            @Override
            public void run() {
                try {
                    PlanVcsRevisionData lastIntegrationVcsRevision = branchLastVcsRevisionKeyMap.get(integrationRepositoryDefinition.getId());
                    BuildRepositoryChanges integrationRepositoryChanges = vcsRepositoryModuleDescriptor.getChangeDetector().collectChangesSinceRevision(chain.getPlanKey(), integrationRepositoryDefinition, lastIntegrationVcsRevision);
                    integrationRepositoryChanges.setChanges(integrationRepositoryChanges.getChanges().stream().map(CommitPredicates::toForeignCommit).collect(Collectors.toList()));
                    integrationRepositoryChanges.setRepositoryId(integrationRepositoryDefinition.getId());
                    integrationRepositoryChanges.setPreviousVcsRevisionKey(lastIntegrationVcsRevision != null ? lastIntegrationVcsRevision.getVcsRevisionKey() : null);
                    buildChanges.setIntegrationBranchRevisionData(new PlanVcsRevisionData(integrationRepositoryChanges));
                    buildChanges.setIntegrationRepositoryId(integrationRepositoryDefinition.getId());
                    buildChanges.addRepositoryChanges(integrationRepositoryChanges);
                }
                catch (RepositoryException e) {
                    log.error((Object)("something went wrong:" + e.getMessage()), (Throwable)e);
                }
            }
        });
    }

    private void collectChangesSinceRevisions(ImmutableChain chain, Map<String, String> customVariableValues, BuildChanges buildChanges, PlanVcsRevisionDataSet lastVcsRevisionKeyMap, Iterable<PlanRepositoryDefinition> repositoryDefinitions, @Nullable String customRevision, boolean isBuildTriggeringRepo, boolean suppressQuietPeriod) throws RepositoryException {
        log.debug((Object)("Collecting changes for plan: " + chain.getPlanKey()));
        for (PlanRepositoryDefinition repositoryDefinition : repositoryDefinitions) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Collecting changes for repository " + repositoryDefinition));
            }
            BuildRepositoryChanges repositoryChanges = this.collectChangesSinceLastBuildInternal(chain, repositoryDefinition, lastVcsRevisionKeyMap.get(repositoryDefinition.getId()), customVariableValues, customRevision, isBuildTriggeringRepo, suppressQuietPeriod);
            buildChanges.addRepositoryChanges(repositoryChanges);
        }
    }

    @NotNull
    public BuildRepositoryChanges collectChangesSinceLastBuild(@NotNull ImmutableChain chain, @NotNull PlanRepositoryDefinition repositoryDefinition, @NotNull PlanVcsRevisionData lastVcsRevisionData, @Nullable Map<String, String> customVariableValues, @Nullable String customRevision) throws RepositoryException {
        return this.collectChangesSinceLastBuildInternal(chain, repositoryDefinition, lastVcsRevisionData, customVariableValues, customRevision, false, true);
    }

    @NotNull
    private BuildChanges collectInitialStateForBranchBuild(@NotNull ImmutableChain chain, @Nullable Map<String, String> customVariableValues, @NotNull BranchIntegrationPoint branchIntegrationPoint, boolean limitChangeList) throws RepositoryException {
        PlanRepositoryDefinition defaultRepositoryDefinition = PlanHelper.getDefaultPlanRepositoryDefinition((ImmutablePlan)chain);
        if (defaultRepositoryDefinition == null) {
            return new BuildChangesImpl();
        }
        BranchIntegrationConfiguration integrationConfiguration = chain.getBuildDefinition().getBranchIntegrationConfiguration();
        PlanRepositoryDefinition integrationRepositoryDefinition = this.branchIntegrationService.getIntegrationRepository((ImmutablePlan)chain, branchIntegrationPoint);
        if (!integrationRepositoryDefinition.getPluginKey().equals(defaultRepositoryDefinition.getPluginKey())) {
            log.debug((Object)"X-branch change detection failed due to plugin mismatch. Fall back on regular CD");
            return this.collectAllChangesSinceLastBuild(chain, customVariableValues, null, false);
        }
        VcsChangeDetector changeDetector = this.getChangeDetector(defaultRepositoryDefinition.getPluginKey());
        PlanVcsRevisionDataSet lastVcsRevisionKeyMap = this.planVcsRevisionHistoryService.getLastVcsRevisionKeys(chain.getPlanKey());
        boolean checkAllRepos = true;
        log.debug((Object)("Collecting changes for " + chain.getKey()));
        List repositoryDefinitions = chain.getPlanRepositoryDefinitions();
        BuildChangesImpl buildChanges = new BuildChangesImpl();
        BuildLogger buildLogger = this.buildLoggerManager.getLogger((Key)chain.getPlanKey());
        Map variableContext = this.variableDefinitionManager.createVariableContextBuilder().addGlobalVariables().addPlanVariables((ImmutablePlan)chain).addManualVariables(customVariableValues).buildMap();
        VariableSubstitutor variableSubstitutor = this.customVariableContext.getVariableSubstitutorFactory().newSubstitutorForVariables(variableContext);
        try {
            VcsBranch integrationBranch = integrationRepositoryDefinition.getBranch() != null ? integrationRepositoryDefinition.getBranch().getVcsBranch() : null;
            BuildRepositoryChanges buildRepositoryChanges = (BuildRepositoryChanges)this.customVariableContext.withVariableSubstitutor(variableSubstitutor, () -> changeDetector.collectChangesForInitialBuild(chain.getPlanKey(), (VcsRepositoryData)defaultRepositoryDefinition, integrationBranch, limitChangeList));
            buildRepositoryChanges.setRepositoryId(defaultRepositoryDefinition.getId());
            VcsChangeDetectionOptions changeDetectionOptions = defaultRepositoryDefinition.getVcsChangeDetectionOptions();
            if (changeDetectionOptions != null) {
                buildRepositoryChanges = this.filterExcludedChangesets(buildRepositoryChanges, changeDetectionOptions, buildLogger);
                buildRepositoryChanges = this.filterExcludedFiles(buildRepositoryChanges, changeDetectionOptions, buildLogger);
            }
            buildChanges.addRepositoryChanges(buildRepositoryChanges);
        }
        catch (Exception ex) {
            throw new RepositoryException((Throwable)ex, defaultRepositoryDefinition.getId());
        }
        Iterable nonDefaultRepositories = Iterables.skip((Iterable)repositoryDefinitions, (int)1);
        this.collectChangesSinceRevisions(chain, customVariableValues, buildChanges, lastVcsRevisionKeyMap, nonDefaultRepositories, null, false, true);
        if (integrationConfiguration.isEnabled()) {
            this.lockInTheIntegrationBranchRevision(chain, buildChanges, lastVcsRevisionKeyMap);
        }
        this.updateLastCommitInformationIfChainBranch(chain, defaultRepositoryDefinition, buildChanges);
        return buildChanges;
    }

    private void updateLastCommitInformationIfChainBranch(@NotNull ImmutableChain chain, PlanRepositoryDefinition defaultRepositoryDefinition, BuildChanges buildChanges) {
        ImmutableChainBranch chainBranch = (ImmutableChainBranch)Narrow.downTo((Object)chain, ImmutableChainBranch.class);
        if (chainBranch != null && defaultRepositoryDefinition != null) {
            try {
                List commits = buildChanges.getChanges(defaultRepositoryDefinition.getId());
                if (!commits.isEmpty()) {
                    CommitContext lastCommit = null;
                    Date lastCommitDate = null;
                    for (CommitContext commitContext : commits) {
                        if (lastCommitDate != null && !lastCommitDate.before(commitContext.getDate())) continue;
                        lastCommitDate = commitContext.getDate();
                        lastCommit = commitContext;
                    }
                    BranchCommitInformation bci = chainBranch.getCommitInformation();
                    if (bci == null) {
                        bci = new BranchCommitInformationImpl(chainBranch.getId());
                    }
                    this.branchCommitInformationManager.save(this.branchCommitInformationManager.updateLatestCommitInformation(bci, lastCommit));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @NotNull
    VcsChangeDetector getChangeDetector(@NotNull String pluginKey) throws RepositoryException {
        VcsChangeDetector vcsChangeDetector;
        VcsRepositoryModuleDescriptor moduleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(pluginKey);
        if (moduleDescriptor != null && (vcsChangeDetector = moduleDescriptor.getChangeDetector()) != null) {
            return vcsChangeDetector;
        }
        throw new RepositoryException("Can't find change detector class for repository plugin " + pluginKey);
    }

    @VisibleForTesting
    @NotNull
    protected BuildRepositoryChanges collectChangesSinceLastBuildInternal(@NotNull ImmutableChain chain, @NotNull PlanRepositoryDefinition repositoryDefinition, @NotNull PlanVcsRevisionData lastVcsRevisionData, @Nullable Map<String, String> customVariableValues, @Nullable String customRevision, boolean isBuildTrigger, boolean suppressQuietPeriod) throws RepositoryException {
        BuildLogger buildLogger = this.buildLoggerManager.getLogger((Key)chain.getPlanKey());
        Map variableContext = this.variableDefinitionManager.createVariableContextBuilder().addGlobalVariables().addPlanVariables((ImmutablePlan)chain).addManualVariables(customVariableValues).buildMap();
        try {
            Callable<BuildRepositoryChanges> createBuildRepositoryChanges = this.createBuildRepositoryChanges(chain, repositoryDefinition, lastVcsRevisionData, customRevision, isBuildTrigger, buildLogger, suppressQuietPeriod);
            VariableSubstitutor variableSubstitutor = this.customVariableContext.getVariableSubstitutorFactory().newSubstitutorForVariables(variableContext);
            return (BuildRepositoryChanges)this.customVariableContext.withVariableSubstitutor(variableSubstitutor, createBuildRepositoryChanges);
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new RepositoryException((Throwable)ex, repositoryDefinition.getId());
        }
    }

    @NotNull
    private Callable<BuildRepositoryChanges> createBuildRepositoryChanges(@NotNull ImmutableChain chain, @NotNull PlanRepositoryDefinition repositoryDefinition, @NotNull PlanVcsRevisionData lastVcsRevisionData, @Nullable String customRevision, boolean isBuildTrigger, BuildLogger buildLogger, boolean suppressQuietPeriod) {
        return () -> {
            List isolatedChanges;
            CommitsIsolatingVcsChangeDetector commitsIsolator;
            List<BuildRepositoryChanges> isolatedChanges2;
            Stopwatch stopWatch = Stopwatch.createStarted();
            BuildRepositoryChanges changes = null;
            VcsChangeDetector changeDetector = this.getChangeDetector(repositoryDefinition.getPluginKey());
            VcsChangeDetectionOptions changeDetectionOptions = repositoryDefinition.getVcsChangeDetectionOptions();
            if (changeDetectionOptions != null && changeDetectionOptions.isCommitIsolationEnabled() && customRevision == null && (isolatedChanges2 = this.isolatedCommits.get(chain.getPlanKey())) != null && !isolatedChanges2.isEmpty()) {
                log.info((Object)buildLogger.addBuildLogEntry((LogEntry)new CommandLogEntry("Isolating the build to a single commit (" + isolatedChanges2.size() + " changes found)")));
                changes = isolatedChanges2.get(0);
                isolatedChanges2.remove(0);
                changes.setPreviousVcsRevisionKey(lastVcsRevisionData.getVcsRevisionKey());
                return changes;
            }
            if (!suppressQuietPeriod && changeDetectionOptions != null && changeDetectionOptions.isQuietPeriodEnabled()) {
                changes = this.collectChangesAfterQuietPeriod(chain, repositoryDefinition, lastVcsRevisionData, buildLogger, changeDetector, customRevision);
            } else if (customRevision != null && PlanHelper.isDefault(repositoryDefinition)) {
                try {
                    changes = changeDetector.collectChangesForRevision(chain.getPlanKey(), (VcsRepositoryData)repositoryDefinition, customRevision);
                }
                catch (RepositoryException e) {
                    this.handleRepositoryExceptionForDeletedBranch(e, repositoryDefinition, chain);
                }
            } else {
                changes = this.collectionChangesWithRetry(chain, changeDetector, repositoryDefinition, lastVcsRevisionData);
            }
            if (changes != null) {
                changes.setRepositoryId(repositoryDefinition.getId());
                changes.setBuildTrigger(isBuildTrigger);
            }
            if (changeDetectionOptions != null) {
                changes = this.filterExcludedChangesets(changes, changeDetectionOptions, buildLogger);
                changes = this.filterExcludedFiles(changes, changeDetectionOptions, buildLogger);
            }
            if (changeDetectionOptions != null && changeDetectionOptions.isCommitIsolationEnabled() && (commitsIsolator = (CommitsIsolatingVcsChangeDetector)Narrow.downTo((Object)changeDetector, CommitsIsolatingVcsChangeDetector.class)) != null && (isolatedChanges = commitsIsolator.isolateCommits(changes, (VcsRepositoryData)repositoryDefinition)).size() > 1) {
                log.info((Object)buildLogger.addBuildLogEntry((LogEntry)new CommandLogEntry("Isolating the build to a single commit (" + isolatedChanges.size() + " changes found)")));
                changes = (BuildRepositoryChanges)isolatedChanges.get(0);
                this.isolatedCommits.put(chain.getPlanKey(), Lists.newArrayList((Iterable)Iterables.skip((Iterable)isolatedChanges, (int)1)));
            }
            if (changes != null) {
                changes.setPreviousVcsRevisionKey(lastVcsRevisionData.getVcsRevisionKey());
            }
            stopWatch.stop();
            log.debug((Object)String.format("Change detection for repository \"%s\" in plan \"%s\" took %s", repositoryDefinition.getName(), chain.getPlanKey(), stopWatch));
            return changes;
        };
    }

    private BuildRepositoryChanges collectChangesAfterQuietPeriod(@NotNull ImmutableChain chain, PlanRepositoryDefinition repositoryDefinition, @NotNull PlanVcsRevisionData lastVcsRevisionData, BuildLogger buildLogger, VcsChangeDetector changeDetector, @Nullable String customRevision) throws RepositoryException {
        String revisionKey;
        List newChanges;
        VcsChangeDetectionOptions changeDetectionOptions = repositoryDefinition.getVcsChangeDetectionOptions();
        int quietPeriod = changeDetectionOptions.getQuietPeriod();
        int maxRetries = changeDetectionOptions.getMaxRetries();
        int retries = 0;
        PlanVcsRevisionData updatingRevisionData = lastVcsRevisionData;
        BuildRepositoryChangesImpl currentBuildChanges = new BuildRepositoryChangesImpl(repositoryDefinition.getId());
        do {
            BuildRepositoryChanges newBuildChanges = null;
            try {
                newBuildChanges = customRevision != null && PlanHelper.isDefault(repositoryDefinition) ? changeDetector.collectChangesForRevision(chain.getPlanKey(), (VcsRepositoryData)repositoryDefinition, customRevision) : changeDetector.collectChangesSinceRevision(chain.getPlanKey(), (VcsRepositoryData)repositoryDefinition, updatingRevisionData);
            }
            catch (RepositoryException e) {
                this.handleRepositoryExceptionForDeletedBranch(e, repositoryDefinition, chain);
            }
            newChanges = newBuildChanges.getChanges();
            currentBuildChanges = this.buildContextFactory.buildChangesUnion((BuildRepositoryChanges)currentBuildChanges, newBuildChanges);
            currentBuildChanges.setCustomXmlData(newBuildChanges.getCustomXmlData());
            revisionKey = currentBuildChanges.getVcsRevisionKey();
            updatingRevisionData = new PlanVcsRevisionData(currentBuildChanges.getVcsRevisionKey(), currentBuildChanges.getCustomXmlData());
            if (!CollectionUtils.isNotEmpty((Collection)newChanges) || ++retries >= maxRetries || revisionKey == null) continue;
            long millis = TimeUnit.SECONDS.toMillis(quietPeriod);
            String durationString = DurationUtils.getPrettyPrint((long)millis, (boolean)true);
            String messageText = this.textProvider.getText("repository.change.quietPeriod.wait.message", Arrays.asList(newChanges.size(), chain.getPlanKey().getKey(), durationString, maxRetries - retries));
            log.info((Object)buildLogger.addBuildLogEntry(messageText));
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException e) {
                log.info((Object)"Change collection interrupted. Not all changes may have been detected", (Throwable)e);
                break;
            }
        } while (CollectionUtils.isNotEmpty((Collection)newChanges) && retries < maxRetries && revisionKey != null);
        BuildRepositoryChangesImpl changes = currentBuildChanges;
        return changes;
    }

    private BuildRepositoryChanges collectionChangesWithRetry(ImmutableChain chain, VcsChangeDetector changeDetector, PlanRepositoryDefinition repository, PlanVcsRevisionData lastRevision) throws RepositoryException {
        try {
            return changeDetector.collectChangesSinceRevision(chain.getPlanKey(), (VcsRepositoryData)repository, lastRevision);
        }
        catch (RepositoryException e) {
            return this.handleRepositoryExceptionForDeletedBranchWithRetry(e, changeDetector, repository, lastRevision, chain);
        }
    }

    private void handleRepositoryExceptionForDeletedBranch(RepositoryException e, PlanRepositoryDefinition planRepositoryDefinition, ImmutableChain chain) throws RepositoryException {
        VcsRepositoryModuleDescriptor moduleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(planRepositoryDefinition.getPluginKey());
        if (planRepositoryDefinition.getBranch() != null && chain.hasMaster() && moduleDescriptor.supportsBranchDetection()) {
            List openBranches;
            VcsBranchDetector branchDetector = moduleDescriptor.getBranchDetector();
            VcsBranch storedVcsBranch = planRepositoryDefinition.getBranch().getVcsBranch();
            try {
                openBranches = this.repositoryCachingFacade.getOpenBranches(branchDetector, (VcsRepositoryData)planRepositoryDefinition);
                log.info((Object)("Found " + openBranches.size() + " open branches for " + chain.getPlanKey()));
            }
            catch (RepositoryException innerRepoException) {
                log.debug((Object)("Possible repository connection problem detected while contacting repo '" + planRepositoryDefinition.getName() + "' and branch '" + storedVcsBranch.getName() + "'"), (Throwable)e);
                throw e;
            }
            String branchName = this.customVariableContext.substituteString(storedVcsBranch.getName());
            if (openBranches.isEmpty()) {
                log.warn((Object)("List of open branches is empty for " + planRepositoryDefinition.getName() + " and plan " + chain + ". Skip removal of current branch '" + branchName + "'"));
                throw e;
            }
            boolean noOpenBranchesMatch = openBranches.stream().noneMatch(vcsBranch -> vcsBranch.isEqualToBranchWith(branchName));
            if (noOpenBranchesMatch) {
                this.chainBranchManager.handleVcsBranchDeletedOfPlanBranch(chain, planRepositoryDefinition);
                throw new RepositoryBranchDeletedException(String.format("Branch %s has been removed from VCS", branchName), planRepositoryDefinition.getId());
            }
        }
        throw e;
    }

    private BuildRepositoryChanges handleRepositoryExceptionForDeletedBranchWithRetry(RepositoryException e, VcsChangeDetector changeDetector, PlanRepositoryDefinition repository, PlanVcsRevisionData lastRevision, ImmutableChain chain) throws RepositoryException {
        this.handleRepositoryExceptionForDeletedBranch(e, repository, chain);
        return RetryingTaskExecutor.retry("Collecting changes for " + chain.getPlanKey(), MAX_OPERATION_RETRIES, RetryingTaskExecutor.randomInitialDelay().plusSeconds(5L), () -> changeDetector.collectChangesSinceRevision(chain.getPlanKey(), (VcsRepositoryData)repository, lastRevision));
    }

    @NotNull
    public BuildRepositoryChanges collectChangesBetween(@NotNull ImmutableChain chain, @NotNull PlanRepositoryDefinition repositoryDefinition, @Nullable PlanVcsRevisionData fromVcsRevisionData, @NotNull PlanVcsRevisionData toVcsRevisionData) throws RepositoryException {
        BuildRepositoryChangesImpl changes = new BuildRepositoryChangesImpl(repositoryDefinition.getId());
        changes.setVcsRevisionKey(toVcsRevisionData.getVcsRevisionKey());
        BuildRepositoryChanges changesSinceLastBuild = this.collectChangesSinceLastBuild(chain, repositoryDefinition, fromVcsRevisionData, null, null);
        if (!changesSinceLastBuild.getChanges().isEmpty()) {
            BuildRepositoryChanges changesFromLaterTime = this.collectChangesSinceLastBuild(chain, repositoryDefinition, toVcsRevisionData, null, null);
            if (changesFromLaterTime.getChanges().isEmpty()) {
                changes.setChanges(changesSinceLastBuild.getChanges());
            } else {
                changes.setChanges(BambooCollectionUtils.subtract(changesSinceLastBuild.getChanges(), changesFromLaterTime.getChanges()));
            }
            changes.setCustomXmlData(changesFromLaterTime.getCustomXmlData());
        }
        return changes;
    }

    public void updateIntegrationRepositoryDetails(ImmutableChain chain, BuildChanges buildChanges) throws RepositoryException {
        BranchIntegrationConfiguration integrationConfiguration = chain.getBuildDefinition().getBranchIntegrationConfiguration();
        if (integrationConfiguration.isEnabled()) {
            PlanVcsRevisionDataSet lastVcsRevisionKeyMap = this.planVcsRevisionHistoryService.getLastVcsRevisionKeys(chain.getPlanKey());
            this.lockInTheIntegrationBranchRevision(chain, buildChanges, lastVcsRevisionKeyMap);
        }
    }

    @NotNull
    BuildRepositoryChanges filterExcludedFiles(@NotNull BuildRepositoryChanges buildChanges, @NotNull VcsChangeDetectionOptions changeDetectionOptions, @NotNull BuildLogger buildLogger) {
        List commits = buildChanges.getChanges();
        String filePatternOption = changeDetectionOptions.getFilterFilePatternOption();
        boolean filterPatternExclude = "excludeAll".equals(filePatternOption);
        boolean filterPatternInclude = "includeOnly".equals(filePatternOption);
        String regex = changeDetectionOptions.getFilterFilePatternRegex();
        Pattern filterFilePattern = null;
        if (!StringUtils.isBlank((CharSequence)regex)) {
            try {
                filterFilePattern = Pattern.compile(regex);
            }
            catch (PatternSyntaxException e) {
                log.warn((Object)"Incorrect pattern", (Throwable)e);
            }
        }
        if (commits == null || commits.isEmpty() || !filterPatternInclude && !filterPatternExclude) {
            return buildChanges;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Mode: %s, pattern %s", filePatternOption, regex));
        }
        ArrayList<CommitContextImpl> filteredCommits = new ArrayList<CommitContextImpl>();
        for (CommitContext commit : commits) {
            int includedFiles = 0;
            int excludedFiles = 0;
            ArrayList<CommitFile> filteredFiles = new ArrayList<CommitFile>();
            List commitFiles = commit.getFiles();
            for (CommitFile commitFile : commitFiles) {
                String fileName = commitFile.getName();
                boolean matches = false;
                if (filterFilePattern != null) {
                    matches = filterFilePattern.matcher(fileName).matches();
                }
                if (filterPatternExclude && !matches) {
                    filteredFiles.add(commitFile);
                    continue;
                }
                if (filterPatternInclude && matches) {
                    log.debug((Object)("Including file named '" + fileName + "' to change log."));
                    filteredFiles.add(commitFile);
                    ++includedFiles;
                    continue;
                }
                log.debug((Object)("Excluding file named '" + fileName + "' from change log."));
                ++excludedFiles;
            }
            if (includedFiles != 0) {
                log.info((Object)buildLogger.addBuildLogEntry("Included " + includedFiles + " file(s) from commit " + StringUtils.defaultString((String)commit.getChangeSetId())));
            }
            if (excludedFiles != 0) {
                log.info((Object)buildLogger.addBuildLogEntry("Excluded " + excludedFiles + " file(s) from commit " + StringUtils.defaultString((String)commit.getChangeSetId())));
            }
            if (filteredFiles.isEmpty() && (!filterPatternExclude || !commitFiles.isEmpty())) continue;
            CommitContextImpl commitContext = new CommitContextImpl(commit.getAuthorContext(), filteredFiles, commit.getComment(), commit.getDate(), commit.getChangeSetId());
            filteredCommits.add(commitContext);
        }
        buildChanges.setChanges(filteredCommits);
        return buildChanges;
    }

    @NotNull
    BuildRepositoryChanges filterExcludedChangesets(@NotNull BuildRepositoryChanges buildChanges, @NotNull VcsChangeDetectionOptions changeDetectionOptions, @NotNull BuildLogger buildLogger) {
        List commits = buildChanges.getChanges();
        if (commits == null || commits.isEmpty()) {
            return buildChanges;
        }
        ArrayList<String> patterns = new ArrayList<String>();
        String regex = changeDetectionOptions.getChangesetFilterPatternRegex();
        if (StringUtils.isNotBlank((CharSequence)regex)) {
            patterns.add(regex);
        }
        patterns.add("\\[maven-release-plugin\\].*");
        Iterable exclusionPatterns = patterns.stream().map(p -> {
            try {
                return Pattern.compile(p, 32);
            }
            catch (PatternSyntaxException e) {
                log.warn((Object)"Incorrect pattern", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (Iterables.isEmpty((Iterable)exclusionPatterns)) {
            return buildChanges;
        }
        ArrayList<CommitContext> filteredCommits = new ArrayList<CommitContext>();
        for (CommitContext commit : commits) {
            String comment = commit.getComment();
            boolean matches = false;
            for (Pattern exclusionPattern : exclusionPatterns) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("Changeset filter pattern %s", regex));
                }
                if (!exclusionPattern.matcher(comment).matches()) continue;
                matches = true;
                break;
            }
            if (!matches) {
                filteredCommits.add(commit);
                continue;
            }
            log.info((Object)buildLogger.addBuildLogEntry("Excluding changeset '" + commit.getChangeSetId() + "' from change log."));
        }
        buildChanges.setChanges(filteredCommits);
        return buildChanges;
    }
}

