/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.trigger;

import com.atlassian.bamboo.build.BuildDetectionAction;
import com.atlassian.bamboo.build.BuildDetectionActionFactory;
import com.atlassian.bamboo.build.PlanDependencyManager;
import com.atlassian.bamboo.chains.ChainExecution;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.event.ChainCompletedEvent;
import com.atlassian.bamboo.event.HibernateEventListener;
import com.atlassian.bamboo.plan.NonBlockingPlanExecutionService;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.cache.ImmutablePlanCacheService;
import com.atlassian.bamboo.resultsummary.BuildResultsSummaryManagerImpl;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.trigger.Triggerable;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.trigger.DependencyBlockingManager;
import com.atlassian.event.Event;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Set;
import org.apache.log4j.Logger;

public class DependencyChainListener
implements HibernateEventListener {
    private static final Logger log = Logger.getLogger(DependencyChainListener.class);
    public static final String DEPENDENCIES_DISABLED = "dependenciesDisabled";
    private final BuildDetectionActionFactory buildDetectionActionFactory;
    private final DependencyBlockingManager dependencyBlockingManager;
    private final ImmutablePlanCacheService immutablePlanCacheService;
    private final PlanDependencyManager planDependencyManager;
    private final NonBlockingPlanExecutionService nonBlockingPlanExecutionService;
    private final ResultsSummaryManager resultsSummaryManager;

    public DependencyChainListener(BuildDetectionActionFactory buildDetectionActionFactory, DependencyBlockingManager dependencyBlockingManager, ImmutablePlanCacheService immutablePlanCacheService, PlanDependencyManager planDependencyManager, NonBlockingPlanExecutionService nonBlockingPlanExecutionService, BuildResultsSummaryManagerImpl resultsSummaryManager) {
        this.buildDetectionActionFactory = buildDetectionActionFactory;
        this.dependencyBlockingManager = dependencyBlockingManager;
        this.immutablePlanCacheService = immutablePlanCacheService;
        this.planDependencyManager = planDependencyManager;
        this.nonBlockingPlanExecutionService = nonBlockingPlanExecutionService;
        this.resultsSummaryManager = resultsSummaryManager;
    }

    public void handleEvent(Event genericEvent) {
        ChainCompletedEvent event = (ChainCompletedEvent)genericEvent;
        BuildContext completedBuildContext = event.getBuildContext();
        PlanResultKey planResultKey = event.getPlanResultKey();
        boolean dependenciesDisabled = Boolean.parseBoolean((String)completedBuildContext.getBuildResult().getCustomBuildData().get(DEPENDENCIES_DISABLED));
        if (dependenciesDisabled) {
            log.info((Object)("Dependencies are disabled, skipping dependencies checks for '" + planResultKey + "'"));
            return;
        }
        ChainExecution chainState = event.getChainExecution();
        ImmutableChain parentChain = this.immutablePlanCacheService.getImmutablePlanByKey(event.getPlanKey());
        if (parentChain == null) {
            log.error((Object)("Failed to check dependencies for a plan. The plan with the key [" + chainState.getPlanResultKey().getPlanKey() + "] does not exist."));
        } else {
            log.info((Object)("Checking children plans of [" + parentChain.getKey() + "] for plan " + planResultKey));
            if (this.shouldTriggerDependencies(chainState, parentChain)) {
                Set planDependencies = this.planDependencyManager.getEffectiveChildPlans((ImmutablePlan)parentChain);
                for (ImmutablePlan childPlan : Iterables.filter((Iterable)planDependencies, ImmutableChain.class::isInstance)) {
                    ImmutableChain immutableChildChain = this.immutablePlanCacheService.getImmutablePlanByKey(childPlan.getPlanKey());
                    try {
                        if (this.dependencyBlockingManager.isBlockedFromBuilding(childPlan.getPlanKey(), planDependencies)) continue;
                        log.debug((Object)"Going ahead with dependent build, no reason to block it...");
                        BuildDetectionAction action = this.buildDetectionActionFactory.createDependentBuildDetectionAction(immutableChildChain, parentChain, completedBuildContext);
                        this.nonBlockingPlanExecutionService.tryToStart((Triggerable)immutableChildChain, action);
                    }
                    catch (Exception e) {
                        log.error((Object)("Failed to start dependencies for '" + parentChain.getPlanKey() + "', " + e));
                    }
                }
            }
            log.info((Object)("Finished checking children plans of '" + parentChain.getName() + "' for plan " + planResultKey));
        }
    }

    private boolean shouldTriggerDependencies(ChainExecution chainState, ImmutableChain chain) {
        boolean isCurrentStateSuccesful = chainState.isSuccessful();
        if (!isCurrentStateSuccesful) {
            log.info((Object)"Dependant builds not checked since plan failed");
            return false;
        }
        boolean triggerOnlyAfterAllStages = Boolean.parseBoolean((String)chain.getBuildDefinition().getCustomConfiguration().get("custom.dependencies.triggerOnlyAfterAllStages"));
        if (triggerOnlyAfterAllStages) {
            ChainResultsSummary crs = (ChainResultsSummary)Preconditions.checkNotNull((Object)this.resultsSummaryManager.getResultsSummary(chainState.getPlanResultKey(), ChainResultsSummary.class), (Object)("Unable to find the chain result for " + chainState.getPlanResultKey()));
            return !crs.isContinuable();
        }
        return true;
    }

    public Class[] getHandledEventClasses() {
        return new Class[]{ChainCompletedEvent.class};
    }
}

