/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.trigger;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.BuildDetectionAction;
import com.atlassian.bamboo.build.BuildDetectionResult;
import com.atlassian.bamboo.build.BuildDetectionResultImpl;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.BuildNumberGeneratorService;
import com.atlassian.bamboo.build.context.BuildContextBuilderFactory;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.logger.ErrorUpdateHandler;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.trigger.TriggerManager;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionHistoryService;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.trigger.AbstractDependentDetectionAction;
import com.atlassian.bamboo.v2.trigger.ChangeDetectionManager;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DependentBuildDetectionAction
extends AbstractDependentDetectionAction
implements BuildDetectionAction {
    private static final Logger log = Logger.getLogger(DependentBuildDetectionAction.class);

    public DependentBuildDetectionAction(ImmutableChain chain, ImmutableChain parentChain, BuildContext completedBuildContext, ErrorUpdateHandler errorUpdateHandler, TriggerManager triggerManager, ChangeDetectionManager changeDetectionManager, BuildNumberGeneratorService buildNumberGeneratorService, BuildLoggerManager buildLoggerManager, PlanVcsRevisionHistoryService planVcsRevisionHistoryService, BuildContextBuilderFactory buildContextBuilderFactory, CustomVariableContext customVariableContext, VcsRepositoryManager vcsRepositoryManager) {
        super(chain, parentChain, completedBuildContext, errorUpdateHandler, triggerManager, changeDetectionManager, buildNumberGeneratorService, buildLoggerManager, planVcsRevisionHistoryService, buildContextBuilderFactory, customVariableContext, vcsRepositoryManager);
    }

    @Override
    @NotNull
    public BuildDetectionResult generateResultWithoutChanges() {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        BuildContext buildContext = this.prepareBuildContext((ErrorCollection)errorCollection);
        if (buildContext != null) {
            BuildLogger parentPlanLogger = this.parentChain.getBuildLogger();
            BuildLogger planLogger = this.chain.getBuildLogger();
            BuildLogger buildLogger = this.buildLoggerManager.getLogger((ResultKey)buildContext.getPlanResultKey());
            log.info((Object)parentPlanLogger.addBuildLogEntry("Build " + this.completedBuildResultKey + " triggering dependant build " + buildContext.getBuildResultKey()));
            log.info((Object)planLogger.addBuildLogEntry("Build triggered by " + this.completedBuildResultKey));
            buildLogger.addBuildLogEntry("Build " + buildContext.getBuildResultKey() + " triggered by parent build " + this.completedBuildResultKey);
        }
        return new BuildDetectionResultImpl((ErrorCollection)errorCollection, buildContext);
    }

    public String toString() {
        return "dependant build detection of " + this.planKey + " with parent " + this.parentChain;
    }
}

