/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.trigger;

import com.atlassian.bamboo.build.BuildDetectionAction;
import com.atlassian.bamboo.build.BuildDetectionActionFactory;
import com.atlassian.bamboo.event.ChainCreatedEvent;
import com.atlassian.bamboo.plan.NonBlockingPlanExecutionService;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.trigger.TriggerConfigurator;
import com.atlassian.bamboo.trigger.TriggerModuleDescriptor;
import com.atlassian.bamboo.trigger.TriggerTypeManager;
import com.atlassian.bamboo.trigger.Triggerable;
import com.atlassian.bamboo.util.CacheAwareness;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.event.api.EventListener;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class InitialBuildListener {
    private static final Logger log = Logger.getLogger(InitialBuildListener.class);
    @Inject
    private CachedPlanManager cachedPlanManager;
    @Inject
    private BuildDetectionActionFactory buildDetectionActionFactory;
    @Inject
    private NonBlockingPlanExecutionService nonBlockingPlanExecutionService;
    @Inject
    private TriggerTypeManager triggerTypeManager;

    @EventListener
    public void handleEvent(@NotNull ChainCreatedEvent event) {
        PlanKey planKey = event.getPlanKey();
        ImmutableChain chain = (ImmutableChain)this.cachedPlanManager.getPlanByKey(planKey, ImmutableChain.class);
        if (chain == null) {
            return;
        }
        if (SystemProperty.FIRE_INITAL_BUILD_FOR_MANUAL_STRATEGY.getValue(false) || this.isChainTriggeredByChangeDetection(chain)) {
            log.info((Object)("Initial build for " + planKey));
            BuildDetectionAction buildDetectionAction = this.buildDetectionActionFactory.createInitialBuildDetectionAction(chain);
            CacheAwareness.withValuesOlderThanTimestampReloaded(() -> this.nonBlockingPlanExecutionService.tryToStart((Triggerable)chain, buildDetectionAction), event.getEventCreationTime().toEpochMilli(), new CacheAwareness.CacheInfo[0]);
        }
    }

    private boolean isChainTriggeredByChangeDetection(ImmutableChain chain) {
        List triggers = chain.getTriggerDefinitions();
        return triggers.stream().map(t -> this.triggerTypeManager.getTriggerDescriptor(t.getPluginKey())).filter(Objects::nonNull).map(TriggerModuleDescriptor::getTriggerConfigurator).filter(Objects::nonNull).anyMatch(tc -> tc.getRepositorySelectionMode() != TriggerConfigurator.RepositorySelectionMode.NONE);
    }
}

