/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.trigger;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.BuildDetectionResult;
import com.atlassian.bamboo.build.BuildDetectionResultImpl;
import com.atlassian.bamboo.build.BuildNumberGeneratorService;
import com.atlassian.bamboo.build.DelayedChangeDetectionAction;
import com.atlassian.bamboo.build.UserInitiatedBuildDetectionAction;
import com.atlassian.bamboo.build.context.BuildContextBuilderFactory;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.logger.ErrorUpdateHandler;
import com.atlassian.bamboo.plan.PlanExecutionConfig;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.branch.BranchIntegrationConfiguration;
import com.atlassian.bamboo.plan.branch.BranchIntegrationConfigurationImpl;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.trigger.TriggerManager;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.v2.build.BuildChanges;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.trigger.TriggerReason;
import com.atlassian.bamboo.v2.trigger.ChangeDetectionManager;
import com.atlassian.bamboo.variable.VariableContext;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import com.atlassian.user.User;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManualBuildDetectionAction
implements UserInitiatedBuildDetectionAction,
DelayedChangeDetectionAction {
    private static final Logger log = Logger.getLogger(ManualBuildDetectionAction.class);
    public static final String CUSTOM_REVISION_PARAMETER = "customRevision";
    private final ImmutableChain chain;
    private final User user;
    @Nullable
    private final PlanExecutionConfig planExecutionConfig;
    private final Map<String, String> params;
    private final Map<String, String> variables;
    private final String customRevision;
    private final BuildNumberGeneratorService buildNumberGenerator;
    private final ChangeDetectionManager changeDetectionManager;
    private final TriggerManager triggerManager;
    private final ErrorUpdateHandler errorUpdateHandler;
    private final VariableDefinitionManager variableDefinitionManager;
    private final BuildContextBuilderFactory buildContextBuilderFactory;

    public ManualBuildDetectionAction(ImmutableChain chain, User user, @Nullable PlanExecutionConfig planExecutionConfig, Map<String, String> params, Map<String, String> variables, BuildNumberGeneratorService buildNumberGenerator, ChangeDetectionManager changeDetectionManager, TriggerManager triggerManager, ErrorUpdateHandler errorUpdateHandler, VariableDefinitionManager variableDefinitionManager, BuildContextBuilderFactory buildContextBuilderFactory) {
        this.chain = chain;
        this.user = user;
        this.planExecutionConfig = planExecutionConfig;
        this.params = params;
        this.customRevision = params == null ? null : StringUtils.trim((String)params.get(CUSTOM_REVISION_PARAMETER));
        this.variables = variables;
        this.buildNumberGenerator = buildNumberGenerator;
        this.changeDetectionManager = changeDetectionManager;
        this.triggerManager = triggerManager;
        this.errorUpdateHandler = errorUpdateHandler;
        this.variableDefinitionManager = variableDefinitionManager;
        this.buildContextBuilderFactory = buildContextBuilderFactory;
    }

    @NotNull
    public BuildDetectionResult generateResultWithoutChanges() {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        BuildContext buildContext = null;
        try {
            BranchIntegrationConfiguration branchIntegrationConfiguration;
            BuildLogger planLogger = this.chain.getBuildLogger();
            BuildDefinition chainBuildDefinition = this.chain.getBuildDefinition();
            int buildNumber = this.buildNumberGenerator.generateBuildNumber((PlanIdentifier)this.chain);
            if (this.customRevision != null) {
                planLogger.addBuildLogEntry(String.format("Manual build %s-%d (for revision %s) triggered by %s", this.chain.getKey(), buildNumber, this.customRevision, this.user));
            } else {
                planLogger.addBuildLogEntry(String.format("Manual build %s-%d triggered by %s", this.chain.getKey(), buildNumber, this.user));
            }
            TriggerReason triggerReason = this.customRevision != null ? this.triggerManager.getTriggerReason("com.atlassian.bamboo.plugin.system.triggerReason:CustomRevisionBuildTriggerReason", (Map)ImmutableMap.of((Object)"ManualBuildTriggerReason.userName", (Object)this.user.getName(), (Object)"ManualBuildTriggerReason.customRevision", (Object)this.customRevision)) : this.triggerManager.getTriggerReason("com.atlassian.bamboo.plugin.system.triggerReason:ManualBuildTriggerReason", (Map)ImmutableMap.of((Object)"ManualBuildTriggerReason.userName", (Object)this.user.getName()));
            VariableContext variableContext = this.variableDefinitionManager.createVariableContextBuilder().addGlobalVariables().addPlanVariables((ImmutablePlan)this.chain).addManualVariables(this.variables).buildContext();
            buildContext = this.buildContextBuilderFactory.createBuilder().plan((ImmutablePlan)this.chain).buildNumber(buildNumber).triggerReason(triggerReason).buildDefinition(chainBuildDefinition).variableContext(variableContext).isOnceOff(this.customRevision != null).isCustomBuild(!this.variables.isEmpty()).build();
            if (this.planExecutionConfig != null && this.planExecutionConfig.isBranchMergePushOverride() && (branchIntegrationConfiguration = buildContext.getBuildDefinition().getBranchIntegrationConfiguration()).isEnabled()) {
                buildContext.getBuildDefinition().setBranchIntegrationConfiguration((BranchIntegrationConfiguration)new BranchIntegrationConfigurationImpl(branchIntegrationConfiguration, false, true));
            }
            if (this.params != null) {
                buildContext.getBuildResult().getCustomBuildData().putAll(this.params);
            }
        }
        catch (Exception e) {
            String message = "Error encountered while triggering manual build: " + e.getMessage();
            errorCollection.addErrorMessage(message);
            log.error((Object)this.chain.getBuildLogger().addBuildLogEntry(message), (Throwable)e);
            this.errorUpdateHandler.recordError((Key)this.chain.getPlanKey(), message, (Throwable)e);
        }
        return new BuildDetectionResultImpl((ErrorCollection)errorCollection, buildContext);
    }

    @Nullable
    public BuildChanges performDelayedChangeDetection(BuildContext buildContext) throws RepositoryException {
        return this.changeDetectionManager.collectAllChangesSinceLastBuild(this.chain, this.variables, this.customRevision);
    }

    @Nullable
    public PlanExecutionConfig getPlanExecutionConfig() {
        return this.planExecutionConfig;
    }
}

