/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.trigger;

import com.atlassian.bamboo.build.BuildDetectionResult;
import com.atlassian.bamboo.build.BuildDetectionResultImpl;
import com.atlassian.bamboo.build.BuildNumberGeneratorService;
import com.atlassian.bamboo.build.ConditionalBuildDetectionAction;
import com.atlassian.bamboo.build.UserInitiatedBuildDetectionAction;
import com.atlassian.bamboo.build.context.BuildContextBuilderFactory;
import com.atlassian.bamboo.plan.PlanExecutionConfig;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.trigger.PlanTrigger;
import com.atlassian.bamboo.plan.trigger.PlanTriggerResult;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionDataSet;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionHistoryService;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.trigger.TriggerReason;
import com.atlassian.bamboo.variable.VariableContext;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Pair;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginTriggerBuildDetectionAction
implements UserInitiatedBuildDetectionAction,
ConditionalBuildDetectionAction {
    private final PlanVcsRevisionHistoryService planVcsRevisionHistoryService;
    private final BuildNumberGeneratorService buildNumberGenerator;
    private final VariableDefinitionManager variableDefinitionManager;
    private final ImmutableChain chain;
    private final PlanTrigger buildTrigger;
    private final TriggerReason triggerReason;
    private final ImmutableMap<String, String> params;
    private final ImmutableMap<String, String> variables;
    private final PlanExecutionConfig planExecutionConfig;
    private final BuildContextBuilderFactory buildContextBuilderFactory;
    PlanTriggerResult result;
    int buildNumber;

    public PluginTriggerBuildDetectionAction(@NotNull PlanVcsRevisionHistoryService planVcsRevisionHistoryService, @NotNull BuildNumberGeneratorService buildNumberGenerator, @NotNull VariableDefinitionManager variableDefinitionManager, @NotNull BuildContextBuilderFactory buildContextBuilderFactory, @NotNull ImmutableChain chain, @Nullable PlanExecutionConfig planExecutionConfig, @NotNull TriggerReason triggerReason, @NotNull PlanTrigger buildTrigger, @NotNull Map<String, String> params, @NotNull Map<String, String> variables) {
        this.planVcsRevisionHistoryService = planVcsRevisionHistoryService;
        this.buildNumberGenerator = buildNumberGenerator;
        this.variableDefinitionManager = variableDefinitionManager;
        this.buildContextBuilderFactory = buildContextBuilderFactory;
        this.chain = chain;
        this.buildTrigger = buildTrigger;
        this.triggerReason = triggerReason;
        this.params = ImmutableMap.copyOf(params);
        this.variables = ImmutableMap.copyOf(variables);
        this.planExecutionConfig = planExecutionConfig;
    }

    public Pair<Boolean, ErrorCollection> testIfBuildShouldStart() {
        PlanVcsRevisionDataSet lastVcsRevisionsData = this.planVcsRevisionHistoryService.getLastVcsRevisionKeys(this.chain.getPlanKey());
        this.buildNumber = this.buildNumberGenerator.generateBuildNumber((PlanIdentifier)this.chain);
        PlanResultKey planResultKey = PlanKeys.getPlanResultKey((PlanKey)this.chain.getPlanKey(), (int)this.buildNumber);
        this.result = this.buildTrigger.triggerPlan(this.triggerReason, planResultKey, this.params, this.variables, lastVcsRevisionsData);
        return Pair.pair((Object)true, (Object)this.result.getErrorCollection());
    }

    @NotNull
    public BuildDetectionResult createBuildContext() {
        VariableContext variableContext = this.variableDefinitionManager.createVariableContextBuilder().addGlobalVariables().addPlanVariables((ImmutablePlan)this.chain).addManualVariables(this.result.getVariableMap()).buildContext();
        BuildContext buildContext = this.buildContextBuilderFactory.createBuilder().plan((ImmutablePlan)this.chain).buildNumber(this.buildNumber).triggerReason(this.triggerReason).buildDefinition(this.chain.getBuildDefinition()).buildChanges(this.result.getBuildChanges()).variableContext(variableContext).build();
        return new BuildDetectionResultImpl(this.result.getErrorCollection(), buildContext);
    }

    public PlanExecutionConfig getPlanExecutionConfig() {
        return this.planExecutionConfig;
    }
}

