/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.trigger;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.BuildDetectionResult;
import com.atlassian.bamboo.build.BuildDetectionResultImpl;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.BuildNumberGeneratorService;
import com.atlassian.bamboo.build.UnconditionalBuildDetectionAction;
import com.atlassian.bamboo.build.context.BuildContextBuilderFactory;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.test.TriggerConditionsAwareBuildDetectionAction;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.trigger.TriggerManager;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.v2.build.BuildChanges;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.trigger.ScheduledTriggerReason;
import com.atlassian.bamboo.v2.build.trigger.TriggerReason;
import com.atlassian.bamboo.v2.trigger.ChangeDetectionManager;
import com.google.common.collect.ImmutableMap;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScheduledBuildDetectionAction
implements TriggerConditionsAwareBuildDetectionAction,
UnconditionalBuildDetectionAction {
    private static final Logger log = Logger.getLogger(ScheduledBuildDetectionAction.class);
    private final ImmutableChain chain;
    private final Map<String, String> triggerConditionsConfiguration;
    private final Map<String, String> triggerConfiguration;
    private final ChangeDetectionManager changeDetectionManager;
    private final TriggerManager triggerManager;
    private final BuildNumberGeneratorService buildNumberGenerator;
    private final BuildLoggerManager buildLoggerManager;
    private final BuildContextBuilderFactory buildContextBuilderFactory;

    public ScheduledBuildDetectionAction(@NotNull ChangeDetectionManager changeDetectionManager, @NotNull TriggerManager triggerManager, @NotNull BuildNumberGeneratorService buildNumberGenerator, @NotNull BuildLoggerManager buildLoggerManager, @NotNull ImmutableChain chain, @NotNull Map<String, String> triggerConditionsConfiguration, @NotNull Map<String, String> triggerConfiguration, @NotNull BuildContextBuilderFactory buildContextBuilderFactory) {
        this.chain = chain;
        this.triggerConditionsConfiguration = ImmutableMap.copyOf(triggerConditionsConfiguration);
        this.triggerConfiguration = ImmutableMap.copyOf(triggerConfiguration);
        this.changeDetectionManager = changeDetectionManager;
        this.triggerManager = triggerManager;
        this.buildLoggerManager = buildLoggerManager;
        this.buildNumberGenerator = buildNumberGenerator;
        this.buildContextBuilderFactory = buildContextBuilderFactory;
    }

    @Nullable
    public BuildChanges performDelayedChangeDetection(BuildContext buildContext) throws RepositoryException {
        return this.changeDetectionManager.collectAllChangesSinceLastBuild(this.chain, null, null);
    }

    @NotNull
    public BuildDetectionResult generateResultWithoutChanges() {
        PlanKey planKey = this.chain.getPlanKey();
        log.info((Object)("Detecting changes for " + planKey + "..."));
        BuildLogger planLogger = this.chain.getBuildLogger();
        BuildDefinition buildDefinition = this.chain.getBuildDefinition();
        TriggerReason triggerReason = this.createTriggerReason();
        int buildNumber = this.buildNumberGenerator.generateBuildNumber((PlanIdentifier)this.chain);
        PlanResultKey planResultKey = PlanKeys.getPlanResultKey((PlanKey)this.chain.getPlanKey(), (int)buildNumber);
        log.info((Object)planLogger.addBuildLogEntry("Schedule build " + planResultKey + " triggered"));
        BuildContext buildContext = this.buildContextBuilderFactory.createBuilder().plan((ImmutablePlan)this.chain).buildNumber(buildNumber).triggerReason(triggerReason).buildDefinition(buildDefinition).build();
        BuildLogger buildLogger = this.buildLoggerManager.getLogger((ResultKey)planResultKey);
        buildLogger.addBuildLogEntry("Schedule build " + planResultKey + " triggered");
        return new BuildDetectionResultImpl((ErrorCollection)new SimpleErrorCollection(), buildContext);
    }

    @NotNull
    private TriggerReason createTriggerReason() {
        String triggerCreatedByUser;
        ImmutableMap.Builder fieldsMapBuilder = ImmutableMap.builder();
        fieldsMapBuilder.put((Object)"ScheduledTriggerReason.scheduledDate", (Object)ScheduledTriggerReason.DATE_FORMAT.format(new Date()));
        if (this.triggerConfiguration != null && !StringUtils.isBlank((CharSequence)(triggerCreatedByUser = this.triggerConfiguration.get("trigger.created.by.user")))) {
            fieldsMapBuilder.put((Object)"trigger.created.by.user", (Object)this.triggerConfiguration.get("trigger.created.by.user"));
        }
        return this.triggerManager.getTriggerReason("com.atlassian.bamboo.plugin.system.triggerReason:ScheduledTriggerReason", (Map)fieldsMapBuilder.build());
    }

    public Map<String, String> getTriggerConditionsConfiguration() {
        return this.triggerConditionsConfiguration;
    }

    public Map<String, String> getTriggerConfiguration() {
        return this.triggerConfiguration;
    }
}

