/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.validation;

import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.validation.ValidationFunction;
import com.atlassian.bamboo.validation.ValidationFunctionFactory;
import com.atlassian.struts.TextProvider;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;

public class ValidationFunctionFactoryImpl
implements ValidationFunctionFactory {
    private final ValidationFunction jobExistsValidator = new JobExistsValidator();
    private final ValidationFunction chainExistsValidator = new ChainExistsValidator();
    private final ValidationFunction uniqueJobKeyValidator = new UniqueJobKeyValidator();
    @Inject
    private CachedPlanManager cachedPlanManager;
    @Inject
    private PlanManager planManager;
    @Inject
    private TextProvider textProvider;

    @NotNull
    public ValidationFunction jobExists() {
        return this.jobExistsValidator;
    }

    @NotNull
    public ValidationFunction chainExists() {
        return this.chainExistsValidator;
    }

    @NotNull
    public ValidationFunction isJobKeyFromChain(@NotNull ImmutableChain chain) {
        return new JobKeyFromChainValidator(chain);
    }

    @NotNull
    public ValidationFunction isUniqueJobKey() {
        return this.uniqueJobKeyValidator;
    }

    private class UniqueJobKeyValidator
    implements ValidationFunction {
        private UniqueJobKeyValidator() {
        }

        public void validate(@NotNull String fieldName, @NotNull String jobKeyString, @NotNull ErrorCollection errorCollection) {
            PlanKey jobKey = PlanKeys.getPlanKey((String)jobKeyString);
            if (ValidationFunctionFactoryImpl.this.planManager.isPlanKeyConflicting(jobKey)) {
                errorCollection.addError(fieldName, ValidationFunctionFactoryImpl.this.textProvider.getText("job.error.exists", (List)ImmutableList.of((Object)jobKeyString)));
            }
        }
    }

    private class JobKeyFromChainValidator
    implements ValidationFunction {
        private final ImmutableChain chain;

        private JobKeyFromChainValidator(ImmutableChain chain) {
            this.chain = chain;
        }

        public void validate(@NotNull String fieldName, @NotNull String jobKeyString, @NotNull ErrorCollection errorCollection) {
            PlanKey jobKey = PlanKeys.getPlanKey((String)jobKeyString);
            if (!this.chain.getPlanKey().equals((Object)PlanKeys.getChainKeyFromJobKey((PlanKey)jobKey))) {
                errorCollection.addError(fieldName, ValidationFunctionFactoryImpl.this.textProvider.getText("job.key.invalidPlan", (List)ImmutableList.of((Object)jobKeyString)));
            }
        }
    }

    private class ChainExistsValidator
    extends PlanExistsValidator {
        private ChainExistsValidator() {
            super(ImmutableChain.class, "chain.error.noChain");
        }
    }

    private class JobExistsValidator
    extends PlanExistsValidator {
        private JobExistsValidator() {
            super(ImmutableJob.class, "job.error.noJob");
        }
    }

    private class PlanExistsValidator
    implements ValidationFunction {
        private final Class<? extends ImmutablePlan> planClass;
        private final String errorMessageKey;

        private PlanExistsValidator(@NotNull Class<? extends ImmutablePlan> planClass, String errorMessageKey) {
            this.planClass = planClass;
            this.errorMessageKey = errorMessageKey;
        }

        public void validate(@NotNull String fieldName, @NotNull String planKeyString, @NotNull ErrorCollection errorCollection) {
            PlanKey planKey = PlanKeys.getPlanKey((String)planKeyString);
            if (ValidationFunctionFactoryImpl.this.cachedPlanManager.getPlanByKeyIfOfType(planKey, this.planClass) == null) {
                errorCollection.addError(fieldName, ValidationFunctionFactoryImpl.this.textProvider.getText(this.errorMessageKey, (List)ImmutableList.of((Object)planKeyString)));
            }
        }
    }
}

