/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.validation;

import com.atlassian.bamboo.utils.BambooFieldValidate;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.validation.ValidationFunction;
import com.atlassian.bamboo.validation.ValidationService;
import com.opensymphony.xwork2.TextProvider;
import java.util.Collections;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValidationServiceImpl
implements ValidationService {
    public static final Pattern PARTIAL_JOB_KEY_PATTERN = Pattern.compile("[A-Z][A-Z0-9]{1,}");
    public static final String ILLEGAL_NAME_CHARACTERS = "[]{}<>:@/&%\\!|#$*;~";
    public static final int DATABASE_STRING_LIMIT = 255;
    private final TextProvider textProvider;

    public ValidationServiceImpl(TextProvider textProvider) {
        this.textProvider = textProvider;
    }

    @NotNull
    public ErrorCollection validateKey(@NotNull String fieldName, @NotNull ValidationService.ValidationType type, @Nullable String key, ValidationFunction ... functions) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        String errorPrefix = type.getErrorPrefix();
        if (StringUtils.isBlank((CharSequence)key)) {
            errorCollection.addError(fieldName, this.textProvider.getText(errorPrefix + ".key.empty"));
        } else if (!type.getKeyPattern().matcher(key).matches()) {
            errorCollection.addError(fieldName, this.textProvider.getText(errorPrefix + ".key.invalid"));
        } else if (key.length() > 255) {
            errorCollection.addError(fieldName, this.textProvider.getText(errorPrefix + ".key.tooLong"));
        } else {
            errorCollection.addErrorCollection(this.validate(fieldName, key, functions));
        }
        return errorCollection;
    }

    @NotNull
    public ErrorCollection validateJobKey(@NotNull String fieldName, @Nullable String jobKey, ValidationFunction ... functions) {
        return this.validateKey(fieldName, ValidationService.ValidationType.JOB, jobKey, functions);
    }

    @NotNull
    public ErrorCollection validateChainKey(@NotNull String fieldName, @Nullable String chainKey, ValidationFunction ... functions) {
        return this.validateKey(fieldName, ValidationService.ValidationType.CHAIN, chainKey, functions);
    }

    @NotNull
    public ErrorCollection validateProjectKey(@NotNull String fieldName, @Nullable String projectKey, ValidationFunction ... functions) {
        return this.validateKey(fieldName, ValidationService.ValidationType.PROJECT, projectKey, functions);
    }

    @NotNull
    public ErrorCollection validateName(@NotNull String fieldName, @NotNull String errorPrefix, @Nullable String name) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (StringUtils.isBlank((CharSequence)name)) {
            errorCollection.addError(fieldName, this.textProvider.getText(errorPrefix + ".name.empty", Collections.emptyList()));
        } else if (StringUtils.containsAny((CharSequence)name, (CharSequence)ILLEGAL_NAME_CHARACTERS)) {
            errorCollection.addError(fieldName, this.textProvider.getText(errorPrefix + ".name.invalid", Collections.emptyList()));
        } else if (name.length() > 255) {
            errorCollection.addError(fieldName, this.textProvider.getText(errorPrefix + ".name.tooLong", Collections.emptyList()));
        }
        return errorCollection;
    }

    @NotNull
    public ErrorCollection validateDescription(@NotNull String fieldName, @Nullable String description) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (description != null) {
            if (description.length() > 255) {
                errorCollection.addError(fieldName, this.textProvider.getText("description.tooLong"));
            }
            errorCollection.addErrorCollection(BambooFieldValidate.checkFieldXssSafety(this.textProvider, fieldName, description));
        }
        return errorCollection;
    }

    @NotNull
    private ErrorCollection validate(@NotNull String fieldName, @NotNull String fieldValue, ValidationFunction[] functions) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        for (ValidationFunction function : functions) {
            function.validate(fieldName, fieldValue, (ErrorCollection)errorCollection);
            if (errorCollection.hasAnyErrors()) break;
        }
        return errorCollection;
    }
}

