/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.validation;

import com.atlassian.bamboo.exception.YamlValidationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YamlValidatorHelper {
    public static int ensureInteger(@Nullable Object o) throws YamlValidationException {
        return Optional.ofNullable(YamlValidatorHelper.ensureIntegerOrNull(o)).orElseThrow(() -> new YamlValidationException("Expected Integer and it's null"));
    }

    @Nullable
    public static Integer ensureIntegerOrNull(@Nullable Object o) throws YamlValidationException {
        if (o == null || o instanceof Integer) {
            return (Integer)o;
        }
        throw new YamlValidationException("Expected Integer and it's " + o.getClass().getName());
    }

    public static boolean ensureBoolean(@Nullable Object o) throws YamlValidationException {
        return Optional.ofNullable(YamlValidatorHelper.ensureBooleanOrNull(o)).orElseThrow(() -> new YamlValidationException("Expected Boolean and it's null"));
    }

    @Nullable
    public static Boolean ensureBooleanOrNull(@Nullable Object o) throws YamlValidationException {
        if (o == null || o instanceof Boolean) {
            return (Boolean)o;
        }
        throw new YamlValidationException("Expected Boolean and it's " + o.getClass().getName());
    }

    @NotNull
    public static String ensureString(@Nullable Object o) throws YamlValidationException {
        return Optional.ofNullable(YamlValidatorHelper.ensureStringOrNull(o)).orElseThrow(() -> new YamlValidationException("Expected String and it's null"));
    }

    @Nullable
    public static String ensureStringOrNull(@Nullable Object o) throws YamlValidationException {
        if (o == null || o instanceof String) {
            return (String)o;
        }
        throw new YamlValidationException("Expected String and it's " + o.getClass().getName());
    }

    @Nullable
    public static Map<?, ?> ensureMapOrNull(@Nullable Object o) throws YamlValidationException {
        if (o == null || o instanceof Map) {
            return (Map)o;
        }
        throw new YamlValidationException("Expected Map and it's " + o.getClass().getName());
    }

    @Nullable
    public static Map<String, Object> ensureMapOfStringToObjectOrNull(@Nullable Object o) throws YamlValidationException {
        Map<?, ?> map = YamlValidatorHelper.ensureMapOrNull(o);
        if (map == null) {
            return null;
        }
        boolean allKeysAreStrings = map.keySet().stream().allMatch(String.class::isInstance);
        if (!allKeysAreStrings) {
            throw new YamlValidationException("Expected that all keys in Map are Strings");
        }
        return (Map)o;
    }

    @NotNull
    public static Map<String, Object> ensureMapOfStringToObject(@Nullable Object o) throws YamlValidationException {
        return Optional.ofNullable(YamlValidatorHelper.ensureMapOfStringToObjectOrNull(o)).orElseThrow(() -> new YamlValidationException("Expected Map and it's null"));
    }

    @Nullable
    public static List<?> ensureListOrNull(@Nullable Object o) throws YamlValidationException {
        if (o == null || o instanceof List) {
            return (List)o;
        }
        throw new YamlValidationException("Expected List and it's " + o.getClass().getName());
    }

    @Nullable
    public static List<Map<String, Object>> ensureListOfMapsOfStringToObjectOrNull(@Nullable Object o) throws YamlValidationException {
        List<?> list = YamlValidatorHelper.ensureListOrNull(o);
        if (list == null) {
            return null;
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (Object listElement : list) {
            Map<String, Object> map = YamlValidatorHelper.ensureMapOfStringToObjectOrNull(listElement);
            if (map == null) continue;
            result.add(map);
        }
        return result;
    }

    @Nullable
    public static Map<String, String> ensureMapOfStringToStringOrNull(@Nullable Object o) throws YamlValidationException {
        Map<String, Object> m = YamlValidatorHelper.ensureMapOfStringToObjectOrNull(o);
        if (m == null) {
            return null;
        }
        boolean allValuesAreStrings = m.values().stream().allMatch(String.class::isInstance);
        if (!allValuesAreStrings) {
            throw new YamlValidationException("Expected that all values in Map are Strings");
        }
        return (Map)o;
    }

    @Nullable
    public static <T extends Enum<T>> T ensureConstantOfEnumOrNull(@NotNull Class<T> enumClass, @Nullable Object o) throws YamlValidationException {
        String s = YamlValidatorHelper.ensureStringOrNull(o);
        if (s == null) {
            return null;
        }
        List enumNames = Arrays.stream(enumClass.getEnumConstants()).map(Enum::name).collect(Collectors.toList());
        return (T)enumNames.stream().filter(s::equals).findAny().map(val -> Enum.valueOf(enumClass, val)).orElseThrow(() -> new YamlValidationException(String.format("Expected one of the following values: %s, but was: %s", enumNames, s)));
    }
}

