/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.variable;

import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.branches.MergeResultSummary;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.vcs.RepositoryChangeset;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.BuildChanges;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.bamboo.variable.VariableDefinitionContextImpl;
import com.atlassian.bamboo.variable.VariableType;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuiltInVariableHelper {
    private static final Logger log = Logger.getLogger(BuiltInVariableHelper.class);
    public static final String NAMESPACE_BAMBOO = "bamboo";
    public static final String NAMESPACE_SYSTEM = "system";
    public static final String PLAN_KEY = "planKey";
    public static final String PLAN_NAME = "planName";
    public static final String SHORT_PLAN_KEY = "shortPlanKey";
    public static final String SHORT_PLAN_NAME = "shortPlanName";
    public static final String BUILD_NUMBER = "buildNumber";
    public static final String PLAN_RESULT_KEY = "planResultKey";
    public static final String BUILD_RESULT_KEY = "buildResultKey";
    public static final String SHORT_JOB_KEY = "shortJobKey";
    public static final String SHORT_JOB_NAME = "shortJobName";
    public static final String BUILD_RESULTS_URL = "buildResultsUrl";
    public static final String RESULTS_URL = "resultsUrl";
    public static final String BUILD_KEY = "buildKey";
    public static final String BUILD_PLAN_NAME = "buildPlanName";
    public static final String AGENT_ID = "agentId";
    public static final String AGENT_WORKING_DIRECTORY = "agentWorkingDirectory";
    public static final String REPOSITORY_VAR_PREFIX = "planRepository";
    public static final String REPOSITORY_NAME = ".name";
    public static final String REPOSITORY_REVISION = ".revision";
    public static final String REPOSITORY_PREVIOUS_REVISION = ".previousRevision";
    public static final String REPOSITORY_TYPE = ".type";
    public static final String REPOSITORY_BRANCH_NAME = ".branchName";
    public static final String REPOSITORY_BRANCH_DISPLAY_NAME = ".branchDisplayName";
    public static final String INTEGRATION_BRANCH = "integrationBranch";
    public static final String MERGED_REVISION = "branchIntegration.mergeRevision";
    public static final String PR_KEY = "repository.pr.key";
    public static final String PR_SOURCE_BRANCH = "repository.pr.sourceBranch";
    public static final String PR_TARGET_BRANCH = "repository.pr.targetBranch";
    public static final String DEPLOY_PREFIX = "deploy";
    public static final String DEPLOYMENT_PROJECT = "deploy.project";
    public static final String ENVIRONMENT = "deploy.environment";
    public static final String DEPLOYMENT_RELEASE = "deploy.release";
    public static final String DEPLOYMENT_PREVIOUS_RELEASE = "deploy.release.previous";
    @Deprecated
    public static final String DEPLOYMENT_VERSION = "deploy.version";
    @Deprecated
    public static final String DEPLOYMENT_PREVIOUS_VERSION = "deploy.version.previous";
    public static final String IS_ROLLBACK = "deploy.rollback";

    public static void addVariableContext(@NotNull Map<String, VariableDefinitionContext> variables, @NotNull String key, @Nullable String value, @NotNull VariableType variableType) {
        if (value != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding variable to variables context: <" + key + ">: <" + value + "> <" + variableType));
            }
            variables.put(key, new VariableDefinitionContextImpl(key, value, variableType));
        }
    }

    private static void createVariablesFromChangeset(@NotNull Map<String, VariableDefinitionContext> variables, @Nullable String index, @NotNull VcsRepositoryData repositoryData, @Nullable String changeSetId, @Nullable String previousChangeSetId, @NotNull VariableType variableType, @NotNull VcsRepositoryManager vcsRepositoryManager) {
        VcsRepositoryModuleDescriptor moduleDescriptor = vcsRepositoryManager.getVcsRepositoryModuleDescriptor(repositoryData.getPluginKey());
        String prefix = REPOSITORY_VAR_PREFIX;
        if (index != null) {
            prefix = prefix + "." + index;
        }
        BuiltInVariableHelper.addVariableContext(variables, prefix + REPOSITORY_NAME, repositoryData.getName(), variableType);
        if (changeSetId != null) {
            BuiltInVariableHelper.addVariableContext(variables, prefix + REPOSITORY_REVISION, changeSetId, variableType);
        }
        if (previousChangeSetId != null) {
            BuiltInVariableHelper.addVariableContext(variables, prefix + REPOSITORY_PREVIOUS_REVISION, previousChangeSetId, variableType);
        }
        if (moduleDescriptor != null) {
            BuiltInVariableHelper.addVariableContext(variables, prefix + REPOSITORY_TYPE, moduleDescriptor.getTypeString(), variableType);
        }
        if (repositoryData.getBranch() != null) {
            BuiltInVariableHelper.addVariableContext(variables, prefix + REPOSITORY_BRANCH_NAME, repositoryData.getBranch().getVcsBranch().getName(), variableType);
            BuiltInVariableHelper.addVariableContext(variables, prefix + REPOSITORY_BRANCH_DISPLAY_NAME, repositoryData.getBranch().getVcsBranch().getDisplayName(), variableType);
        }
        if (moduleDescriptor != null && moduleDescriptor.providesCustomVariables()) {
            for (Map.Entry variable : moduleDescriptor.getVariableGenerator().getPlanRepositoryVariables(repositoryData).entrySet()) {
                BuiltInVariableHelper.addVariableContext(variables, prefix + "." + (String)variable.getKey(), (String)variable.getValue(), variableType);
            }
        }
    }

    public static void createRepositoryVariables(@NotNull Map<String, VariableDefinitionContext> variables, @NotNull ResultsSummary resultsSummary, @NotNull VariableType variableType, @NotNull RepositoryDefinitionManager repositoryDefinitionManager, @NotNull VcsRepositoryManager vcsRepositoryManager) {
        MergeResultSummary mergeResultSummary = null;
        ChainResultsSummary chainResultsSummary = (ChainResultsSummary)Narrow.downTo((Object)resultsSummary, ChainResultsSummary.class);
        if (chainResultsSummary != null) {
            mergeResultSummary = chainResultsSummary.getMergeResult();
        }
        for (RepositoryChangeset changeset : resultsSummary.getRepositoryChangesets()) {
            VcsRepositoryData repositoryData = repositoryDefinitionManager.entityToVcsData(changeset.getRepositoryData());
            int index = changeset.getPosition() + 1;
            if (index == 1) {
                if (mergeResultSummary != null && mergeResultSummary.getIntegrationRepositoryId() == repositoryData.getId()) {
                    BuiltInVariableHelper.createVariablesFromChangeset(variables, INTEGRATION_BRANCH, repositoryData, changeset.getChangesetId(), null, variableType, vcsRepositoryManager);
                    if (mergeResultSummary.getMergeResultVcsKey() == null) continue;
                    BuiltInVariableHelper.addVariableContext(variables, MERGED_REVISION, mergeResultSummary.getMergeResultVcsKey(), variableType);
                    continue;
                }
                BuiltInVariableHelper.createVariablesFromChangeset(variables, null, repositoryData, changeset.getChangesetId(), null, variableType, vcsRepositoryManager);
            }
            BuiltInVariableHelper.createVariablesFromChangeset(variables, Integer.toString(index), repositoryData, changeset.getChangesetId(), null, variableType, vcsRepositoryManager);
        }
    }

    public static void createRepositoryVariables(@NotNull Map<String, VariableDefinitionContext> variables, @NotNull List<PlanRepositoryDefinition> repositoryDefinitions, @NotNull BuildChanges buildChanges, @NotNull VariableType variableType, @NotNull VcsRepositoryManager vcsRepositoryManager) {
        for (PlanRepositoryDefinition repositoryDefinition : repositoryDefinitions) {
            int index = repositoryDefinition.getPosition() + 1;
            String changeSetId = null;
            String previousChangesetId = null;
            try {
                changeSetId = buildChanges.getVcsRevisionKey(repositoryDefinition.getId());
                previousChangesetId = buildChanges.getPreviousVcsRevisionKey(repositoryDefinition.getId());
            }
            catch (IllegalArgumentException e) {
                log.debug((Object)("No changeset for repository " + repositoryDefinition.getName() + ". Creation of revision variables failed"), (Throwable)e);
            }
            if (index == 1) {
                if (buildChanges.getIntegrationRepositoryId() == repositoryDefinition.getId()) {
                    BuiltInVariableHelper.createVariablesFromChangeset(variables, INTEGRATION_BRANCH, (VcsRepositoryData)repositoryDefinition, changeSetId, previousChangesetId, variableType, vcsRepositoryManager);
                    continue;
                }
                BuiltInVariableHelper.createVariablesFromChangeset(variables, null, (VcsRepositoryData)repositoryDefinition, changeSetId, previousChangesetId, variableType, vcsRepositoryManager);
            }
            BuiltInVariableHelper.createVariablesFromChangeset(variables, Integer.toString(index), (VcsRepositoryData)repositoryDefinition, changeSetId, previousChangesetId, variableType, vcsRepositoryManager);
        }
    }

    private BuiltInVariableHelper() {
    }
}

