/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.variable;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.BambooCallables;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.bamboo.variable.VariableSubstitutionContext;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutor;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutorFactory;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomVariableContextImpl
implements CustomVariableContext {
    private static final Logger log = Logger.getLogger(CustomVariableContextImpl.class);
    private static final ThreadLocal<VariableSubstitutor> variableSubstitutorRef = new ThreadLocal();
    @Inject
    private VariableSubstitutorFactory variableSubstitutorFactory;

    private CustomVariableContextImpl() {
    }

    public CustomVariableContextImpl(VariableSubstitutorFactory variableSubstitutorFactory) {
        this.variableSubstitutorFactory = variableSubstitutorFactory;
    }

    public void setPlan(@NotNull PlanIdentifier planIdentifier, @Nullable Map<String, VariableDefinitionContext> variablesContextMap) {
        if (variablesContextMap != null) {
            variableSubstitutorRef.set(this.variableSubstitutorFactory.newSubstitutorForVariables(variablesContextMap));
        } else {
            ImmutablePlan plan = (ImmutablePlan)Narrow.downTo((Object)planIdentifier, ImmutablePlan.class);
            if (plan == null) {
                plan = ((CachedPlanManager)ComponentAccessor.CACHED_PLAN_MANAGER.get()).getPlanByKey(planIdentifier.getPlanKey());
            }
            if (plan != null) {
                variableSubstitutorRef.set(this.variableSubstitutorFactory.newSubstitutorForPlan(plan));
            } else {
                log.warn((Object)("Plan with key " + planIdentifier.getPlanKey() + " not found"));
                variableSubstitutorRef.set(this.variableSubstitutorFactory.newSubstitutorForGlobalContext());
            }
        }
    }

    public void setPlan(@NotNull ImmutablePlan plan) {
        variableSubstitutorRef.set(this.variableSubstitutorFactory.newSubstitutorForPlan(plan));
    }

    public void setPlan(@NotNull ImmutablePlan plan, @Nullable Map<String, VariableDefinitionContext> variablesContextMap) {
        if (variablesContextMap != null) {
            variableSubstitutorRef.set(this.variableSubstitutorFactory.newSubstitutorForVariables(variablesContextMap));
        } else {
            variableSubstitutorRef.set(this.variableSubstitutorFactory.newSubstitutorForPlan(plan));
        }
    }

    public void setVariables(Map<String, VariableDefinitionContext> variablesContextMap) {
        variableSubstitutorRef.set(this.variableSubstitutorFactory.newSubstitutorForVariables(variablesContextMap));
    }

    public void setCommonContext(@NotNull CommonContext commonContext) {
        variableSubstitutorRef.set(this.variableSubstitutorFactory.newSubstitutorForCommonContext(commonContext));
    }

    public void clearContext() {
        variableSubstitutorRef.remove();
    }

    @NotNull
    public Map<String, VariableSubstitutionContext> getSubstitutedVariables() {
        return this.safeGetCurrentSubstitutor().getSubstitutedVariables();
    }

    public void addCustomData(String key, String value) {
        this.safeGetCurrentSubstitutor().addLocalVariable(key, value);
    }

    public String substituteString(String value) {
        return this.safeGetCurrentSubstitutor().substituteString(value);
    }

    public String substituteString(String value, @Nullable CommonContext commonContext, BuildLogger buildLogger) {
        return this.variableSubstitutorFactory.newSubstitutorForCommonContext(commonContext).substituteString(value);
    }

    @NotNull
    public String removeAllVariables(@NotNull String value) {
        return this.variableSubstitutorFactory.newSubstitutorForVariables(Collections.emptyMap()).removeAllVariables(value);
    }

    @NotNull
    public Set<String> findAllVariables(@Nullable String variable) {
        return this.variableSubstitutorFactory.newSubstitutorForVariables(Collections.emptyMap()).findAllVariables(variable);
    }

    @NotNull
    public Map<String, VariableDefinitionContext> getVariableContexts(@Nullable CommonContext commonContext) {
        return this.variableSubstitutorFactory.newSubstitutorForCommonContext(commonContext).getVariableContexts();
    }

    @NotNull
    public Map<String, VariableDefinitionContext> getVariableContexts() {
        return this.safeGetCurrentSubstitutor().getVariableContexts();
    }

    @NotNull
    public Map<String, String> getVariables(@Nullable CommonContext buildContext) {
        LinkedHashMap<String, String> simpleVariables = new LinkedHashMap<String, String>();
        Map<String, VariableDefinitionContext> variables = this.getVariableContexts(buildContext);
        for (Map.Entry<String, VariableDefinitionContext> entry : variables.entrySet()) {
            simpleVariables.put(entry.getKey(), entry.getValue().getValue());
        }
        return simpleVariables;
    }

    public Map<String, VariableDefinitionContext> getBuildInRepositoryVariablesIfBuildContext() {
        return this.safeGetCurrentSubstitutor().getBuiltInRepositoryVariablesIfBuildContext();
    }

    @NotNull
    public VariableSubstitutorFactory getVariableSubstitutorFactory() {
        return this.variableSubstitutorFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withVariableSubstitutor(@NotNull VariableSubstitutor variableSubstitutor, @NotNull Runnable runnable) {
        VariableSubstitutor temp = variableSubstitutorRef.get();
        try {
            variableSubstitutorRef.set(variableSubstitutor);
            runnable.run();
        }
        finally {
            variableSubstitutorRef.set(temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V withVariableSubstitutor(@NotNull VariableSubstitutor variableSubstitutor, @NotNull Callable<V> callable) throws Exception {
        VariableSubstitutor temp = variableSubstitutorRef.get();
        try {
            variableSubstitutorRef.set(variableSubstitutor);
            V v = callable.call();
            return v;
        }
        finally {
            variableSubstitutorRef.set(temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V withVariableSubstitutor(@NotNull VariableSubstitutor variableSubstitutor, @NotNull Supplier<V> supplier) {
        VariableSubstitutor temp = variableSubstitutorRef.get();
        try {
            variableSubstitutorRef.set(variableSubstitutor);
            V v = supplier.get();
            return v;
        }
        finally {
            variableSubstitutorRef.set(temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V, E1 extends Exception, E2 extends Exception, E3 extends Exception> V withVariableSubstitutor(@NotNull VariableSubstitutor variableSubstitutor, @NotNull BambooCallables.ThrowingX<V, E1, E2, E3> callable) throws E1, E2, E3 {
        VariableSubstitutor temp = variableSubstitutorRef.get();
        try {
            variableSubstitutorRef.set(variableSubstitutor);
            Object object = callable.call();
            return (V)object;
        }
        finally {
            variableSubstitutorRef.set(temp);
        }
    }

    private VariableSubstitutor safeGetCurrentSubstitutor() {
        if (variableSubstitutorRef.get() == null) {
            if (BuildUtils.isDevMode()) {
                throw new IllegalStateException("No variable context in current thread. Cannot substitute variables");
            }
            return this.variableSubstitutorFactory.newSubstitutorForGlobalContext();
        }
        return variableSubstitutorRef.get();
    }
}

