/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.variable;

import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.CustomVariableContextRunner;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutor;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutorFactory;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Lazy;

public class CustomVariableContextRunnerImpl
implements CustomVariableContextRunner {
    private static final Logger log = Logger.getLogger(CustomVariableContextRunnerImpl.class);
    private final CustomVariableContext customVariableContext;
    @Lazy
    @Inject
    private VariableSubstitutorFactory variableSubstitutorFactory;

    public CustomVariableContextRunnerImpl(CustomVariableContext customVariableContext) {
        this.customVariableContext = customVariableContext;
    }

    public void execute(CommonContext context, @NotNull Runnable runnable) {
        this.customVariableContext.withVariableSubstitutor(this.variableSubstitutorFactory.newSubstitutorForCommonContext(context), runnable);
    }

    public void execute(PlanIdentifier plan, @NotNull Runnable runnable) {
        this.customVariableContext.withVariableSubstitutor(this.getSubstitutorForPlanIdentifier(plan), runnable);
    }

    public <V> V execute(CommonContext context, @NotNull Callable<V> callable) throws Exception {
        return (V)this.customVariableContext.withVariableSubstitutor(this.variableSubstitutorFactory.newSubstitutorForCommonContext(context), callable);
    }

    public <V> V execute(PlanIdentifier plan, @NotNull Callable<V> callable) throws Exception {
        return (V)this.customVariableContext.withVariableSubstitutor(this.getSubstitutorForPlanIdentifier(plan), callable);
    }

    @NotNull
    private VariableSubstitutor getSubstitutorForPlanIdentifier(PlanIdentifier planIdentifier) {
        ImmutablePlan plan = (ImmutablePlan)Narrow.downTo((Object)planIdentifier, ImmutablePlan.class);
        if (plan == null) {
            plan = ((CachedPlanManager)ComponentAccessor.CACHED_PLAN_MANAGER.get()).getPlanByKey(planIdentifier.getPlanKey());
        }
        if (plan != null) {
            return this.variableSubstitutorFactory.newSubstitutorForPlan(plan);
        }
        log.warn((Object)("Plan with key " + planIdentifier.getPlanKey() + " not found"));
        return this.variableSubstitutorFactory.newSubstitutorForGlobalContext();
    }
}

