/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.variable;

import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.bamboo.variable.VariableType;
import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public final class SubstitutedVariableDefinitionContextImpl
implements VariableDefinitionContext {
    private final VariableDefinitionContext original;
    private String value;

    public SubstitutedVariableDefinitionContextImpl(VariableDefinitionContext original, List<String> keysToReplace, Map<String, VariableDefinitionContext> valuesToReplaceWith) {
        this.original = original;
        String replacedValue = original.getValue();
        for (String keyToReplace : keysToReplace) {
            if ((long)(replacedValue = replacedValue.replace(String.format("${bamboo.%s}", keyToReplace), valuesToReplaceWith.get(keyToReplace).getValue())).length() <= 4000L) continue;
            throw new IllegalArgumentException(String.format("Can't resolve variable by key: %s because resolved value exceeds max value length: %d", this.getKey(), 4000L));
        }
        this.value = replacedValue;
    }

    @NotNull
    public String getKey() {
        return this.original.getKey();
    }

    public String getValue() {
        return StringUtils.defaultString((String)this.value);
    }

    public void setKey(String key) {
        this.original.setKey(key);
    }

    public void setValue(String value) {
        this.value = value;
    }

    public VariableType getVariableType() {
        return this.original.getVariableType();
    }

    public void setVariableType(VariableType variableType) {
        this.original.setVariableType(variableType);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("variableType", (Object)this.getVariableType()).add("key", (Object)this.getKey()).add("value", (Object)this.value).toString();
    }
}

