/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.variable;

import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.variable.VariableDefinition;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.bamboo.variable.VariableType;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class VariableComparators {
    private static final Logger log = Logger.getLogger(VariableComparators.class);

    private VariableComparators() {
    }

    @NotNull
    public static Ordering<VariableDefinitionContext> getVariableDefinitionContextOrdering() {
        return VariableDefinitionContextComparator.ORDERING;
    }

    @NotNull
    public static Ordering<VariableDefinition> getVariableDefinitionOrdering() {
        return VariableDefinitionComparator.ORDERING;
    }

    private static class VariableDefinitionContextComparator
    implements Comparator<VariableDefinitionContext> {
        public static final Ordering<VariableDefinitionContext> ORDERING = Ordering.from((Comparator)new VariableDefinitionContextComparator());
        private static final Ordering<VariableType> VARIABLE_TYPE_ORDERING = Ordering.explicit((List)Lists.newArrayList((Object[])new VariableType[]{VariableType.PLAN, VariableType.JOB, VariableType.VERSION, VariableType.ENVIRONMENT, VariableType.RESULT, VariableType.MANUAL, VariableType.CUSTOM, VariableType.GLOBAL, VariableType.SYSTEM, VariableType.UNKNOWN}));

        private VariableDefinitionContextComparator() {
        }

        @Override
        public int compare(VariableDefinitionContext o1, VariableDefinitionContext o2) {
            if (o1 == null || o2 == null) {
                return o1 == o2 ? 0 : (o1 == null ? -1 : 1);
            }
            return new CompareToBuilder().append((Object)o1.getVariableType(), (Object)o2.getVariableType(), VARIABLE_TYPE_ORDERING).append((Object)o1.getKey(), (Object)o2.getKey()).toComparison();
        }
    }

    private static class VariableDefinitionComparator
    implements Comparator<VariableDefinition> {
        public static final Ordering<VariableDefinition> ORDERING = Ordering.from((Comparator)new VariableDefinitionComparator());

        private VariableDefinitionComparator() {
        }

        @Override
        public int compare(VariableDefinition o1, VariableDefinition o2) {
            if (o1 == null || o2 == null) {
                return o1 == o2 ? 0 : (o1 == null ? -1 : 1);
            }
            Plan p1 = o1.getPlan();
            Plan p2 = o2.getPlan();
            CompareToBuilder builder = new CompareToBuilder();
            if (p1 != null && p2 != null) {
                builder.append((Object)p1.getName(), (Object)p2.getName());
            } else {
                builder.append((Object)p1, (Object)p2);
            }
            return builder.append((Object)o1.getKey(), (Object)o2.getKey()).toComparison();
        }
    }
}

